/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import icons.XpathIcons;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.completion.CompletionLists;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.references.PrefixReference;
import org.intellij.lang.xpath.xslt.psi.impl.XsltLanguage;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitModeElement
extends LightElement
implements PsiNamedElement,
NavigationItem,
ItemPresentation {
    private final XmlAttribute myAttribute;
    private PsiElement myNavigationElement;

    public ImplicitModeElement(XmlAttribute attribute) {
        super(attribute.getManager(), (Language)XsltLanguage.INSTANCE);
        this.myAttribute = attribute;
    }

    @Nullable
    public QName getQName() {
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String uri = XsltNamespaceContext.getNamespaceUriStatic(prefix, (XmlElement)this.myAttribute);
            return uri != null && !uri.isEmpty() ? new QName(uri, this.getName(), prefix) : QNameUtil.UNRESOLVED;
        }
        return new QName(this.getName());
    }

    @Nullable
    private String getPrefix() {
        return this.hasPrefix() ? PrefixReference.getPrefixRange(this.myAttribute).substring(this.myAttribute.getValue()) : null;
    }

    public Icon getIcon(int i) {
        return XpathIcons.Template;
    }

    public String getName() {
        return this.getModeRange().substring(this.myAttribute.getValue());
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            ImplicitModeElement.$$$reportNull$$$0(0);
        }
        return this;
    }

    public String toString() {
        return "Mode: " + this.getName();
    }

    public PsiElement copy() {
        return this;
    }

    public String getText() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ImplicitModeElement that = (ImplicitModeElement)((Object)o);
        return QNameUtil.equal(this.getQName(), that.getQName());
    }

    public int hashCode() {
        QName qName = this.getQName();
        return qName != null ? qName.hashCode() : 0;
    }

    public boolean isPhysical() {
        return this.myAttribute.isPhysical();
    }

    public boolean isWritable() {
        return this.myAttribute.isWritable();
    }

    public boolean isValid() {
        return this.myAttribute.isValid();
    }

    public int getTextOffset() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        return value != null ? value.getTextOffset() + this.getModeRange().getStartOffset() : 0;
    }

    public TextRange getTextRange() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        return value != null ? TextRange.from((int)(value.getTextOffset() + this.getModeRange().getStartOffset()), (int)this.getModeRange().getLength()) : TextRange.from((int)0, (int)0);
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.getIcon(0);
    }

    @Nullable
    @NlsSafe
    public String getPresentableText() {
        QName qName = this.getQName();
        if (qName != null) {
            return qName.toString();
        }
        return this.hasPrefix() ? this.getPrefix() + ":" + this.getName() : this.getName();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        if (this.myNavigationElement == null && this.myAttribute.isValid()) {
            final XmlTag tag = this.myAttribute.getParent();
            Class[] allInterfaces = CompletionLists.getAllInterfaces(tag.getClass());
            this.myNavigationElement = (PsiElement)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), allInterfaces, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        ImplicitModeElement nameElement = ImplicitModeElement.this;
                        return switch (method.getName()) {
                            case "navigate" -> {
                                nameElement.navigate((Boolean)args[0]);
                                yield null;
                            }
                            case "canNavigate" -> nameElement.canNavigate();
                            case "getTextOffset" -> nameElement.getTextOffset();
                            default -> method.invoke((Object)tag, args);
                        };
                    }
                    catch (InvocationTargetException e1) {
                        throw e1.getTargetException();
                    }
                }
            });
        }
        ImplicitModeElement implicitModeElement = this.myAttribute.isValid() ? this.myNavigationElement : this;
        if (implicitModeElement == null) {
            ImplicitModeElement.$$$reportNull$$$0(1);
        }
        return implicitModeElement;
    }

    public boolean canNavigate() {
        return this.isValid() && this.myAttribute.getValueElement() != null;
    }

    public void navigate(boolean b) {
        Navigatable navigatable = (Navigatable)this.myAttribute.getValueElement();
        if (navigatable != null) {
            navigatable.navigate(b);
        }
    }

    public PsiElement getOriginalElement() {
        return this.myAttribute;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = this.myAttribute.getUseScope();
        if (searchScope == null) {
            ImplicitModeElement.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    public PsiElement getParent() {
        return this.myAttribute.getParent();
    }

    public PsiFile getContainingFile() {
        return this.myAttribute.getContainingFile();
    }

    public TextRange getModeRange() {
        String value = this.myAttribute.getValue();
        int p = value.indexOf(58);
        if (p == -1) {
            return TextRange.from((int)0, (int)value.length());
        }
        if (p == value.length() - 1) {
            return TextRange.from((int)0, (int)0);
        }
        return new TextRange(p + 1, value.length());
    }

    public boolean hasPrefix() {
        return this.myAttribute.getValue().indexOf(58) != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/psi/impl/ImplicitModeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/psi/impl/ImplicitModeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

