/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.lang.Language;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import java.util.BitSet;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ImplicitTypeConversion
extends XPathInspection {
    @NonNls
    private static final String SHORT_NAME = "ImplicitTypeConversion";
    private static final String STRING = "STRING";
    private static final String NODESET = "NODESET";
    private static final String NUMBER = "NUMBER";
    private static final String BOOLEAN = "BOOLEAN";
    public long BITS = 1720L;
    private final BitSet OPTIONS = new BitSet(12);
    public boolean FLAG_EXPLICIT_CONVERSION = true;
    public boolean IGNORE_NODESET_TO_BOOLEAN_VIA_STRING = true;

    public ImplicitTypeConversion() {
        this.update();
    }

    private void update() {
        for (int i = 0; i < 12; ++i) {
            boolean b = (this.BITS & (long)(1 << i)) != 0L;
            this.OPTIONS.set(i, b);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected XPathInspection.Visitor createVisitor(InspectionManager manager, boolean isOnTheFly) {
        return new MyElementVisitor(manager, isOnTheFly);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.group((String)XPathBundle.message("label.to", STRING), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"0", (String)XPathBundle.message("label.from", NODESET), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"2", (String)XPathBundle.message("label.from", NUMBER), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"3", (String)XPathBundle.message("label.from", BOOLEAN), (OptRegularComponent[])new OptRegularComponent[0])}).prefix("c"), OptPane.group((String)XPathBundle.message("label.to", NUMBER), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"4", (String)XPathBundle.message("label.from", NODESET), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"5", (String)XPathBundle.message("label.from", STRING), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"7", (String)XPathBundle.message("label.from", BOOLEAN), (OptRegularComponent[])new OptRegularComponent[0])}).prefix("c"), OptPane.group((String)XPathBundle.message("label.to", BOOLEAN), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"8", (String)XPathBundle.message("label.from", NODESET), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"9", (String)XPathBundle.message("label.from", STRING), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"10", (String)XPathBundle.message("label.from", NUMBER), (OptRegularComponent[])new OptRegularComponent[0])}).prefix("c"), OptPane.separator(), OptPane.checkbox((String)"FLAG_EXPLICIT_CONVERSION", (String)XPathBundle.message("checkbox.always.flag.explicit.conversion.to.unexpected.type", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_NODESET_TO_BOOLEAN_VIA_STRING", (String)XPathBundle.message("checkbox.ignore.conversion.of.nodeset.to.boolean.by.string.conversion", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("c", bindId -> this.OPTIONS.get(Integer.parseInt(bindId)), (bindId, value) -> this.OPTIONS.set(Integer.parseInt(bindId), (Boolean)value));
        if (optionController == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        this.update();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(3);
        }
        this.BITS = 0L;
        for (int i = 11; i >= 0; --i) {
            this.BITS <<= 1;
            if (!this.OPTIONS.get(i)) continue;
            this.BITS |= 1L;
        }
        super.writeSettings(node);
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/validation/inspections/ImplicitTypeConversion";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/ImplicitTypeConversion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    final class MyElementVisitor
    extends XPathInspection.Visitor {
        MyElementVisitor(InspectionManager manager, boolean isOnTheFly) {
            super(manager, isOnTheFly);
        }

        @Override
        protected void checkExpression(@NotNull XPathExpression expression) {
            XPathType expectedType;
            if (expression == null) {
                MyElementVisitor.$$$reportNull$$$0(0);
            }
            if ((expectedType = ExpectedTypeUtil.getExpectedType(expression)) != XPathType.NODESET && expectedType != XPathType.UNKNOWN) {
                boolean isExplicit = ImplicitTypeConversion.this.FLAG_EXPLICIT_CONVERSION && ExpectedTypeUtil.isExplicitConversion(expression);
                this.checkExpressionOfType(expression, expectedType, isExplicit);
            }
        }

        private void checkExpressionOfType(@NotNull XPathExpression expression, XPathType type, boolean explicit) {
            XPathType exprType;
            if (expression == null) {
                MyElementVisitor.$$$reportNull$$$0(1);
            }
            if ((exprType = expression.getType()).isAbstract() || type.isAbstract()) {
                return;
            }
            if (exprType != type && (explicit || this.isCheckedConversion(exprType, type))) {
                XPathQuickFixFactory.Fix<XPathExpression>[] fixes;
                XPathExpression expr;
                if (explicit && exprType == XPathType.STRING && type == XPathType.BOOLEAN && (expr = ExpectedTypeUtil.unparenthesize(expression)) instanceof XPathFunctionCall && ImplicitTypeConversion.this.IGNORE_NODESET_TO_BOOLEAN_VIA_STRING && ((XPathFunctionCall)expr).getArgumentList()[0].getType() == XPathType.NODESET) {
                    return;
                }
                if (type != XPathType.NODESET) {
                    XPathQuickFixFactory fixFactory = ContextProvider.getContextProvider(expression).getQuickFixFactory();
                    explicit = explicit && (exprType != XPathType.STRING || type != XPathType.BOOLEAN);
                    fixes = fixFactory.createImplicitTypeConversionFixes(expression, type, explicit);
                } else {
                    fixes = null;
                }
                this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expression, XPathBundle.message("inspection.message.expression.should.be.type", type.getName()), this.myOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
        }

        private boolean isCheckedConversion(XPathType exprType, XPathType type) {
            if (exprType == XPathType.NODESET) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(0)) {
                    return true;
                }
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(4)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(8)) {
                    return true;
                }
            } else if (exprType == XPathType.STRING) {
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(5)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(9)) {
                    return true;
                }
            } else if (exprType == XPathType.NUMBER) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(2)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(10)) {
                    return true;
                }
            } else if (exprType == XPathType.BOOLEAN) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(3)) {
                    return true;
                }
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(11)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/ImplicitTypeConversion$MyElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpressionOfType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

