/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u001d\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u0019*\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0016\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "", "codeInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "name", "", "parameters", "", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "<init>", "(Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;Ljava/lang/String;Ljava/util/Collection;)V", "getCodeInfo", "()Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "getName", "()Ljava/lang/String;", "getParameters", "()Ljava/util/Collection;", "parameterMap", "", "getParameterMap", "()Ljava/util/Map;", "parameterMap$delegate", "Lkotlin/Lazy;", "substitutedExpression", "Lcom/intellij/sql/psi/SqlExpression;", "Lorg/jetbrains/annotations/Nullable;", "getSubstitutedExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "substitutedExpression$delegate", "getReplacement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractableCodeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1208#2,2:201\n1236#2,4:203\n1#3:207\n*S KotlinDebug\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo\n*L\n129#1:201,2\n129#1:203,4\n*E\n"})
public final class SqlExtractFunctionInfo {
    @NotNull
    private final SqlExtractableCodeInfo codeInfo;
    @NotNull
    private final String name;
    @NotNull
    private final Collection<SqlExtractableParameterInfo> parameters;
    @NotNull
    private final Lazy parameterMap$delegate;
    @NotNull
    private final Lazy substitutedExpression$delegate;

    public SqlExtractFunctionInfo(@NotNull SqlExtractableCodeInfo codeInfo, @NotNull String name2, @NotNull Collection<? extends SqlExtractableParameterInfo> parameters) {
        Intrinsics.checkNotNullParameter((Object)codeInfo, (String)"codeInfo");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.codeInfo = codeInfo;
        this.name = name2;
        this.parameters = parameters;
        this.parameterMap$delegate = LazyKt.lazy(() -> SqlExtractFunctionInfo.parameterMap_delegate$lambda$1(this));
        this.substitutedExpression$delegate = LazyKt.lazy(() -> SqlExtractFunctionInfo.substitutedExpression_delegate$lambda$4(this));
    }

    @NotNull
    public final SqlExtractableCodeInfo getCodeInfo() {
        return this.codeInfo;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Collection<SqlExtractableParameterInfo> getParameters() {
        return this.parameters;
    }

    private final Map<SqlExtractableParameterInfo, SqlExtractableParameterInfo> getParameterMap() {
        Lazy lazy = this.parameterMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final SqlExpression getSubstitutedExpression() {
        Lazy lazy = this.substitutedExpression$delegate;
        return (SqlExpression)lazy.getValue();
    }

    private final SqlExpression getReplacement(SqlReferenceExpression $this$getReplacement) {
        SqlExpression sqlExpression;
        SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)$this$getReplacement.getCopyableUserData(SqlExtractableCodeInfoKt.access$getPARAM_OCCURRENCE$p());
        if (sqlExtractableParameterInfo != null) {
            SqlExtractableParameterInfo it = sqlExtractableParameterInfo;
            boolean bl = false;
            SqlExtractableParameterInfo sqlExtractableParameterInfo2 = this.getParameterMap().get(it);
            if (sqlExtractableParameterInfo2 == null) {
                sqlExtractableParameterInfo2 = it;
            }
            SqlExtractableParameterInfo param = sqlExtractableParameterInfo2;
            String quotes = SqlPsiMiscUtil.settings((PsiElement)$this$getReplacement).getQuotesPriority();
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)this.codeInfo.getOriginalExpression());
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            NamingService namingService = NamingServices.getNamingService$default(dbms, null, null, 6, null);
            String name2 = NamingService.catToScript$default(namingService, param.getName(), param.getOriginalExpression().getKind(), true, quotes, false, 16, null);
            sqlExpression = SqlPsiElementFactory.createExpressionFromText(name2, this.codeInfo.getDialect(), this.codeInfo.getProject(), null);
        } else {
            sqlExpression = null;
        }
        return sqlExpression;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map parameterMap_delegate$lambda$1(SqlExtractFunctionInfo this$0) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this$0.parameters;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getOriginal(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Unit substitutedExpression_delegate$lambda$4$lambda$3(SqlExtractFunctionInfo this$0, LinkedHashMap $replacementMap, SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SqlExpression sqlExpression = this$0.getReplacement(it);
        if (sqlExpression == null) {
            return Unit.INSTANCE;
        }
        SqlExpression replacement = sqlExpression;
        ((Map)$replacementMap).put(it, replacement);
        return Unit.INSTANCE;
    }

    private static final SqlExpression substitutedExpression_delegate$lambda$4(SqlExtractFunctionInfo this$0) {
        Object object;
        SqlReferenceExpression sqlReferenceExpression;
        SqlExpression expression = this$0.codeInfo.getVirtualExpression();
        SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression = expression instanceof SqlReferenceExpression ? (SqlReferenceExpression)expression : null;
        if (sqlReferenceExpression != null && (object = this$0.getReplacement(sqlReferenceExpression)) != null) {
            SqlExpression it = object;
            boolean bl = false;
            return it;
        }
        LinkedHashMap replacementMap = new LinkedHashMap();
        SqlExtractableCodeInfoKt.access$processReferences(expression, arg_0 -> SqlExtractFunctionInfo.substitutedExpression_delegate$lambda$4$lambda$3(this$0, replacementMap, arg_0));
        for (Map.Entry entry : ((Map)replacementMap).entrySet()) {
            PsiElement element = (PsiElement)entry.getKey();
            PsiElement replacement = (PsiElement)entry.getValue();
            element.replace(replacement);
        }
        return expression;
    }
}

