/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionDialog;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0005\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHandler;", "Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "<init>", "()V", "getHelper", "Lorg/jetbrains/annotations/Nullable;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "getExpressionToReplace", "routineInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "doRefactor", "intellij.database.sql.impl"})
public final class SqlExtractFunctionHandler
extends SqlIntroduceHandlerBase<SqlExtractFunctionHelper> {
    @NotNull
    public static final SqlExtractFunctionHandler INSTANCE = new SqlExtractFunctionHandler();

    private SqlExtractFunctionHandler() {
        String string = SqlBundle.message("extract.function", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string);
    }

    @Override
    @Nullable
    protected SqlExtractFunctionHelper getHelper(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return dialect.getExtractFunctionHelper();
    }

    @Override
    protected void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(SqlPsiUtilKt.getSqlDialect((PsiElement)expression));
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        SqlExpression expressionToExtract = UtilsKt.unwrapAlias(expression);
        String string = helper.validateExpression(expressionToExtract);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = SqlBundle.message(it, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            INSTANCE.showError(project, editor2, string2);
            return;
        }
        PsiElement it = helper.findTopmostBlock((PsiElement)expressionToExtract);
        SqlElement sqlElement = it instanceof SqlElement ? (SqlElement)it : null;
        if (sqlElement == null) {
            return;
        }
        SqlElement container = sqlElement;
        SqlExtractableCodeInfo codeInfo = new SqlExtractableCodeInfo(expressionToExtract, container);
        SqlExtractFunctionInfo routineInfo = new SqlExtractFunctionInfo(codeInfo, "my_function", codeInfo.getParameterInfos());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doRefactor(routineInfo);
        } else {
            new SqlExtractFunctionDialog(routineInfo, helper, (Function1<? super SqlExtractFunctionInfo, Unit>)((Function1)new Function1<SqlExtractFunctionInfo, Unit>((Object)this){

                public final void invoke(SqlExtractFunctionInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SqlExtractFunctionHandler.access$doRefactor((SqlExtractFunctionHandler)this.receiver, p0);
                }
            })).show();
        }
    }

    private final SqlExpression getExpressionToReplace(SqlExtractFunctionInfo routineInfo) {
        PsiElement p2;
        SqlExpression e = routineInfo.getCodeInfo().getOriginalExpression();
        if (routineInfo.getCodeInfo().isQuery() && (p2 = e.getParent()) instanceof SqlParenthesizedExpression) {
            e = (SqlExpression)p2;
        }
        return e;
    }

    private final void doRefactor(SqlExtractFunctionInfo routineInfo) {
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(routineInfo.getCodeInfo().getDialect());
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        Project project = routineInfo.getCodeInfo().getProject();
        SqlExpression expression = routineInfo.getCodeInfo().getOriginalExpression();
        SqlRoutineDefinition routineDefinition = helper.generateRoutine(routineInfo, false);
        SqlExpression call = helper.generateCall(routineInfo);
        PsiElement anchor = helper.findAnchor((PsiElement)expression, (PsiElement)routineInfo.getCodeInfo().getContainer());
        SqlExpression expressionToReplace = this.getExpressionToReplace(routineInfo);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, () -> SqlExtractFunctionHandler.doRefactor$lambda$1(expressionToReplace, call, helper, routineDefinition, anchor, routineInfo, project), (PsiFile[])new PsiFile[0]);
    }

    private static final void doRefactor$lambda$1(SqlExpression $expressionToReplace, SqlExpression $call, SqlExtractFunctionHelper $helper, SqlRoutineDefinition $routineDefinition, PsiElement $anchor, SqlExtractFunctionInfo $routineInfo, Project $project) {
        $expressionToReplace.replace((PsiElement)$call);
        SqlRoutineDefinition routineInPlace = $helper.addRoutine($routineDefinition, $anchor, $routineInfo.getCodeInfo().getContainer());
        CodeStyleManager.getInstance((Project)$project).reformat((PsiElement)routineInPlace);
    }

    public static final /* synthetic */ void access$doRefactor(SqlExtractFunctionHandler $this, SqlExtractFunctionInfo routineInfo) {
        $this.doRefactor(routineInfo);
    }
}

