/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.patterns;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.patterns.SqlElementPattern;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlFunctionCallPattern<T extends SqlFunctionCallExpression, Self extends SqlFunctionCallPattern<T, Self>>
extends SqlElementPattern<T, Self> {
    private static final Key<Pair<SqlExpressionList, List<SqlExpression>>> EXPR_LIST = Key.create((String)"SqlFunctionCallPattern.EXPR_LIST");

    protected SqlFunctionCallPattern(Class<T> aClass) {
        super(aClass);
    }

    public SqlFunctionCallPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            SqlFunctionCallPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    public Self name(String ... names) {
        return this.name((ElementPattern<String>)StandardPatterns.string().oneOfIgnoreCase(names));
    }

    public Self name(final @NotNull ElementPattern<String> namePattern) {
        if (namePattern == null) {
            SqlFunctionCallPattern.$$$reportNull$$$0(1);
        }
        return (Self)((Object)((SqlFunctionCallPattern)this.with(new PatternCondition<T>("withName"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlReferenceExpression nameElement;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (nameElement = t.getNameElement()) == null || namePattern.accepts((Object)nameElement.getName(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlFunctionCallPattern$1", "accepts"));
            }
        })));
    }

    public Self params(final ElementPattern<? extends List<? extends SqlExpression>> pattern) {
        return (Self)((Object)((SqlFunctionCallPattern)this.with(new PatternCondition<T>("params"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlExpressionList list;
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                List expr = (list = t.getParameterList()) == null ? Collections.emptyList() : SqlFunctionCallPattern.getExpressions(list, context);
                return pattern.accepts(expr, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlFunctionCallPattern$2", "accepts"));
            }
        })));
    }

    public Self qualifier(final ElementPattern<? extends SqlExpression> pattern) {
        return (Self)((Object)((SqlFunctionCallPattern)this.with(new PatternCondition<T>("qualifier"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlReferenceExpression nameElement;
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                SqlExpression expression = (nameElement = t.getNameElement()) == null ? null : nameElement.getQualifierExpression();
                return expression != null && pattern.accepts((Object)expression, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlFunctionCallPattern$3", "accepts"));
            }
        })));
    }

    @NotNull
    static List<SqlExpression> getExpressions(@NotNull SqlExpressionList list, ProcessingContext context) {
        if (list == null) {
            SqlFunctionCallPattern.$$$reportNull$$$0(2);
        }
        if (context == null) {
            List<SqlExpression> list2 = list.getExpressionList();
            if (list2 == null) {
                SqlFunctionCallPattern.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Pair res2 = (Pair)context.get(EXPR_LIST);
        if (res2 == null || res2.first != list) {
            res2 = Pair.create((Object)list, list.getExpressionList());
            context.put(EXPR_LIST, (Object)res2);
        }
        List list3 = (List)res2.second;
        if (list3 == null) {
            SqlFunctionCallPattern.$$$reportNull$$$0(4);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/patterns/SqlFunctionCallPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/patterns/SqlFunctionCallPattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressions";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class Capture<T extends SqlFunctionCallExpression>
    extends SqlFunctionCallPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/sql/psi/patterns/SqlFunctionCallPattern$Capture", "<init>"));
        }
    }
}

