/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTriggerStub;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTriggerStatementImpl
extends SqlStubbedDefinitionImpl<SqlTriggerStub>
implements SqlCreateTriggerStatement {
    public SqlCreateTriggerStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTriggerStatementImpl(SqlTriggerStub stub) {
        super(stub);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTriggerStatement(this);
    }

    @Override
    public SqlReferenceExpression getTargetContextExpression() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return stub.getTableReference();
        }
        SqlOnTargetClauseImpl target2 = (SqlOnTargetClauseImpl)this.findChildByType(SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return target2 == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)target2.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.TABLE, ObjectKind.COLUMN)) {
            return true;
        }
        SqlReferenceExpression expression = this.getTargetContextExpression();
        if (lastParent.getParent() == this && expression != null && expression != lastParent) {
            if (!this.processFakeDefinitions(processor2, state, lastParent, place)) {
                return false;
            }
            if (lastParent instanceof SqlAsExpression) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    @Override
    public DasTable getTable() {
        SqlReferenceExpression ref2 = this.getTargetContextExpression();
        PsiElement resolve2 = ref2 == null ? null : ref2.resolve();
        return resolve2 instanceof DasTable ? (DasTable)resolve2 : null;
    }

    @Override
    @Nullable
    public SqlExpression getTriggerProcedure() {
        return null;
    }

    protected boolean processFakeDefinitions(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        return true;
    }

    @Override
    @NotNull
    public Set<TrigEvent> getEvents() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getGreenStub();
        if (stub != null) {
            DasTrigger trigger2 = (DasTrigger)ObjectUtils.tryCast((Object)stub.getElement(), DasTrigger.class);
            Set<Object> set = trigger2 == null ? Collections.emptySet() : trigger2.getEvents();
            if (set == null) {
                SqlCreateTriggerStatementImpl.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<TrigEvent> set = SqlImplUtil.getTriggerEvents(this);
        if (set == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @Nullable
    public TrigTurn getTurn() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getGreenStub();
        if (stub != null) {
            DasTrigger trigger2 = (DasTrigger)ObjectUtils.tryCast((Object)stub.getElement(), DasTrigger.class);
            return trigger2 == null ? null : trigger2.getTurn();
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        PsiElement gran = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_GRANULARITY_CLAUSE).first();
        boolean forRow = gran != null && !api.children((Object)gran).filter(e -> api.typeOf(e) == SqlCommonKeywords.SQL_ROW).isEmpty();
        PsiElement timeClause = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE).first();
        if (timeClause == null) {
            return null;
        }
        return (TrigTurn)((Object)api.children((Object)timeClause).transform(api.TO_TYPE).transform(e -> SqlCreateTriggerStatementImpl.getTurn(e, forRow)).filter(Conditions.notNull()).first());
    }

    @Nullable
    private static TrigTurn getTurn(IElementType e, boolean row) {
        if (e == SqlCommonKeywords.SQL_INSTEAD) {
            return TrigTurn.INSTEAD_OF;
        }
        if (e == SqlCommonKeywords.SQL_BEFORE) {
            return row ? TrigTurn.BEFORE_ROW : TrigTurn.BEFORE_STMT;
        }
        if (e == SqlCommonKeywords.SQL_AFTER) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        if (e == SqlCommonKeywords.SQL_FOR) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        return null;
    }

    @Override
    @Nullable
    public String getCondition() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getGreenStub();
        if (stub != null) {
            DasTrigger trigger2 = (DasTrigger)ObjectUtils.tryCast((Object)stub.getElement(), DasTrigger.class);
            return trigger2 == null ? null : trigger2.getCondition();
        }
        SqlWhenClause whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlWhenClause.class);
        SqlExpression expr = whenClause != null ? whenClause.getExpression() : null;
        return expr == null ? null : expr.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

