/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasHideableObject;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPrimaryKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlUniqueKeyDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlConstraintStub;
import com.intellij.sql.psi.stubs.SqlStubbedTypedDefinitionImpl;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlColumnDefinitionImpl
extends SqlStubbedTypedDefinitionImpl<SqlColumnStub>
implements SqlColumnDefinition,
SqlExtraDeclarationsProvider,
DasHideableObject {
    static final TokenSet COLUMN_REFS = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE});
    private static final TokenSet HIDDEN_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_HIDDEN, SqlCommonKeywords.SQL_INVISIBLE, SqlCommonKeywords.SQL_IMPLICITLY});

    public SqlColumnDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlColumnDefinitionImpl(SqlColumnStub stub) {
        super(stub);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlColumnDefinition(this);
    }

    @Override
    @Nullable
    public SqlNameElement getNameElement() {
        SqlColumnStub stub = (SqlColumnStub)this.getStub();
        if (stub != null) {
            return stub.getNameReference(SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        }
        SqlIdentifier identifier = (SqlIdentifier)this.findChildByType(SqlCompositeElementTypes.SQL_IDENTIFIER);
        if (identifier != null) {
            return identifier;
        }
        return (SqlNameElement)this.findChildByType(COLUMN_REFS);
    }

    @Override
    @NotNull
    public List<SqlConstraintDefinition> getConstraints() {
        SqlColumnStub stub = (SqlColumnStub)this.getStub();
        if (stub != null) {
            ArrayList<SqlConstraintDefinition> res2 = new ArrayList<SqlConstraintDefinition>();
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof SqlConstraintStub)) continue;
                res2.add((SqlConstraintDefinition)((SqlConstraintStub)element).getPsi());
            }
            ArrayList<SqlConstraintDefinition> arrayList = res2;
            if (arrayList == null) {
                SqlColumnDefinitionImpl.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlConstraintDefinition.class);
        if (list == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public SqlTableKeyDefinition getPrimaryKey() {
        return (SqlTableKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION);
    }

    @Override
    public SqlForeignKeyDefinition getForeignKey() {
        return (SqlForeignKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION);
    }

    @Override
    public SqlTableKeyDefinition getUniqueKey() {
        return (SqlTableKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION);
    }

    @Override
    @Nullable
    public SqlClause getGeneratedClause() {
        return (SqlClause)this.findChildByType(SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE);
    }

    @NotNull
    public PsiReference[] getReferences() {
        DasTable table = this.getTable();
        SqlIdentifier nameElement = (SqlIdentifier)ObjectUtils.tryCast((Object)this.getNameElement(), SqlIdentifier.class);
        if (nameElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SqlColumnDefinitionImpl.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange textRange = nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent());
        SmartList result2 = new SmartList();
        Processor processor2 = arg_0 -> this.lambda$getReferences$0(textRange, (List)result2, arg_0);
        if (table instanceof SqlDefinition) {
            ContainerUtil.process(SqlImplUtil.getReferencedElements((SqlDefinition)((Object)table)), (Processor)processor2);
        } else if (table != null) {
            processor2.process((Object)table);
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.toArray((Collection)result2, (ArrayFactory)PsiReference.ARRAY_FACTORY);
        if (psiReferenceArray == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Override
    public DasTable getTable() {
        return (DasTable)ObjectUtils.notNull((Object)((DasTable)ObjectUtils.tryCast((Object)this.getDasParent(), DasTable.class)), (Object)SqlImplUtil.NO_TABLE);
    }

    @Override
    public boolean isNotNull() {
        SqlColumnStub stub = (SqlColumnStub)this.getGreenStub();
        if (stub != null) {
            DasColumn column2 = (DasColumn)ObjectUtils.tryCast((Object)stub.getElement(), DasColumn.class);
            return column2 != null && column2.isNotNull();
        }
        for (PsiElement element = this.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (!(element instanceof SqlConstraintDefinition)) continue;
            SqlConstraintDefinition.Type type = ((SqlConstraintDefinition)element).getConstraintType();
            if (type == SqlConstraintDefinition.Type.NOT_NULL) {
                return true;
            }
            if (type != SqlConstraintDefinition.Type.NULLABLE) continue;
            return false;
        }
        return false;
    }

    @Override
    public String getDefault() {
        SqlColumnStub stub = (SqlColumnStub)this.getGreenStub();
        if (stub != null) {
            return stub.getDefault();
        }
        SqlConstraintDefinition constraint = (SqlConstraintDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION);
        SqlExpression expression = constraint == null ? null : constraint.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
        return expression == null ? null : expression.getText();
    }

    protected Icon getBaseIcon() {
        return DatabaseIcons.Col;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (this.getStub() != null) {
            return this.getIcon();
        }
        return this.getIconSuper(flags);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType type = super.getDasType();
        if (type != DasTypeSystemBase.UNKNOWN || this.getStub() != null) {
            DasType dasType = type;
            if (dasType == null) {
                SqlColumnDefinitionImpl.$$$reportNull$$$0(5);
            }
            return dasType;
        }
        SqlExpression genExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType(SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE), SqlExpression.class);
        if (genExpression != null) {
            DasType dasType = genExpression.getDasType();
            if (dasType == null) {
                SqlColumnDefinitionImpl.$$$reportNull$$$0(6);
            }
            return dasType;
        }
        SqlColumnAliasListImpl owner = (SqlColumnAliasListImpl)ObjectUtils.tryCast((Object)this.getParent(), SqlColumnAliasListImpl.class);
        DasType dasType = owner != null ? owner.getAliasedDasType(this) : DasTypeSystemBase.UNKNOWN;
        if (dasType == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(7);
        }
        return dasType;
    }

    @Override
    public boolean isHidden() {
        SqlClause hiddenClause = (SqlClause)this.findChildByType(SqlCompositeElementTypes.SQL_VISIBILITY_CLAUSE);
        if (hiddenClause == null) {
            return false;
        }
        IElementType tokenType = PsiUtilCore.getElementType((PsiElement)hiddenClause.getFirstChild());
        return HIDDEN_KEYWORDS.contains(tokenType);
    }

    @Override
    public boolean processExtraDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(this, (JBIterable<? extends PsiElement>)SqlImplUtil.childrenIt(this).filter(SqlDefinition.class), true, processor2, state, lastParent, place, true);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(8);
        }
        if (state == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(10);
        }
        if (processor2.getDialect().getDbms() == Dbms.MSSQL && (lastParent instanceof SqlPrimaryKeyDefinitionImpl || lastParent instanceof SqlUniqueKeyDefinitionImpl) && processor2.mayAccept(ObjectKind.COLUMN) && !processor2.executeTarget(this, null, null, state)) {
            return false;
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    @Override
    public DasObject getDasParent() {
        DasObject parent;
        PsiElement tp;
        if (this.getStub() == null && (tp = SqlColumnDefinitionImpl.getParentTypeElement(this)) != null) {
            DasObject p2 = (DasObject)ObjectUtils.tryCast((Object)tp.getParent(), DasObject.class);
            return p2 != null && DbImplUtilCore.isTypeKind(p2.getKind()) ? p2 : null;
        }
        SqlReferenceExpression parentRef = this.getParentRef();
        if (parentRef != null && (parent = SqlColumnDefinitionImpl.getParentImpl(this)) != null) {
            return parent;
        }
        return super.getDasParent();
    }

    private static PsiElement getParentTypeElement(@NotNull PsiElement e) {
        PsiElement gp;
        PsiElement p2;
        if (e == null) {
            SqlColumnDefinitionImpl.$$$reportNull$$$0(11);
        }
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(PsiUtilCore.getElementType((PsiElement)(p2 = e.getParent())))) {
            return p2;
        }
        PsiElement psiElement = gp = p2 == null ? null : p2.getParent();
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(PsiUtilCore.getElementType((PsiElement)gp))) {
            return gp;
        }
        return null;
    }

    private /* synthetic */ boolean lambda$getReferences$0(TextRange textRange, List result2, Object o) {
        DasColumn column2;
        DasColumn dasColumn = column2 = o instanceof DasTable ? DasUtil.findChild((DasTable)o, DasColumn.class, ObjectKind.COLUMN, this.getName()) : null;
        if (column2 instanceof PsiElement) {
            PsiReferenceBase ref2 = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)((PsiElement)column2));
            ref2.setRangeInElement(textRange);
            result2.add(ref2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypeElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

