/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.postfixTemplates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateEditorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.postfixTemplates.SqlEditablePostfixTemplate;
import com.intellij.sql.postfixTemplates.SqlPostfixTemplateProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPostfixTemplateEditor
extends PostfixTemplateEditorBase<PostfixTemplateExpressionCondition<SqlExpression>> {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final Map<String, JCheckBox> myDialectBoxes = new LinkedHashMap<String, JCheckBox>();

    public SqlPostfixTemplateEditor(SqlPostfixTemplateProvider provider) {
        super((PostfixTemplateProvider)provider, false);
        this.myPanel = FormBuilder.createFormBuilder().addComponentFillVertically((JComponent)this.myEditTemplateAndConditionsPanel, 4).addVerticalGap(10).addLabeledComponent(SqlBundle.message("label.applicable.sql.dialects", new Object[0]), (JComponent)this.createDialectsPanel(), true).getPanel();
    }

    @NotNull
    private JPanel createDialectsPanel() {
        List dialects = ContainerUtil.sorted(SqlDialects.getTopLevelSqlDialects(), Comparator.comparing(Language::getDisplayName));
        JPanel dialectsDuo = new JPanel((LayoutManager)new GridLayoutManager((dialects.size() + 1) / 2, 2));
        GridConstraints gc = new GridConstraints();
        gc.setUseParentLayout(true);
        gc.setFill(3);
        gc.setVSizePolicy(1);
        for (int i2 = 0; i2 < dialects.size(); ++i2) {
            SqlLanguageDialect dialect = (SqlLanguageDialect)dialects.get(i2);
            JBCheckBox checkBox = new JBCheckBox(dialect.getDisplayName());
            this.myDialectBoxes.put(dialect.getID(), (JCheckBox)checkBox);
            gc.setRow(i2 / 2);
            gc.setColumn(i2 % 2);
            dialectsDuo.add((Component)checkBox, gc);
        }
        JPanel jPanel = dialectsDuo;
        if (jPanel == null) {
            SqlPostfixTemplateEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void setTemplate(@Nullable PostfixTemplate rawTemplate) {
        block3: {
            block2: {
                super.setTemplate(rawTemplate);
                if (rawTemplate != null) break block2;
                for (JCheckBox cb : this.myDialectBoxes.values()) {
                    cb.setSelected(true);
                }
                break block3;
            }
            if (!(rawTemplate instanceof SqlEditablePostfixTemplate)) break block3;
            for (Map.Entry<String, JCheckBox> entry : this.myDialectBoxes.entrySet()) {
                entry.getValue().setSelected(((SqlEditablePostfixTemplate)rawTemplate).getDialects().contains(entry.getKey()));
            }
        }
    }

    protected void fillConditions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SqlPostfixTemplateEditor.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public PostfixTemplate createTemplate(@NotNull String templateId, @NotNull String templateName) {
        if (templateId == null) {
            SqlPostfixTemplateEditor.$$$reportNull$$$0(2);
        }
        if (templateName == null) {
            SqlPostfixTemplateEditor.$$$reportNull$$$0(3);
        }
        LinkedHashSet<PostfixTemplateExpressionCondition<SqlExpression>> conditions = new LinkedHashSet<PostfixTemplateExpressionCondition<SqlExpression>>();
        ContainerUtil.addAll(conditions, this.myExpressionTypesListModel.elements());
        String templateText = this.myTemplateEditor.getDocument().getText();
        boolean useTopmostExpression = this.myApplyToTheTopmostJBCheckBox.isSelected();
        return new SqlEditablePostfixTemplate(templateId, templateName, templateText, "", conditions, useTopmostExpression, this.myProvider, this.getDialects());
    }

    private Collection<String> getDialects() {
        ArrayList<String> allDialects = new ArrayList<String>(this.myDialectBoxes.size());
        for (Map.Entry<String, JCheckBox> entry : this.myDialectBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            allDialects.add(entry.getKey());
        }
        return allDialects;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            SqlPostfixTemplateEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/postfixTemplates/SqlPostfixTemplateEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialectsPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/postfixTemplates/SqlPostfixTemplateEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillConditions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

