/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNameWithNumberIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "supportGroupByPosition", "", "Lcom/intellij/database/Dbms;", "getSupportGroupByPosition", "(Lcom/intellij/database/Dbms;)Z", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "getRefExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getColumnPosition", "", "expr", "(Lcom/intellij/sql/psi/SqlReferenceExpression;)Ljava/lang/Integer;", "intellij.database.sql.impl"})
public final class SqlReplaceColumnNameWithNumberIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.column.name.with.ordinal.number", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean getSupportGroupByPosition(Dbms $this$supportGroupByPosition) {
        return $this$supportGroupByPosition.isMysql() || $this$supportGroupByPosition.isPostgres() || $this$supportGroupByPosition.isExasol() || $this$supportGroupByPosition.isSqlite() || Intrinsics.areEqual((Object)$this$supportGroupByPosition, (Object)Dbms.SNOWFLAKE);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Dbms dbms = SqlPsiUtilKt.getSqlDialect(element).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra() || dbms2.isClickHouse() || dbms2.isHive() || dbms2.isHsqldb()) {
            return false;
        }
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element);
        if (sqlReferenceExpression == null) {
            return false;
        }
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        PsiElement parent = refExpr.getParent();
        return (parent instanceof SqlOrderByClause || parent instanceof SqlGroupByClause && this.getSupportGroupByPosition(dbms2)) && Intrinsics.areEqual((Object)refExpr.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN) && this.getColumnPosition(refExpr) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element);
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        Integer n = this.getColumnPosition(refExpr);
        if (n == null) {
            return;
        }
        int position = n;
        PsiFile file = element.getContainingFile();
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)file);
        SqlPositionalReference sqlPositionalReference = SqlPsiElementFactory.createPositionalReferenceFromText(position, dialect, (PsiElement)file);
        if (sqlPositionalReference == null) {
            return;
        }
        SqlPositionalReference newRefExpr = sqlPositionalReference;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlReferenceExpression getRefExpr(PsiElement element) {
        PsiElement psiElement = element.getParent();
        SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
        PsiElement psiElement2 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        return psiElement2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement2 : null;
    }

    private final Integer getColumnPosition(SqlReferenceExpression expr) {
        PsiElement source = expr.getReference().resolveImmediate();
        return source instanceof SqlColumnSymbol ? Integer.valueOf(((SqlColumnSymbol)source).getIndex() + 1) : (source instanceof DasPositioned ? Integer.valueOf(((DasPositioned)source).getPosition()) : null);
    }
}

