/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.SqlUiService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlIntentionUtil {
    @Nullable
    public static SqlReferenceExpression getReferenceExpression(PsiElement at) {
        PsiElement element = at != null ? at.getParent() : null;
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)(element instanceof SqlIdentifier ? element.getParent() : element), SqlReferenceExpression.class);
    }

    @Nullable
    public static SqlIdentifier getIdentifier(PsiElement at) {
        PsiElement element = at != null ? at.getParent() : null;
        return element instanceof SqlIdentifier ? (SqlIdentifier)element : null;
    }

    public static void qualifyReference(@NotNull Iterable<ObjectName> names, @NotNull NamingService namingService, @NotNull PsiElement identifier) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(0);
        }
        if (namingService == null) {
            SqlIntentionUtil.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(2);
        }
        String quoted = SqlIntentionUtil.joinNames(names, namingService, SqlPsiMiscUtil.settings(identifier));
        PsiFile file = identifier.getContainingFile();
        if (file == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)identifier.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(identifier.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> document.insertString(identifier.getTextRange().getStartOffset(), (CharSequence)(quoted + "."))), SqlBundle.message("command.name.qualify.identifier", new Object[0]), null, document);
    }

    public static void qualifyReference(@NotNull RangeMarker identifier, @NotNull Iterable<ObjectName> names, @NotNull NamingService namingService, @Nullable SqlCodeStyleSettings settings) {
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(3);
        }
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(4);
        }
        if (namingService == null) {
            SqlIntentionUtil.$$$reportNull$$$0(5);
        }
        String quoted = SqlIntentionUtil.joinNames(names, namingService, settings);
        identifier.getDocument().insertString(identifier.getStartOffset(), (CharSequence)(quoted + "."));
    }

    @NotNull
    private static String joinNames(@NotNull Iterable<ObjectName> names, @NotNull NamingService namingService, @Nullable SqlCodeStyleSettings settings) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(6);
        }
        if (namingService == null) {
            SqlIntentionUtil.$$$reportNull$$$0(7);
        }
        String string = StringUtil.join((Iterable)JBIterable.from(names).transform(n -> namingService.catToScript(n.name, null, !n.quoted, settings == null ? null : settings.getQuotesPriority(), false)), (String)".");
        if (string == null) {
            SqlIntentionUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void chooseQualifier(@NotNull Editor editor2, @NotNull Segment identifier, @NotNull List<? extends List<ObjectName>> variants, @NotNull NamingService namingService, @Nullable SqlCodeStyleSettings settings, @NotNull CasingProvider casingProvider, @NotNull Consumer<? super Iterable<ObjectName>> qualifier) {
        if (editor2 == null) {
            SqlIntentionUtil.$$$reportNull$$$0(9);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(10);
        }
        if (variants == null) {
            SqlIntentionUtil.$$$reportNull$$$0(11);
        }
        if (namingService == null) {
            SqlIntentionUtil.$$$reportNull$$$0(12);
        }
        if (casingProvider == null) {
            SqlIntentionUtil.$$$reportNull$$$0(13);
        }
        if (qualifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(14);
        }
        if (variants.isEmpty()) {
            return;
        }
        ObjectOpenCustomHashSet namesSet = new ObjectOpenCustomHashSet(variants, new ListHashingStrategy<ObjectName>(new CasingHashingStrategy(casingProvider.getCasing(ObjectKind.TABLE, null))));
        ArrayList uniqueNames = new ArrayList(namesSet);
        if (uniqueNames.size() == 1) {
            qualifier.consume(uniqueNames.get(0));
            return;
        }
        Collections.reverse(uniqueNames);
        ArrayList<String> qualified = new ArrayList<String>();
        for (Iterable name2 : uniqueNames) {
            qualified.add(SqlIntentionUtil.joinNames(name2, namingService, settings));
        }
        editor2.getCaretModel().moveToOffset(identifier.getStartOffset());
        SqlUiService.getInstance().showListPopup(editor2, SqlBundle.message("popup.title.qualify.with", new Object[0]), qualified, selectedValue -> qualifier.consume(uniqueNames.get((int)selectedValue)));
    }

    public static void qualifyReference(@NotNull List<? extends Iterable<ObjectName>> names, @NotNull NamingService namingService, @NotNull SqlIdentifier identifier, @NotNull Editor editor2) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(15);
        }
        if (namingService == null) {
            SqlIntentionUtil.$$$reportNull$$$0(16);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            SqlIntentionUtil.$$$reportNull$$$0(18);
        }
        if (names.isEmpty()) {
            return;
        }
        LinkedHashSet<? extends Iterable<ObjectName>> namesSet = new LinkedHashSet<Iterable<ObjectName>>(names);
        ArrayList<? extends Iterable<ObjectName>> uniqueNames = new ArrayList<Iterable<ObjectName>>(namesSet);
        if (uniqueNames.size() == 1) {
            SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(0), namingService, (PsiElement)identifier);
            return;
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(identifier.getContainingFile());
        ArrayList<String> qualified = new ArrayList<String>();
        for (Iterable iterable : uniqueNames) {
            qualified.add(SqlIntentionUtil.joinNames(iterable, namingService, settings) + "." + identifier.getName());
        }
        SqlUiService.getInstance().showListPopup(editor2, SqlBundle.message("popup.title.qualify.with", new Object[0]), qualified, selectedValue -> SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get((int)selectedValue), namingService, (PsiElement)identifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlIntentionUtil";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlIntentionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "joinNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifyReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinNames";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static class ListHashingStrategy<T>
    implements Hash.Strategy<List<T>> {
        @NotNull
        private final Hash.Strategy<? super T> myStrategy;

        ListHashingStrategy(@NotNull Hash.Strategy<? super T> strategy) {
            if (strategy == null) {
                ListHashingStrategy.$$$reportNull$$$0(0);
            }
            this.myStrategy = strategy;
        }

        public int hashCode(@Nullable List<T> o) {
            int hc = 0;
            if (o != null) {
                for (T t : o) {
                    hc = hc * 31 + this.myStrategy.hashCode(t);
                }
            }
            return hc;
        }

        public boolean equals(List<T> o1, List<T> o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            if (o1.size() != o2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < o1.size(); ++i2) {
                if (this.myStrategy.equals(o1.get(i2), o2.get(i2))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/sql/intentions/SqlIntentionUtil$ListHashingStrategy", "<init>"));
        }
    }

    private static class CasingHashingStrategy
    implements Hash.Strategy<ObjectName> {
        private final Casing myCasing;

        public CasingHashingStrategy(@NotNull Casing casing) {
            if (casing == null) {
                CasingHashingStrategy.$$$reportNull$$$0(0);
            }
            this.myCasing = casing;
        }

        public int hashCode(@Nullable ObjectName o) {
            return o.hashCode(this.myCasing);
        }

        public boolean equals(ObjectName o1, ObjectName o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2, this.myCasing);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/sql/intentions/SqlIntentionUtil$CasingHashingStrategy", "<init>"));
        }
    }
}

