/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/intentions/SqlConvertInToEqualityIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getTargetExpression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "invoke", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertInToEqualityIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertInToEqualityIntention.kt\ncom/intellij/sql/intentions/SqlConvertInToEqualityIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n295#2,2:66\n*S KotlinDebug\n*F\n+ 1 SqlConvertInToEqualityIntention.kt\ncom/intellij/sql/intentions/SqlConvertInToEqualityIntention\n*L\n26#1:66,2\n*E\n"})
public final class SqlConvertInToEqualityIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.in.expression.with.equality.checks", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final SqlBinaryExpression getTargetExpression(PsiElement element) {
        Object v1;
        block2: {
            if (SqlPsiUtilKt.getSqlDialect(element).getDbms().isCassandra()) {
                return null;
            }
            JBIterable jBIterable = SqlImplUtil.sqlParents(element).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getOpSign(), (Object)((Object)SqlCommonKeywords.SQL_IN)) && it.getLOperand() instanceof SqlReferenceExpression && it.getROperand() instanceof SqlParenthesizedExpression)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = this.getTargetExpression(element);
        if (sqlBinaryExpression == null) {
            return false;
        }
        SqlBinaryExpression expression = sqlBinaryExpression;
        return !SqlImplUtil.hasNonEditableFragment(editor2.getDocument(), (PsiElement)expression);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = this.getTargetExpression(element);
        if (sqlBinaryExpression == null) {
            return;
        }
        SqlBinaryExpression inExpr = sqlBinaryExpression;
        boolean isNot = inExpr.isNot();
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)inExpr);
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        SqlExpression sqlExpression = inExpr.getLOperand();
        SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression subject = sqlReferenceExpression;
        SqlExpression sqlExpression2 = inExpr.getROperand();
        Object object = sqlExpression2 instanceof SqlParenthesizedExpression ? (SqlParenthesizedExpression)sqlExpression2 : null;
        if (object == null || (object = object.getExpressionList()) == null) {
            return;
        }
        Object values = object;
        boolean needsParentheses = inExpr.getParent() instanceof SqlOperatorExpression;
        if (needsParentheses) {
            builder.symbol("(");
        }
        String logicalOp = isNot ? "and" : "or";
        String comparisonOp = isNot ? "<>" : "=";
        Iterator iterator = ((Iterable)values).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            SqlExpression value = (SqlExpression)iterator.next();
            if (i2 > 0) {
                builder.keyword(" " + logicalOp + " ");
            }
            builder.plain(subject.getText());
            builder.symbol(" " + comparisonOp + " ");
            builder.plain(value.getText());
        }
        if (needsParentheses) {
            builder.symbol(")");
        }
        SqlExpression sqlExpression3 = SqlPsiElementFactory.createExpressionFromText(builder.getStatement(), dialect, project, null);
        Intrinsics.checkNotNull((Object)sqlExpression3);
        SqlExpression eqExpr = sqlExpression3;
        inExpr.replace((PsiElement)eqExpr);
    }
}

