/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlSuppressInspectionFix
extends SuppressByCommentFix
implements DumbAware {
    @FileModifier.SafeFieldForPreview
    @Nullable
    private final ObjectPath myTargetPath;

    public SqlSuppressInspectionFix(@NotNull String id, @NotNull Class<? extends SqlElement> containerClass, @Nullable ObjectPath path) {
        if (id == null) {
            SqlSuppressInspectionFix.$$$reportNull$$$0(0);
        }
        if (containerClass == null) {
            SqlSuppressInspectionFix.$$$reportNull$$$0(1);
        }
        super(id, containerClass);
        this.myTargetPath = path;
    }

    @NotNull
    public String getText() {
        if (this.myTargetPath == null) {
            String string = SqlBundle.message("intention.name.suppress", new Object[0]);
            if (string == null) {
                SqlSuppressInspectionFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = SqlBundle.message("intention.name.suppress.references.to", StringUtil.toLowerCase((String)this.myTargetPath.kind.name()), this.myTargetPath.name);
        if (string == null) {
            SqlSuppressInspectionFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getSuppressionText(@NotNull String id) {
        if (id == null) {
            SqlSuppressInspectionFix.$$$reportNull$$$0(4);
        }
        String path = this.myTargetPath != null ? " @ " + this.myTargetPath.serialize() : "";
        String string = "noinspection " + id + path;
        if (string == null) {
            SqlSuppressInspectionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

