/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanBinaryInstruction;
import com.intellij.sql.inspections.dataflow.types.SqlDfBooleanConstantType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J;\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001a2\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlBooleanAndOrInstruction;", "Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlBooleanBinaryInstruction;", "expression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "or", "", "<init>", "(Lcom/intellij/sql/psi/SqlBinaryExpression;Z)V", "getOr", "()Z", "doAccept", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "left", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "right", "nullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;", "stateBefore", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "computeNullability", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "balanceTypes", "Lkotlin/Pair;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlBooleanAndOrInstruction
extends SqlBooleanBinaryInstruction {
    private final boolean or;

    public SqlBooleanAndOrInstruction(@NotNull SqlBinaryExpression expression, boolean or) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super(expression);
        this.or = or;
    }

    public final boolean getOr() {
        return this.or;
    }

    @Override
    @NotNull
    public DfaInstructionState[] doAccept(@NotNull DfaValue left, @NotNull DfaValue right, @NotNull SqlDfaNullability nullability, @NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)stateBefore, (String)"stateBefore");
        DfType dfType = stateBefore.getDfType(left);
        SqlDfBooleanConstantType sqlDfBooleanConstantType = dfType instanceof SqlDfBooleanConstantType ? (SqlDfBooleanConstantType)dfType : null;
        Boolean leftConstant = sqlDfBooleanConstantType != null ? (Boolean)sqlDfBooleanConstantType.getValue() : null;
        DfType dfType2 = stateBefore.getDfType(right);
        SqlDfBooleanConstantType sqlDfBooleanConstantType2 = dfType2 instanceof SqlDfBooleanConstantType ? (SqlDfBooleanConstantType)dfType2 : null;
        Boolean rightConstant = sqlDfBooleanConstantType2 != null ? (Boolean)sqlDfBooleanConstantType2.getValue() : null;
        DfType res2 = this.or ? SqlBooleanAndOrInstruction.doAccept$computeOr(nullability, leftConstant, rightConstant) : SqlBooleanAndOrInstruction.doAccept$computeAnd(nullability, leftConstant, rightConstant);
        this.pushResult(interpreter, stateBefore, res2, new DfaValue[0]);
        DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
        Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
        return dfaInstructionStateArray;
    }

    @Override
    @NotNull
    public SqlDfaNullability computeNullability(@NotNull DfType left, @NotNull DfType right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return this.or && (Intrinsics.areEqual((Object)left, (Object)SqlDfTypesKt.getTRUE()) || Intrinsics.areEqual((Object)right, (Object)SqlDfTypesKt.getTRUE())) ? SqlDfaNullability.NOT_NULL : super.computeNullability(left, right);
    }

    @Override
    @NotNull
    public Pair<DfType, DfType> balanceTypes(@NotNull DfType right, @NotNull DfType left) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return TuplesKt.to((Object)SqlDfTypesKt.tryCastToBoolean(right, this.getDialect()), (Object)SqlDfTypesKt.tryCastToBoolean(left, this.getDialect()));
    }

    @NotNull
    public String toString() {
        return "BOOLEAN_OP " + (this.or ? "OR" : "AND");
    }

    private static final DfType doAccept$computeOr(SqlDfaNullability $nullability, Boolean left, Boolean right) {
        return Intrinsics.areEqual((Object)left, (Object)false) && Intrinsics.areEqual((Object)right, (Object)false) ? (DfType)SqlDfTypesKt.getFALSE() : (Intrinsics.areEqual((Object)left, (Object)true) || Intrinsics.areEqual((Object)right, (Object)true) ? (DfType)SqlDfTypesKt.getTRUE() : SqlDfTypesKt.unknown($nullability));
    }

    private static final DfType doAccept$computeAnd(SqlDfaNullability $nullability, Boolean left, Boolean right) {
        return Intrinsics.areEqual((Object)left, (Object)true) && Intrinsics.areEqual((Object)right, (Object)true) ? (DfType)SqlDfTypesKt.getTRUE() : (Intrinsics.areEqual((Object)left, (Object)false) || Intrinsics.areEqual((Object)right, (Object)false) ? (DfType)SqlDfTypesKt.getFALSE() : SqlDfTypesKt.unknown($nullability));
    }
}

