/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.types.DasType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantAliasInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "QuickFix", "intellij.database.sql.impl"})
public final class SqlRedundantAliasInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression asExpression) {
                QuickFix[] quickFixArray;
                boolean bl;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
                    SqlExpression sqlExpression = asExpression.getExpression();
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                    if (sqlReferenceExpression == null) {
                        return;
                    }
                    SqlReferenceExpression aliasedRef = sqlReferenceExpression;
                    if (aliasedRef.getQualifierExpression() != null) {
                        return;
                    }
                    SqlIdentifier sqlIdentifier = asExpression.getNameElement();
                    if (!Intrinsics.areEqual((Object)aliasedRef.getName(), (Object)(sqlIdentifier != null ? sqlIdentifier.getName() : null))) {
                        return;
                    }
                    DasType dasType = asExpression.getDasType();
                    AliasedSqlTableType aliasedSqlTableType = dasType instanceof AliasedSqlTableType ? (AliasedSqlTableType)dasType : null;
                    if (aliasedSqlTableType == null) {
                        return;
                    }
                    AliasedSqlTableType aliasType = aliasedSqlTableType;
                    DasType dasType2 = aliasedRef.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                    DasType originalType = dasType2;
                    if (!(originalType instanceof SqlTableType)) {
                        return;
                    }
                    if (aliasType.getColumnCount() != ((SqlTableType)originalType).getColumnCount()) {
                        return;
                    }
                    Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)aliasType.getColumnCount());
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        quickFixArray = $this$any$iv.iterator();
                        while (quickFixArray.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)quickFixArray).nextInt();
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)aliasType.getColumnName(it), (Object)((SqlTableType)originalType).getColumnName(it)))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                SqlIdentifier sqlIdentifier = asExpression.getNameElement();
                Intrinsics.checkNotNull((Object)sqlIdentifier);
                quickFixArray = new QuickFix[]{new QuickFix(asExpression)};
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(sqlIdentifier.getOriginalElement(), SqlBundle.message("inspection.message.remove.alias", new Object[0]), (LocalQuickFix[])quickFixArray, ProblemHighlightType.WARNING, false, false);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantAliasInspection$QuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "asExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "<init>", "(Lcom/intellij/sql/psi/SqlAsExpression;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class QuickFix
    extends LocalQuickFixOnPsiElement
    implements DumbAware {
        public QuickFix(@NotNull SqlAsExpression asExpression) {
            Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
            super((PsiElement)asExpression);
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.remove.alias", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlAsExpression sqlAsExpression = startElement instanceof SqlAsExpression ? (SqlAsExpression)startElement : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression sqlAsExpression2 = sqlAsExpression;
            SqlExpression sqlExpression = sqlAsExpression2.getExpression();
            if (sqlExpression == null) {
                return;
            }
            SqlExpression aliasedExpression = sqlExpression;
            sqlAsExpression2.replace((PsiElement)aliasedExpression);
        }
    }
}

