/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlMultipleLimitClausesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlMultipleLimitClausesInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                JBIterable<SqlLimitClause> jBIterable = o.getLimitClauses();
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getLimitClauses(...)");
                String string = SqlBundle.message("inspection.message.multiple.limiting.clauses.are.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.reportClauses(jBIterable, string);
                JBIterable<SqlOffsetClause> jBIterable2 = o.getOffsetClauses();
                Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getOffsetClauses(...)");
                String string2 = SqlBundle.message("inspection.message.multiple.offset.clauses.are.not.allowed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this.reportClauses(jBIterable2, string2);
            }

            /*
             * WARNING - void declaration
             */
            private final void reportClauses(JBIterable<? extends SqlClause> clauses, @InspectionMessage String message) {
                void $this$forEach$iv;
                if (clauses.size() <= 1) {
                    return;
                }
                Iterable iterable = (Iterable)clauses;
                boolean bl = this.$onTheFly;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlClause it = (SqlClause)element$iv;
                    boolean bl2 = false;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)it, message, (LocalQuickFix)DropPsiFix.Companion.getINSTANCE(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, bl));
                }
            }
        };
    }
}

