/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlGotoStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/inspections/SqlGotoInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "reportAll", "", "reportLoopExit", "reportBackwardGoto", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "Mode", "intellij.database.sql.impl"})
public final class SqlGotoInspection
extends SqlInspectionBase {
    @JvmField
    public boolean reportAll;
    @JvmField
    public boolean reportLoopExit = true;
    @JvmField
    public boolean reportBackwardGoto = true;

    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, this, onTheFly){
            final /* synthetic */ SqlGotoInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlGotoStatement(SqlGotoStatement o) {
                SqlLoopStatement loopStatement;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (this.this$0.reportAll) {
                    PsiElement psiElement = (PsiElement)o;
                    String string = SqlBundle.message("inspection.message.avoid.use.goto.statements", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                    return;
                }
                SqlReferenceExpression sqlReferenceExpression = o.getLabelReference();
                if (sqlReferenceExpression == null || (sqlReferenceExpression = sqlReferenceExpression.resolve()) == null) {
                    return;
                }
                SqlReferenceExpression targetElement = sqlReferenceExpression;
                if (this.this$0.reportLoopExit && (loopStatement = (SqlLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlLoopStatement.class)) != null && !PsiTreeUtil.isAncestor((PsiElement)targetElement, (PsiElement)((PsiElement)loopStatement), (boolean)true)) {
                    PsiElement psiElement = (PsiElement)o;
                    String string = SqlBundle.message("inspection.message.avoid.using.goto.statements.to.exit.loop", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                }
                if (this.this$0.reportBackwardGoto && targetElement.getTextRange().getStartOffset() < o.getTextRange().getStartOffset()) {
                    PsiElement psiElement = (PsiElement)o;
                    String string = SqlBundle.message("inspection.message.avoid.using.backward.goto.statements", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                }
            }

            private final void reportProblem(PsiElement anchor, @InspectionMessage String message) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.dropdown((String)"mode", (String)SqlBundle.message("inspection.goto.dropdown.label.report", new Object[0]), Mode.class, Mode::toString)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("mode", () -> SqlGotoInspection.getOptionController$lambda$0(this), arg_0 -> SqlGotoInspection.getOptionController$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        return optionController;
    }

    private static final Mode getOptionController$lambda$0(SqlGotoInspection this$0) {
        return this$0.reportAll ? Mode.ALL : (this$0.reportLoopExit && this$0.reportBackwardGoto ? Mode.LOOP_AND_BACKWARD : (this$0.reportLoopExit ? Mode.LOOP : Mode.BACKWARD));
    }

    private static final void getOptionController$lambda$1(SqlGotoInspection this$0, Mode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this$0.reportAll = value == Mode.ALL;
        this$0.reportLoopExit = value == Mode.LOOP || value == Mode.LOOP_AND_BACKWARD;
        this$0.reportBackwardGoto = value == Mode.BACKWARD || value == Mode.LOOP_AND_BACKWARD;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/inspections/SqlGotoInspection$Mode;", "", "key", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "LOOP", "BACKWARD", "LOOP_AND_BACKWARD", "ALL", "toString", "intellij.database.sql.impl"})
    private static final class Mode
    extends Enum<Mode> {
        @NotNull
        private final String key;
        public static final /* enum */ Mode LOOP = new Mode("inspection.goto.dropdown.option.loop");
        public static final /* enum */ Mode BACKWARD = new Mode("inspection.goto.dropdown.option.backward");
        public static final /* enum */ Mode LOOP_AND_BACKWARD = new Mode("inspection.goto.dropdown.option.backward.loop");
        public static final /* enum */ Mode ALL = new Mode("inspection.goto.dropdown.option.all");
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(String key2) {
            this.key = key2;
        }

        @NotNull
        public String toString() {
            String string = SqlBundle.message(this.key, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.LOOP, Mode.BACKWARD, Mode.LOOP_AND_BACKWARD, Mode.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

