/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BM\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/StartRowUntilPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "startRowMatchers", "", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "untilMatcher", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;Ljava/util/List;Lcom/intellij/sql/formatter/model/NodeMatcher;Lcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.core.impl"})
public final class StartRowUntilPattern
extends FlowPattern {
    @NotNull
    private final List<NodeMatcher> startRowMatchers;
    @NotNull
    private final NodeMatcher untilMatcher;
    @NotNull
    private final BlockRole role;

    public StartRowUntilPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull List<? extends NodeMatcher> startRowMatchers, @NotNull NodeMatcher untilMatcher, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter(startRowMatchers, (String)"startRowMatchers");
        Intrinsics.checkNotNullParameter((Object)untilMatcher, (String)"untilMatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.startRowMatchers = startRowMatchers;
        this.untilMatcher = untilMatcher;
        this.role = role;
    }

    public /* synthetic */ StartRowUntilPattern(Byte by, Byte by2, List list, NodeMatcher nodeMatcher, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            blockRole = BlockRole.NOTHING;
        }
        this(by, by2, list, nodeMatcher, blockRole, (Function0<? extends SqlBlock>)function0);
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes2, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        int m = this.startRowMatchers.size();
        int n = nodes2.size();
        if (since + m > n) {
            return null;
        }
        int rowLength = FlowPatternKt.access$parseRow(nodes2, since, this.startRowMatchers);
        if (rowLength <= 0) {
            return null;
        }
        int m2 = FlowPatternKt.access$parseUntil(nodes2, since + rowLength, this.untilMatcher);
        int tailLength = m2 - (since + rowLength);
        if (tailLength < 0) {
            return null;
        }
        return RangesKt.until((int)since, (int)m2);
    }
}

