/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowProcessor;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ+\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020\u001bH\u0014J\u001c\u0010!\u001a\u00020\u001b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020$0#H\u0004J\b\u0010&\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u001bH\u0014J\u0012\u0010(\u001a\u00020\u001b2\b\u0010\n\u001a\u0004\u0018\u00010)H\u0004J\b\u0010*\u001a\u00020\u001bH\u0014J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020$H\u0016J\b\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010%\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "<init>", "()V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "value", "Lcom/intellij/openapi/util/TextRange;", "range", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "nestedNodes", "", "Lcom/intellij/lang/ASTNode;", "getNestedNodes", "()Ljava/util/List;", "setNestedNodes", "(Ljava/util/List;)V", "minLength", "", "getMinLength", "()I", "setMinLength", "(I)V", "setup", "", "parent", "Lcom/intellij/sql/formatter/model/SqlBlock;", "nodes", "setup$intellij_database_sql_core_impl", "adjustNestedNodes", "flattenNestedNodes", "whetherToFlatten", "Lkotlin/Function1;", "", "grown", "grow", "produceNestedBlocks", "produceNestedBlocksInRange", "Lkotlin/ranges/IntRange;", "adjustProducedNestedBlocks", "contains", "char", "", "isLeaf", "toString", "", "intellij.database.sql.core.impl"})
public abstract class SqlRangeBlock
extends SqlFlowBlock {
    private TextRange range;
    protected List<? extends ASTNode> nestedNodes;
    private int minLength;
    private boolean grown;

    public SqlRangeBlock() {
        super(null);
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public final TextRange getRange() {
        TextRange textRange = this.range;
        if (textRange != null) {
            return textRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        return null;
    }

    @NotNull
    protected final List<ASTNode> getNestedNodes() {
        List<ASTNode> list = this.nestedNodes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        return null;
    }

    protected final void setNestedNodes(@NotNull List<? extends ASTNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.nestedNodes = list;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(int n) {
        this.minLength = n;
    }

    public final void setup(@NotNull SqlBlock parent, @NotNull List<? extends ASTNode> nodes2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        boolean bl2 = bl = !((Collection)nodes2).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TextRange range = new TextRange(((ASTNode)CollectionsKt.first(nodes2)).getTextRange().getStartOffset(), ((ASTNode)CollectionsKt.last(nodes2)).getTextRange().getEndOffset());
        this.setup$intellij_database_sql_core_impl(parent, range, nodes2);
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent, @NotNull TextRange range, @NotNull List<? extends ASTNode> nodes2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        super.setup$intellij_database_sql_core_impl(parent);
        this.range = range;
        this.setNestedNodes(nodes2);
        this.adjustNestedNodes();
    }

    protected void adjustNestedNodes() {
    }

    protected final void flattenNestedNodes(@NotNull Function1<? super ASTNode, Boolean> whetherToFlatten) {
        Intrinsics.checkNotNullParameter(whetherToFlatten, (String)"whetherToFlatten");
        List list = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.astTraverser().withRoots((Iterable)this.getNestedNodes())).expandAndSkip(arg_0 -> SqlRangeBlock.flattenNestedNodes$lambda$1(arg_0 -> SqlRangeBlock.flattenNestedNodes$lambda$0(whetherToFlatten, arg_0), arg_0))).traverse().filter(arg_0 -> SqlRangeBlock.flattenNestedNodes$lambda$3(SqlRangeBlock::flattenNestedNodes$lambda$2, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        this.setNestedNodes(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        try {
            this.produceNestedBlocks();
            this.adjustProducedNestedBlocks();
        }
        finally {
            this.grown = true;
        }
    }

    protected void produceNestedBlocks() {
        this.produceNestedBlocksInRange(null);
    }

    protected final void produceNestedBlocksInRange(@Nullable IntRange range) {
        List<ASTNode> nodesToProcess = range == null ? this.getNestedNodes() : this.getNestedNodes().subList(range.getFirst(), range.getLast() + 1);
        List<FlowPattern> patterns2 = this.flowPatterns();
        if (patterns2 != null) {
            FlowProcessor walker = new FlowProcessor(this.getContext(), this, nodesToProcess, patterns2, this.flowToProduceCommentsFlowBlocks());
            walker.processAll();
        } else {
            for (ASTNode node : nodesToProcess) {
                SqlBlock block = this.makeBlock(node);
                if (block.getRole() == BlockRole.NOTHING) {
                    block.setRole(this.determineRole(node));
                }
                this.addNestedBlock$intellij_database_sql_core_impl(block);
            }
        }
    }

    protected void adjustProducedNestedBlocks() {
    }

    @Override
    public boolean contains(char c2) {
        return this.getContext().textContains(this.getRange(), c2);
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.getNestedNodes().isEmpty()) {
            return super.toString();
        }
        String str = SqlBlockKt.access$rangeRepresentation(SqlUtilFun.firstLeaf((ASTNode)CollectionsKt.first(this.getNestedNodes())), SqlUtilFun.lastLeaf((ASTNode)CollectionsKt.last(this.getNestedNodes())));
        return super.toString() + ": " + str;
    }

    private static final boolean flattenNestedNodes$lambda$0(Function1 $whetherToFlatten, ASTNode it) {
        Intrinsics.checkNotNull((Object)it);
        return (Boolean)$whetherToFlatten.invoke((Object)it) != false || it.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK;
    }

    private static final boolean flattenNestedNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean flattenNestedNodes$lambda$2(ASTNode it) {
        Intrinsics.checkNotNull((Object)it);
        return !SqlUtilFun.isWhitespace(it);
    }

    private static final boolean flattenNestedNodes$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

