/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/formatter/model/SimplePattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "startWithMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "continueMatcher", "continueIsMandatory", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;Lcom/intellij/sql/formatter/model/NodeMatcher;Lcom/intellij/sql/formatter/model/NodeMatcher;ZLcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.core.impl"})
public final class SimplePattern
extends FlowPattern {
    @NotNull
    private final NodeMatcher startWithMatcher;
    @NotNull
    private final NodeMatcher continueMatcher;
    private final boolean continueIsMandatory;
    @NotNull
    private final BlockRole role;

    public SimplePattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull NodeMatcher startWithMatcher, @NotNull NodeMatcher continueMatcher, boolean continueIsMandatory, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)startWithMatcher, (String)"startWithMatcher");
        Intrinsics.checkNotNullParameter((Object)continueMatcher, (String)"continueMatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.startWithMatcher = startWithMatcher;
        this.continueMatcher = continueMatcher;
        this.continueIsMandatory = continueIsMandatory;
        this.role = role;
    }

    public /* synthetic */ SimplePattern(Byte by, Byte by2, NodeMatcher nodeMatcher, NodeMatcher nodeMatcher2, boolean bl, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(by, by2, nodeMatcher, nodeMatcher2, bl, blockRole, (Function0<? extends SqlBlock>)function0);
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes2, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        int n = nodes2.size();
        if (since >= n) {
            return null;
        }
        ASTNode firstNode = nodes2.get(since);
        if (NodeMatcherKt.doesntMatch(firstNode, this.startWithMatcher)) {
            return null;
        }
        int k = 1;
        while (since + k < n && NodeMatcherKt.matches(nodes2.get(since + k), this.continueMatcher)) {
            ++k;
        }
        if (k == 1 && this.continueIsMandatory) {
            return null;
        }
        return RangesKt.until((int)since, (int)(since + k));
    }
}

