/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.psi.SqlCommonTokens;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u0002\u001a&\u0010\b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a/\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0082\u0010\u001a\u001e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a8\u0006\u0011"}, d2={"parseRow", "", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "rowMatchers", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "parseUntil", "untilMatcher", "stepCommentBack", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "begin", "end", "skipSpaces", "index", "intellij.database.sql.core.impl"})
public final class FlowPatternKt {
    private static final int parseRow(List<? extends ASTNode> nodes2, int since, List<? extends NodeMatcher> rowMatchers) {
        int n = nodes2.size();
        int l = rowMatchers.size();
        int s = since;
        int m = 0;
        while (s < n && m < l) {
            NodeMatcher matcher;
            ASTNode node;
            if (SqlUtilFun.isWhitespaceOrComment(node = nodes2.get(s++))) continue;
            if (!(matcher = rowMatchers.get(m++)).matches(node)) {
                return 0;
            }
            if (m != l) continue;
            return s - since;
        }
        return 0;
    }

    private static final int parseUntil(List<? extends ASTNode> nodes2, int since, NodeMatcher untilMatcher) {
        int n = nodes2.size();
        int par = 0;
        for (int k = since; k < n; ++k) {
            ASTNode theNode = nodes2.get(k);
            if (par <= 0 && NodeMatcherKt.matches(theNode, untilMatcher)) {
                return k;
            }
            IElementType iElementType = theNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonTokens.SQL_LEFT_PAREN))) {
                ++par;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonTokens.SQL_RIGHT_PAREN))) continue;
            --par;
        }
        return n;
    }

    private static final int stepCommentBack(SqlFormattingContext context, List<? extends ASTNode> nodes2, int begin, int end) {
        while (true) {
            Object object;
            boolean bl;
            boolean bl2 = bl = begin >= 0;
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            boolean bl3 = bl = end <= nodes2.size();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            int newEnd = end;
            int n = begin + 1;
            int m = end - 1;
            if (n <= m) {
                ASTNode nodeEnd;
                while (SqlUtilFun.isWhitespaceOrComment(nodeEnd = nodes2.get(m))) {
                    ASTNode nodePreEnd = nodes2.get(m - 1);
                    if (((SqlFormattingContext)context).textContainsBetween(nodePreEnd, nodeEnd, '\n')) {
                        newEnd = m;
                        break;
                    }
                    if (m == n) break;
                    --m;
                }
            }
            if (newEnd == end) {
                return end;
            }
            object = context;
            List<? extends ASTNode> list = nodes2;
            int n2 = begin;
            int n3 = newEnd;
            context = object;
            nodes2 = list;
            begin = n2;
            end = n3;
        }
    }

    private static final int skipSpaces(int index, List<? extends ASTNode> nodes2) {
        ASTNode node;
        int i2;
        int n = nodes2.size();
        for (i2 = index; i2 < n && SqlUtilFun.isWhitespace(node = nodes2.get(i2)); ++i2) {
        }
        return i2;
    }

    public static final /* synthetic */ int access$parseRow(List nodes2, int since, List rowMatchers) {
        return FlowPatternKt.parseRow(nodes2, since, rowMatchers);
    }

    public static final /* synthetic */ int access$parseUntil(List nodes2, int since, NodeMatcher untilMatcher) {
        return FlowPatternKt.parseUntil(nodes2, since, untilMatcher);
    }

    public static final /* synthetic */ int access$stepCommentBack(SqlFormattingContext context, List nodes2, int begin, int end) {
        return FlowPatternKt.stepCommentBack(context, nodes2, begin, end);
    }

    public static final /* synthetic */ int access$skipSpaces(int index, List nodes2) {
        return FlowPatternKt.skipSpaces(index, nodes2);
    }
}

