/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlValidatingHighlightVisitorKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "delegate", "Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "analyze", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "Delegate", "intellij.database.sql.core.impl"})
public final class SqlValidatingHighlightVisitor
implements HighlightVisitor,
DumbAware {
    @Nullable
    private Delegate delegate;

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof SqlFile;
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        try {
            SqlElement sqlElement = element instanceof SqlElement ? (SqlElement)element : null;
            if (sqlElement != null) {
                sqlElement.accept(this.delegate);
            }
        }
        catch (IndexNotReadyException e) {
            SqlValidatingHighlightVisitorKt.access$getLOG$p().error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.delegate = SqlPsiUtilKt.getSqlDialect((PsiElement)psiFile).createValidationDelegate(holder);
        try {
            action.run();
        }
        finally {
            this.delegate = null;
        }
        return true;
    }

    @NotNull
    public SqlValidatingHighlightVisitor clone() {
        return new SqlValidatingHighlightVisitor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J.\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004J&\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004J&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "Lcom/intellij/sql/psi/SqlVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "<init>", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getHolder", "()Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "report", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "fix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "reportError", "reportWarning", "intellij.database.sql.core.impl"})
    public static abstract class Delegate
    extends SqlVisitor {
        @NotNull
        private final SqlLanguageDialectEx dialect;
        @NotNull
        private final HighlightInfoHolder holder;

        public Delegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.dialect = dialect;
            this.holder = holder;
        }

        @NotNull
        protected final SqlLanguageDialectEx getDialect() {
            return this.dialect;
        }

        @NotNull
        protected final HighlightInfoHolder getHolder() {
            return this.holder;
        }

        protected final void report(@NotNull HighlightInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            this.holder.add(info2);
        }

        protected final void report(@NotNull PsiElement element, @InspectionMessage @NotNull String message, @NotNull HighlightInfoType infoType, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)infoType, (String)"infoType");
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infoType).range(element).descriptionAndTooltip(message);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"descriptionAndTooltip(...)");
            HighlightInfo.Builder builder2 = builder;
            if (fix != null) {
                builder2.registerFix(fix, CollectionsKt.emptyList(), fix.getFamilyName(), null, null);
            }
            HighlightInfo highlightInfo = builder2.create();
            if (highlightInfo == null) {
                return;
            }
            HighlightInfo info2 = highlightInfo;
            this.report(info2);
        }

        public static /* synthetic */ void report$default(Delegate delegate, PsiElement psiElement, String string, HighlightInfoType highlightInfoType, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
            }
            if ((n & 8) != 0) {
                intentionAction = null;
            }
            delegate.report(psiElement, string, highlightInfoType, intentionAction);
        }

        protected final void reportError(@NotNull PsiElement element, @InspectionMessage @NotNull String message, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"ERROR");
            this.report(element, message, highlightInfoType, fix);
        }

        public static /* synthetic */ void reportError$default(Delegate delegate, PsiElement psiElement, String string, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportError");
            }
            if ((n & 4) != 0) {
                intentionAction = null;
            }
            delegate.reportError(psiElement, string, intentionAction);
        }

        protected final void reportWarning(@NotNull PsiElement element, @InspectionMessage @NotNull String message, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"WARNING");
            this.report(element, message, highlightInfoType, fix);
        }

        public static /* synthetic */ void reportWarning$default(Delegate delegate, PsiElement psiElement, String string, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportWarning");
            }
            if ((n & 4) != 0) {
                intentionAction = null;
            }
            delegate.reportWarning(psiElement, string, intentionAction);
        }
    }
}

