/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "element", "isRecursiveCall", "", "refExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "collectSlowLineMarkers", "", "elements", "", "result", "", "SqlRecursiveCallMarkerInfo", "intellij.database.sql.impl"})
public final class SqlRecursiveCallLineMakerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = SqlBundle.message("SqlRecursiveCallLineMakerProvider.gutter.name.recursive.call", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RecursiveMethod");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    private final boolean isRecursiveCall(SqlReferenceExpression refExpr) {
        Iterator iterator = ArrayIteratorKt.iterator((Object[])refExpr.multiResolve(false));
        while (iterator.hasNext()) {
            PsiElement target2;
            block10: {
                block9: {
                    ResolveResult result2 = (ResolveResult)iterator.next();
                    if (result2.getElement() == null) continue;
                    if (!(target2 instanceof SqlRoutineDefinition)) break block9;
                    PsiElement psiElement = refExpr.getParent();
                    SqlFunctionCallExpression sqlFunctionCallExpression = psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
                    if (Intrinsics.areEqual((Object)(sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getNameElement() : null), (Object)refExpr)) break block10;
                }
                if (!(target2 instanceof SqlAsExpression)) continue;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)refExpr), (boolean)true)) {
                return true;
            }
            PsiFile psiFile = refExpr.getContainingFile();
            SqlCodeFragment sqlCodeFragment = psiFile instanceof SqlCodeFragment ? (SqlCodeFragment)psiFile : null;
            if (sqlCodeFragment == null) {
                return false;
            }
            SqlCodeFragment file = sqlCodeFragment;
            if (!SqlPsiUtilKt.getSqlDialect((PsiElement)file).getDbms().isSnowflake()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)file.getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION)) {
                return false;
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
            if (psiLanguageInjectionHost == null) {
                return false;
            }
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            return PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)injectionHost), (boolean)true);
        }
        return false;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement : elements) {
            SqlReferenceExpression refExpr;
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = psiElement.getParent();
            SqlIdentifier sqlIdentifier = psiElement2 instanceof SqlIdentifier ? (SqlIdentifier)psiElement2 : null;
            PsiElement psiElement22 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
            SqlReferenceExpression sqlReferenceExpression = psiElement22 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement22 : null;
            if (sqlReferenceExpression == null || !this.isRecursiveCall(refExpr = sqlReferenceExpression)) continue;
            result2.add(new SqlRecursiveCallMarkerInfo(psiElement));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider$SqlRecursiveCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "name", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.database.sql.impl"})
    private static final class SqlRecursiveCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public SqlRecursiveCallMarkerInfo(@NotNull PsiElement name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2, name2.getTextRange(), AllIcons.Gutter.RecursiveMethod, arg_0 -> SqlRecursiveCallMarkerInfo._init_$lambda$1(SqlRecursiveCallMarkerInfo::_init_$lambda$0, arg_0), null, GutterIconRenderer.Alignment.RIGHT);
        }

        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static final String _init_$lambda$0(PsiElement it) {
            return SqlBundle.message("SqlRecursiveCallLineMakerProvider.gutter.name.recursive.call", new Object[0]);
        }

        private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    }
}

