/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.database.Dbms;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlGenerateGroup
extends ActionGroup
implements DumbAware {
    private static final ObjectKind[] ourOldOrder = new ObjectKind[]{ObjectKind.PACKAGE, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.TABLE, ObjectKind.TRIGGER, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.SCHEMA, ObjectKind.DATABASE, ObjectKind.ROLE, ObjectKind.USER};

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SqlGenerateGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Dbms dbms;
        Dbms dbms2 = dbms = e == null ? null : this.getDbms(e);
        if (dbms == null) {
            if (EMPTY_ARRAY == null) {
                SqlGenerateGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        BasicMetaModel<?> model = DbImplUtilCore.getMetaModel(dbms);
        ArrayList<Block> children2 = new ArrayList<Block>();
        children2.add(new Block());
        ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> ContainerUtil.sorted(Arrays.asList(o.children), BasicMetaUtils.PRESENTATION_COMPARATOR)).withRoot(model.root)).expand(o -> o.kindOf(BasicNamespace.class) || o.kindOf(BasicRoot.class))).filter(o -> o.kind != ObjectKind.ROOT)).postOrderDfsTraversal().sort(Comparator.comparing(o -> this.ord((BasicMetaObject<?>)o))).forEach(o -> {
            SqlGenerateGroup.createActions(o, children2);
            this.getExtraChild((BasicMetaObject<?>)o).forEach(c2 -> SqlGenerateGroup.createActions(c2, children2));
        });
        AnAction[] anActionArray = children2.toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            SqlGenerateGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    @NotNull
    protected Iterable<BasicMetaObject<?>> getExtraChild(BasicMetaObject<?> o) {
        BasicMetaObject body2 = BasicMetaUtils.findChild(o, ObjectKind.BODY);
        if (body2 != null) {
            JBIterable jBIterable = JBIterable.of(body2);
            if (jBIterable == null) {
                SqlGenerateGroup.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        Dbms dbms = o.getModel().dbms;
        if (o.kind == ObjectKind.PACKAGE && dbms == Dbms.SYBASE) {
            JBIterable jBIterable = JBIterable.of(BasicMetaUtils.findChild(o, ObjectKind.ROUTINE));
            if (jBIterable == null) {
                SqlGenerateGroup.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (o.kind == ObjectKind.TABLE) {
            SqlLanguageDialectEx dialect = (SqlLanguageDialectEx)DbSqlUtilCore.getSqlDialect(dbms);
            JBIterable jBIterable = JBIterable.of((Object[])o.children).filter(c2 -> dialect.isMajorChild(c2.kind) && c2.kind != ObjectKind.KEY);
            if (jBIterable == null) {
                SqlGenerateGroup.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlGenerateGroup.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    protected int ord(BasicMetaObject<?> o) {
        int idx = ArrayUtil.indexOf((Object[])ourOldOrder, (Object)o.kind);
        return idx == -1 ? Integer.MAX_VALUE : idx;
    }

    private static void createActions(@NotNull BasicMetaObject<?> meta, @NotNull List<AnAction> res2) {
        JBIterable<ModelHelper.ObjectKindVariant> variants;
        if (meta == null) {
            SqlGenerateGroup.$$$reportNull$$$0(7);
        }
        if (res2 == null) {
            SqlGenerateGroup.$$$reportNull$$$0(8);
        }
        if ((variants = ModelFacade.forDbms(meta.getModel().dbms).getModelHelper().generationVariants(meta)).isEmpty()) {
            return;
        }
        for (ModelHelper.ObjectKindVariant variant : variants) {
            res2.add((AnAction)new PoorMansGenerateAction(meta, variant));
        }
    }

    public Dbms getDbms(@NotNull AnActionEvent e) {
        PsiFile file;
        if (e == null) {
            SqlGenerateGroup.$$$reportNull$$$0(9);
        }
        if (!((file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) instanceof SqlFile)) {
            return null;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        int offset = editor2 == null ? 0 : editor2.getCaretModel().getOffset();
        PsiElement elementAt = SqlGenerateGroup.findElementAt(file, offset);
        return SqlGenerateGroup.getDialectAt(file, elementAt).getDbms();
    }

    @TestOnly
    public static Pair<String, Map<String, Expression>> getTemplateAndVariables(@NotNull AnAction action, @NotNull Project project, @NotNull Dbms dbms) {
        SqlLanguageDialect dialect;
        GenerateActionBase ac;
        if (action == null) {
            SqlGenerateGroup.$$$reportNull$$$0(10);
        }
        if (project == null) {
            SqlGenerateGroup.$$$reportNull$$$0(11);
        }
        if (dbms == null) {
            SqlGenerateGroup.$$$reportNull$$$0(12);
        }
        return (ac = (GenerateActionBase)action).isSqlDialectSupported(dialect = DbSqlUtilCore.getSqlDialect(dbms)) ? ac.getTemplateAndVariables(project, dialect, null, ";") : null;
    }

    @TestOnly
    public static String getName(@NotNull AnAction action, @NotNull Dbms dbms) {
        if (action == null) {
            SqlGenerateGroup.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            SqlGenerateGroup.$$$reportNull$$$0(14);
        }
        return ((GenerateActionBase)action).getText(dbms);
    }

    private static boolean onTopLevel(@Nullable PsiElement element) {
        return SyntaxTraverser.psiApi().parents((Object)element).skip(1).filter(SqlStatement.class).isEmpty();
    }

    @NotNull
    private static SqlLanguageDialect getDialectAt(PsiFile file, PsiElement elementAt) {
        SqlLanguageDialect dialect = null;
        if (elementAt != null) {
            PsiElement o;
            IElementType elementType;
            Iterator iterator = SyntaxTraverser.psiApi().parents((Object)elementAt).iterator();
            while (iterator.hasNext() && (dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)(elementType = PsiUtilCore.getElementType((PsiElement)(o = (PsiElement)iterator.next()))).getLanguage(), SqlLanguageDialect.class)) == null) {
            }
        }
        if (dialect == null) {
            dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)(elementAt != null ? elementAt : file));
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = dialect;
        if (sqlLanguageDialectEx == null) {
            SqlGenerateGroup.$$$reportNull$$$0(15);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    private static PsiElement findElementAt(@NotNull PsiFile file, int offset) {
        PsiElement e1;
        if (file == null) {
            SqlGenerateGroup.$$$reportNull$$$0(16);
        }
        return (e1 = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) != null ? e1 : file.findElementAt(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 9, 10, 11, 12, 13, 14, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraChild";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectAt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateAndVariables";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 9, 10, 11, 12, 13, 14, 16 -> new IllegalArgumentException(string);
        };
    }

    private static class Block
    extends GenerateActionBase {
        private Block() {
        }

        @Override
        protected String getTemplateText(@NotNull SqlLanguageDialect dialect, @NotNull String delimiter) {
            Dbms dbms;
            if (dialect == null) {
                Block.$$$reportNull$$$0(0);
            }
            if (delimiter == null) {
                Block.$$$reportNull$$$0(1);
            }
            if ((dbms = dialect.getDbms()).isOracle() || dbms.isDb2() || dbms.isMicrosoft() || dbms.isSybase() || dbms.isPostgres() && dialect instanceof InjectableLanguage) {
                return "BEGIN\n  $END$\nEND" + delimiter;
            }
            return null;
        }

        @Override
        @NotNull
        protected Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                Block.$$$reportNull$$$0(2);
            }
            return new HashMap<String, Expression>();
        }

        @Override
        @NotNull
        String getText(@NotNull Dbms dbms) {
            if (dbms == null) {
                Block.$$$reportNull$$$0(3);
            }
            String string = SqlBundle.message("SqlGenerateGroup.action.block.text", new Object[0]);
            if (string == null) {
                Block.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        protected boolean isInContext(@Nullable PsiElement element) {
            return super.isInContext(element) || !SyntaxTraverser.psiApi().parents((Object)element).filter(SqlBlockStatementImpl.class).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$Block";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$Block";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PoorMansGenerateAction
    extends GenerateActionBase {
        private final BasicMetaObject<?> myMeta;
        private final ModelHelper.ObjectKindVariant myVariant;

        private PoorMansGenerateAction(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
            if (meta == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(0);
            }
            if (variant == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(1);
            }
            this.myMeta = meta;
            this.myVariant = variant;
        }

        @Override
        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(2);
            }
            ScriptingCapabilities caps = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(this.myMeta.getModel().dbms)).capabilities((BasicElement)this.myMeta.newDataObject());
            return caps.getCreateAlone().get(Version.INFINITY);
        }

        @Override
        @Nullable
        protected String getTemplateText(@NotNull SqlLanguageDialect language, @NotNull String delimiter) {
            if (language == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(3);
            }
            if (delimiter == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(4);
            }
            return null;
        }

        @Override
        @Nullable
        protected Pair<String, Map<String, Expression>> getTemplateAndVariables(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable PsiFile file, @NotNull String delimiter) {
            if (project == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(5);
            }
            if (dialect == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(6);
            }
            if (delimiter == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(7);
            }
            Dbms dbms = this.myMeta.getModel().dbms;
            BasicModElement element = ModelLightCopier.lightInstantiate(this.myMeta, new ModelFactory(new MemoryTextStorage()));
            LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
            ModelFacade.forDbms(dbms).getModelHelper().fillPropertiesWithExamples(element, this.myVariant, examples, true);
            ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(element.getModel(), ScriptCategory.CREATE_DEFINITION);
            builder.setCodeStyle(file == null ? SqlCodeStyles.getSettings(project) : CodeStyle.getSettings((PsiFile)file));
            builder.getElements().add(element);
            ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(project, builder.build());
            LinkedHashMap<String, Expression> vars = new LinkedHashMap<String, Expression>();
            StringBuilder text2 = new StringBuilder();
            int lastDelim = -1;
            int okStart = 0;
            boolean eolnIfNotSep = false;
            for (CompositeText.Fragment fragment : result2.getScript().getFragments()) {
                if (eolnIfNotSep && fragment.getKind() != CompositeText.Kind.SQL_DELIMITER) {
                    text2.append("\n");
                }
                eolnIfNotSep = false;
                if (fragment.getError() != null) {
                    String erroneous;
                    if (okStart != fragment.getBegin()) {
                        PoorMansGenerateAction.replaceExamples(examples, vars, text2, okStart);
                    }
                    boolean isSrc = (erroneous = fragment.getText().toString()).contains("-- missing source code\n") || erroneous.contains("-- no source code\n") || erroneous.contains("-- definition not supported\n") || erroneous.contains("-- no definition available\n");
                    String varName = isSrc ? "src" : "error" + vars.size();
                    text2.append("$").append(varName).append("$");
                    vars.put(varName, (Expression)new ConstantNode(isSrc ? "-- todo: implement" : erroneous));
                    okStart = text2.length();
                    eolnIfNotSep = isSrc;
                    continue;
                }
                if (fragment.getKind() == CompositeText.Kind.SQL_DELIMITER) {
                    lastDelim = text2.length();
                }
                text2.append(fragment.getText().toString().replace("$", "$$"));
            }
            if (lastDelim != -1) {
                text2.replace(lastDelim, text2.length(), "$END$" + delimiter);
            }
            PoorMansGenerateAction.replaceExamples(examples, vars, text2, okStart);
            return Pair.create((Object)text2.toString(), vars);
        }

        private static void replaceExamples(Map<String, String> examples, Map<String, Expression> vars, StringBuilder text2, int startIdx) {
            for (Map.Entry<String, String> entry : examples.entrySet()) {
                int idx = startIdx;
                String name2 = entry.getKey();
                String example = entry.getValue();
                while ((idx = text2.indexOf(example, idx)) != -1) {
                    String repl = "$" + name2 + "$";
                    text2.replace(idx, idx + example.length(), repl);
                    vars.put(name2, (Expression)new ConstantNode(example));
                    idx += repl.length();
                }
            }
        }

        @Override
        @NotNull
        Map<String, Expression> getVariables(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(8);
            }
            Map<String, Expression> map2 = Collections.emptyMap();
            if (map2 == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(9);
            }
            return map2;
        }

        @Override
        @NotNull
        String getText(@NotNull Dbms dbms) {
            if (dbms == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(10);
            }
            String string = this.myVariant.getText(this.myMeta);
            if (string == null) {
                PoorMansGenerateAction.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$PoorMansGenerateAction";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$PoorMansGenerateAction";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSqlDialectSupported";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateText";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateAndVariables";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class GenerateActionBase
    extends CodeInsightAction
    implements CodeInsightActionHandler {
        private GenerateActionBase() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
            if (project == null) {
                GenerateActionBase.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                GenerateActionBase.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                GenerateActionBase.$$$reportNull$$$0(2);
            }
            int offset = editor2.getCaretModel().getOffset();
            PsiElement elementAt = SqlGenerateGroup.findElementAt(psiFile, offset);
            SqlLanguageDialect dialect = SqlGenerateGroup.getDialectAt(psiFile, elementAt);
            PsiFile targetFile = elementAt == null ? psiFile : elementAt.getContainingFile();
            int targetOffset = elementAt == null ? offset : elementAt.getTextOffset();
            String delimiter = this.getDelimiter(targetFile, targetOffset);
            Pair<String, Map<String, Expression>> data = this.getTemplateAndVariables(psiFile.getProject(), dialect, psiFile, delimiter);
            if (data == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "", (String)data.first);
            Map vars = (Map)data.second;
            for (Map.Entry var : vars.entrySet()) {
                template.addVariable((String)var.getKey(), (Expression)var.getValue(), true);
            }
            template.setToReformat(true);
            templateManager.startTemplate(editor2, template);
        }

        @Nullable
        protected Pair<String, Map<String, Expression>> getTemplateAndVariables(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable PsiFile file, @NotNull String delimiter) {
            String text2;
            if (project == null) {
                GenerateActionBase.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                GenerateActionBase.$$$reportNull$$$0(4);
            }
            if (delimiter == null) {
                GenerateActionBase.$$$reportNull$$$0(5);
            }
            return (text2 = this.getTemplateText(dialect, delimiter)) == null ? null : Pair.create((Object)text2, this.getVariables(dialect));
        }

        @Nullable
        protected abstract String getTemplateText(@NotNull SqlLanguageDialect var1, @NotNull String var2);

        @NotNull
        abstract Map<String, Expression> getVariables(@NotNull SqlLanguageDialect var1);

        @NotNull
        protected CodeInsightActionHandler getHandler() {
            GenerateActionBase generateActionBase = this;
            if (generateActionBase == null) {
                GenerateActionBase.$$$reportNull$$$0(6);
            }
            return generateActionBase;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GenerateActionBase.$$$reportNull$$$0(7);
            }
            super.update(e);
            PsiElement elementAt = null;
            SqlLanguageDialect dialect = null;
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (file instanceof SqlFile && editor2 != null) {
                int offset = editor2.getCaretModel().getOffset();
                elementAt = SqlGenerateGroup.findElementAt(file, offset);
                dialect = SqlGenerateGroup.getDialectAt(file, elementAt);
            }
            boolean available = this.isAvailable(dialect, elementAt);
            Presentation presentation = e.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            Dbms dbms = dialect == null ? Dbms.UNKNOWN : dialect.getDbms();
            presentation.setText(this.getText(dbms));
            presentation.setDescription(this.getDescription(dbms));
        }

        protected boolean isAvailable(@Nullable SqlLanguageDialect dialect, @Nullable PsiElement elementAt) {
            if (dialect == null || !this.isSqlDialectSupported(dialect)) {
                return false;
            }
            return this.isInContext(elementAt);
        }

        protected boolean isInContext(@Nullable PsiElement element) {
            return SqlGenerateGroup.onTopLevel(element);
        }

        @NotNull
        @NlsActions.ActionText
        abstract String getText(@NotNull Dbms var1);

        @NotNull
        @NlsActions.ActionDescription
        protected String getDescription(@NotNull Dbms dbms) {
            if (dbms == null) {
                GenerateActionBase.$$$reportNull$$$0(8);
            }
            String string = SqlBundle.message("SqlGenerateGroup.action.creates.description", StringUtil.toLowerCase((String)this.getText(dbms)));
            if (string == null) {
                GenerateActionBase.$$$reportNull$$$0(9);
            }
            return string;
        }

        protected boolean isSqlDialectSupported(@NotNull SqlLanguageDialect dialect) {
            if (dialect == null) {
                GenerateActionBase.$$$reportNull$$$0(10);
            }
            return this.getTemplateText(dialect, "") != null;
        }

        @NotNull
        protected String getDelimiter(@NotNull PsiFile file, int offset) {
            String delim;
            if (file == null) {
                GenerateActionBase.$$$reportNull$$$0(11);
            }
            Object object = DbSqlUtilCore.delimiterNeedsSpacing(delim = DbSqlUtilCore.getDelimiterAt(file, offset).replace("$", "$$")) ? " " + delim : delim;
            if (object == null) {
                GenerateActionBase.$$$reportNull$$$0(12);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiter";
                    break;
                }
                case 6: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlGenerateGroup$GenerateActionBase";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlGenerateGroup$GenerateActionBase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelimiter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplateAndVariables";
                    break;
                }
                case 6: 
                case 9: 
                case 12: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isSqlDialectSupported";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelimiter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9, 12 -> new IllegalStateException(string);
            };
        }
    }
}

