/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.dialects.sybase.AseOptionalKeywords;
import com.intellij.sql.dialects.sybase.AseReservedKeywords;
import com.intellij.sql.dialects.sybase.AseTokens;
import com.intellij.sql.dialects.sybase.refactoring.AseExtractFunctionHelper;
import com.intellij.sql.dialects.sybase.refactoring.AseExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AseDialect
extends SqlLanguageDialectBase {
    public static final AseDialect INSTANCE = new AseDialect();

    private AseDialect() {
        super("Sybase");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(AseTokens.class);
        if (tokensHelper == null) {
            AseDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SYBASE;
        if (dbms == null) {
            AseDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            AseDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String referenceName, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            AseDialect.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            AseDialect.$$$reportNull$$$0(4);
        }
        for (ReservedEntity.Typed entity : LazyData.ourTypedEntities) {
            if (AseDialect.processReservedEntitiesWithTypeSimple(entity, entity.type, referenceName, place, resolve2, processor2, true, null)) continue;
            return false;
        }
        return MsDialect.INSTANCE.processReservedEntitiesWithType(referenceName, place, resolve2, processor2);
    }

    @Override
    @Nullable
    public Condition<DasObject> getAdditionalExpandCondition(@NotNull SqlScopeProcessor processor2, @NotNull PsiElement place) {
        PsiElement parent;
        PsiElement grandParent;
        if (processor2 == null) {
            AseDialect.$$$reportNull$$$0(5);
        }
        if (place == null) {
            AseDialect.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = grandParent = (parent = place.getParent()) != null ? parent.getParent() : null;
        if (processor2.mayAccept(ObjectKind.PACKAGE) && grandParent instanceof SqlFunctionCallExpression && grandParent.getParent() instanceof SqlCallStatement) {
            return o -> o.getKind() == ObjectKind.SCHEMA && o.getName().equals("dbo") || o.getKind() == ObjectKind.DATABASE && o.getName().equals("sybsystemprocs");
        }
        return null;
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            AseDialect.$$$reportNull$$$0(7);
        }
        return identifier.isQuotedIdentifier() ? 253 : 255;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (identifier == null) {
            AseDialect.$$$reportNull$$$0(8);
        }
        if (newElementName == null) {
            AseDialect.$$$reportNull$$$0(9);
        }
        if (kind == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName, kind);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MsDialect.isExecArg(o)) {
            return false;
        }
        return super.shallResolve(o, type);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref2) {
        if (ref2 == null) {
            AseDialect.$$$reportNull$$$0(10);
        }
        return !this.getKeywords().contains(ref2);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName[] dsNames) {
        ObjectName dbname = AseDialect.getDatabaseName(dataSource);
        ObjectName schemaName = AseDialect.getSchemaName(dataSource);
        DasNamespace namespace = AseDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                AseDialect.$$$reportNull$$$0(11);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, SqlImportUtil.createNodeIfNotNull(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            AseDialect.$$$reportNull$$$0(12);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.plain("dbo")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            AseDialect.$$$reportNull$$$0(13);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        ObjectName schemaName = AseDialect.getSchemaName(dataSource);
        ObjectName databaseName = AseDialect.getDatabaseName(dataSource);
        TreePatternNode.Group[] schemas = schemaName == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(schemaName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(databaseName, ObjectKind.DATABASE, schemas)});
        TreePattern treePattern = SqlDialectImplUtilCore.forcedContextExpandedToSchemas(dataSource, this.getDbms(), searchPath, schemas, databases);
        if (treePattern == null) {
            AseDialect.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            AseDialect.$$$reportNull$$$0(15);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            AseDialect.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    @Override
    protected TreePattern createRefPattern(@NotNull TreePattern prev2, @NotNull SqlReferenceExpression ref2) {
        if (prev2 == null) {
            AseDialect.$$$reportNull$$$0(17);
        }
        if (ref2 == null) {
            AseDialect.$$$reportNull$$$0(18);
        }
        return SqlDialectImplUtilCore.refPatternExpandedToSchema(prev2, ref2, this);
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            AseDialect.$$$reportNull$$$0(19);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlMergeStatement.class}) != null;
    }

    @Override
    @NotNull
    public SqlExtractVariableHelper getExtractVariableHelper() {
        AseExtractVariableHelper aseExtractVariableHelper = AseExtractVariableHelper.INSTANCE;
        if (aseExtractVariableHelper == null) {
            AseDialect.$$$reportNull$$$0(20);
        }
        return aseExtractVariableHelper;
    }

    @Override
    @NotNull
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        AseExtractFunctionHelper aseExtractFunctionHelper = AseExtractFunctionHelper.INSTANCE;
        if (aseExtractFunctionHelper == null) {
            AseDialect.$$$reportNull$$$0(21);
        }
        return aseExtractFunctionHelper;
    }

    @Override
    @NotNull
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.tail(SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON).mask(true, true, false)));
    }

    @Nullable
    private static ObjectName getSchemaName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain(SqlDialectImplUtilCore.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
    }

    @NotNull
    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        ObjectName objectName = ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master"));
        if (objectName == null) {
            AseDialect.$$$reportNull$$$0(22);
        }
        return objectName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sybase/AseDialect";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sybase/AseDialect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractVariableHelper";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractFunctionHelper";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final List<ReservedEntity.Typed> ourTypedEntities = SqlDialectImplUtilCore.loadEntities(INSTANCE);
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{AseOptionalKeywords.ASE_GO})});
        static final Set<IElementType> ourSupportedOperators = Set.of(new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, AseReservedKeywords.ASE_XMLTEST});

        LazyData() {
        }
    }
}

