/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.dialects.redshift.RsElementTypes;
import com.intellij.sql.dialects.redshift.RsTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RsDialect
extends PgDialectBase {
    public static final RsDialect INSTANCE = new RsDialect();

    private RsDialect() {
        super("Redshift");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(RsTokens.class);
        if (tokensHelper == null) {
            RsDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.REDSHIFT;
        if (dbms == null) {
            RsDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            RsDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        PgCreatePreparedStatement preparedStatement;
        if (place == null) {
            RsDialect.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            RsDialect.$$$reportNull$$$0(4);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor2)) {
            return false;
        }
        if (resolve2 && name2 != null && LazyData.ARG_PATTERN.matcher(name2).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor2.executeTarget(preparedStatement.getArgument(name2), DasTypeSystemBase.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (processor2.isExpected(SqlDbElementType.COLUMN)) {
            for (ReservedEntity entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                if (RsDialect.processReservedEntitiesWithTypeSimple(entity, this.getTypeSystem().getIntType(), name2, place, resolve2, processor2, true, false)) continue;
                return false;
            }
        }
        if (place instanceof SqlReferenceExpression && resolve2 && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor2.executeTarget(object, null, false, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            RsDialect.$$$reportNull$$$0(5);
        }
        return 127;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        ObjectName dbname = ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName(config), (Object)SqlDialectImplUtilCore.getUserName(config)));
        DasNamespace namespace = RsDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, DbImplUtilCore.isSchema(namespace) ? null : TreePatternUtils.create(ObjectName.quoted("public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                RsDialect.$$$reportNull$$$0(6);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, TreePatternUtils.create(ObjectName.quoted("public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            RsDialect.$$$reportNull$$$0(7);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted("pg_catalog")), true, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            RsDialect.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            RsDialect.$$$reportNull$$$0(9);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlInsertStatement.class, SqlUpdateStatement.class}) != null;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        SqlCommentStatementImpl comment;
        PsiElement psiElement;
        if (expectedTypes == null) {
            RsDialect.$$$reportNull$$$0(10);
        }
        if (!strict && type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        if (type == SqlDbElementType.EXTERNAL_DATABASE && expectedTypes.contains(SqlDbElementType.DATABASE)) {
            return true;
        }
        if ((type == SqlDbElementType.EXTERNAL_SCHEMA || symbol != null && type == SqlDbElementType.LOCAL_ALIAS) && expectedTypes.contains(SqlDbElementType.SCHEMA)) {
            return true;
        }
        if (type == SqlDbElementType.FOREIGN_FUNCTION && expectedTypes.contains(SqlDbElementType.ROUTINE)) {
            return true;
        }
        if (type == SqlDbElementType.COLUMN && expectedTypes.contains(SqlDbElementType.TABLE) && PsiTreeUtil.getContextOfType((PsiElement)place, SqlSelectStatement.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) != null) {
            return true;
        }
        if (place != null && type == SqlDbElementType.MAT_VIEW && (psiElement = place.getParent()) instanceof SqlCommentStatementImpl && (comment = (SqlCommentStatementImpl)psiElement).getCommentKind() == SqlTokens.SQL_VIEW) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        SqlCommentStatementImpl comment;
        PsiElement psiElement;
        if (expectedTypes == null) {
            RsDialect.$$$reportNull$$$0(11);
        }
        if (place != null && type == SqlDbElementType.MAT_VIEW && !expectedTypes.contains(type) && (psiElement = place.getParent()) instanceof SqlCommentStatementImpl && (comment = (SqlCommentStatementImpl)psiElement).getCommentKind() == SqlTokens.SQL_TABLE) {
            return true;
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            RsDialect.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T parentTypes = super.getParentDbTypes(result2, type);
        if (type == SqlDbElementType.TABLE) {
            parentTypes.add((ObjectKind)SqlDbElementType.EXTERNAL_SCHEMA);
        }
        if (type == SqlDbElementType.COLUMN) {
            parentTypes.add((ObjectKind)RsElementTypes.Kinds.RLS_POLICY);
        }
        return parentTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 7, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/redshift/RsDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/redshift/RsDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 7, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final Set<IElementType> ourSupportedOperators = Set.of(new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.ORA_OP_JOIN});
        static final Map<String, ReservedEntity> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtilCore.buildEntities(Dbms.REDSHIFT, SqlDbElementType.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX);

        LazyData() {
        }
    }
}

