/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.actions.members.SqlMembersHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddDefinitionFix", "intellij.database.dialects.oracle.ex"})
public final class OraUnmatchedForwardDeclarationInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        NavigationHelper helper = NavigationHelper.EP.forDbms(dialect.getDbms());
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, helper, onTheFly){
            final /* synthetic */ NavigationHelper $helper;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$helper = $helper;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlBlockStatement(SqlBlockStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlBlockStatement(o);
                this.checkBlock(o);
            }

            public void visitSqlCreateStatement(SqlCreateStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlCreateStatement(o);
                if (Intrinsics.areEqual((Object)o.getKind(), (Object)ObjectKind.BODY)) {
                    this.checkBlock(o);
                }
            }

            private final void checkBlock(SqlElement block) {
                for (PsiElement child : SqlImplUtil.sqlChildren((PsiElement)block)) {
                    Pair<String, JBIterable<? extends DasObject>> definitions;
                    if (!(child instanceof SqlRoutineDefinition) || ((SqlRoutineDefinition)child).getBody().isNotEmpty() || (definitions = this.$helper.findDefinitions((DasObject)child, false)) != null && !((JBIterable)definitions.second).isEmpty()) continue;
                    this.reportUnmatchedForward((SqlRoutineDefinition)child);
                }
            }

            private final void reportUnmatchedForward(SqlRoutineDefinition routine2) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{AddDefinitionFix.INSTANCE};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)routine2, (PsiElement)routine2, SqlBundle.message("inspection.message.unmatched.forward", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, localQuickFixArray));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection$AddDefinitionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isLeaf", "", "Lcom/intellij/psi/PsiElement;", "text", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.dialects.oracle.ex"})
    public static final class AddDefinitionFix
    implements LocalQuickFix {
        @NotNull
        public static final AddDefinitionFix INSTANCE = new AddDefinitionFix();

        private AddDefinitionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("quickfix.name.add.definition", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private final boolean isLeaf(PsiElement $this$isLeaf, String text2) {
            return $this$isLeaf instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)$this$isLeaf).getText(), (Object)text2);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)descriptor2.getStartElement();
            if (sqlRoutineDefinition == null) {
                return;
            }
            SqlRoutineDefinition header = sqlRoutineDefinition;
            if (header.getBody().isNotEmpty()) {
                return;
            }
            PsiElement psiElement2 = SqlImplUtil.sqlParent(header);
            if (psiElement2 == null) {
                return;
            }
            PsiElement parent = psiElement2;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect(header);
            SqlMembersHelper sqlMembersHelper = SqlMembersHelper.EP.forDbms(dialect.getDbms());
            if (sqlMembersHelper == null) {
                return;
            }
            SqlMembersHelper helper = sqlMembersHelper;
            PsiFile psiFile = header.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlFile");
            String delimiter = dialect.getDelimiterAt((SqlFile)psiFile, header.getTextRange().getStartOffset());
            JBIterable jBIterable = SqlImplUtil.siblings(header).skip(1).filter(arg_0 -> AddDefinitionFix.applyFix$lambda$1(AddDefinitionFix::applyFix$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable siblings2 = jBIterable;
            PsiElement psiElement3 = (PsiElement)siblings2.first();
            if (psiElement3 != null) {
                Intrinsics.checkNotNull((Object)delimiter);
                bl = this.isLeaf(psiElement3, delimiter);
            } else {
                bl = false;
            }
            if (!bl) {
                psiElement = parent.addAfter(SqlPsiElementFactory.createLeafFromText(project, dialect, delimiter), (PsiElement)header);
            } else {
                Object object = siblings2.takeWhile(arg_0 -> AddDefinitionFix.applyFix$lambda$3(arg_0 -> AddDefinitionFix.applyFix$lambda$2(delimiter, arg_0), arg_0)).last();
                Intrinsics.checkNotNull((Object)object);
                psiElement = (PsiElement)object;
            }
            PsiElement anchor = psiElement;
            SqlRoutineDefinition sqlRoutineDefinition2 = helper.generateImplementation(header);
            Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition2, (String)"generateImplementation(...)");
            SqlRoutineDefinition definition = sqlRoutineDefinition2;
            PsiElement definitionInPlace = anchor != null ? parent.addAfter((PsiElement)definition, anchor) : parent.add((PsiElement)definition);
            PsiElement psiElement4 = SqlPsiElementFactory.newLine(project);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"newLine(...)");
            PsiElement newLine = psiElement4;
            parent.addAfter(newLine, anchor);
            parent.addAfter(newLine, anchor);
            PsiDocumentManager $this$applyFix_u24lambda_u244 = PsiDocumentManager.getInstance((Project)project);
            boolean bl2 = false;
            Document document = $this$applyFix_u24lambda_u244.getDocument(header.getContainingFile());
            if (document != null) {
                $this$applyFix_u24lambda_u244.doPostponedOperationsAndUnblockDocument(document);
            }
            CodeStyleManager.getInstance((Project)project).reformat(definitionInPlace);
        }

        private static final boolean applyFix$lambda$0(PsiElement it) {
            return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment);
        }

        private static final boolean applyFix$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean applyFix$lambda$2(String $delimiter, PsiElement it) {
            Intrinsics.checkNotNull((Object)it);
            Intrinsics.checkNotNull((Object)$delimiter);
            return INSTANCE.isLeaf(it, $delimiter);
        }

        private static final boolean applyFix$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

