/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/dialects/mysql/inspections/MysqlSpaceAfterFunctionNameInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "RemoveWhitespace", "intellij.database.dialects.mysqlbase.ex"})
public final class MysqlSpaceAfterFunctionNameInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                super.visitSqlFunctionCallExpression(o);
                if (o == null) {
                    return;
                }
                if (!this.isAggregate(o)) {
                    return;
                }
                if (o.getChildren().length < 2) {
                    return;
                }
                PsiElement psiElement = o.getChildren()[1];
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"get(...)");
                PsiElement c2 = psiElement;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)c2), (Object)TokenType.WHITE_SPACE)) {
                    this.addDescriptor(this.$manager.createProblemDescriptor(c2, SqlBundle.message("inspection.message.whitespace.between.function.name.open.parenthesis", new Object[0]), (LocalQuickFix)new RemoveWhitespace(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }

            private final boolean isAggregate(SqlFunctionCallExpression o) {
                BuiltinFunction builtinFunction = o.getFunctionDefinition();
                if (builtinFunction == null) {
                    return false;
                }
                BuiltinFunction def = builtinFunction;
                return Intrinsics.areEqual((Object)"true", (Object)def.getDialectAttribute("aggregate"));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/dialects/mysql/inspections/MysqlSpaceAfterFunctionNameInspection$RemoveWhitespace;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "removeWhitespace", "w", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.mysqlbase.ex"})
    public static final class RemoveWhitespace
    implements LocalQuickFix,
    DumbAware {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.remove.whitespace", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement w = descriptor2.getPsiElement();
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)w), (Object)TokenType.WHITE_SPACE)) {
                Intrinsics.checkNotNull((Object)w);
                this.removeWhitespace(w);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void removeWhitespace(PsiElement w) {
            CodeEditUtil.allowToMarkNodesForPostponedFormatting((boolean)false);
            try {
                w.delete();
            }
            finally {
                CodeEditUtil.allowToMarkNodesForPostponedFormatting((boolean)true);
            }
        }
    }
}

