/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlParsingInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            MysqlParsingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MysqlParsingInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            MysqlParsingInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            @Override
            public void visitSqlFile(SqlFile o) {
                Version min = (Version)SqlImplUtil.getDbVersions(o).sort(Version::compareTo).first();
                if (min != null && min.isOrGreater(8, 0)) {
                    return;
                }
                super.visitSqlFile(o);
            }

            @Override
            public void visitSqlExpression(SqlExpression o) {
                super.visitSqlExpression(o);
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return;
                }
                PsiElement parent = o.getParent();
                if (this.isUnionParenExpression(parent)) {
                    return;
                }
                if (parent instanceof SqlJoinExpression || parent instanceof SqlAsExpression) {
                    this.markErrorsFirstJ(o);
                } else {
                    this.markErrorsFirstQ(o);
                }
            }

            private boolean isUnionParenExpression(PsiElement o) {
                return o instanceof SqlUnionExpression || o instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)o).getExpressionList().size() == 1 && !1.isExprParens(o);
            }

            private static boolean isExprParens(PsiElement o) {
                return PsiUtilCore.getElementType((PsiElement)o) == SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION || o.getParent() instanceof SqlBinaryExpression && !(o.getParent() instanceof SqlUnionExpression) && !(o.getParent() instanceof SqlJoinExpression);
            }

            private void markErrorsFirstJ(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return;
                }
                if (o instanceof SqlUnionExpression) {
                    List<SqlExpression> operands2 = ((SqlUnionExpression)o).getOperands();
                    if (!operands2.isEmpty()) {
                        this.markErrorsFirstJ(operands2.get(0));
                        for (int i2 = 1; i2 < operands2.size(); ++i2) {
                            this.markErrors(operands2.get(i2));
                        }
                    }
                } else if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    this.markErrorsFirstJ((SqlExpression)list.get(0));
                }
            }

            private boolean markErrorsFirstQ(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return false;
                }
                if (o instanceof SqlUnionExpression) {
                    List<SqlExpression> operands2 = ((SqlUnionExpression)o).getOperands();
                    for (SqlExpression operand : operands2) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                } else if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }

            private boolean markErrors(SqlExpression o) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o)) {
                    return false;
                }
                if (o instanceof SqlUnionExpression) {
                    SqlUnionExpression union = (SqlUnionExpression)o;
                    PsiElement wrongUnion = union.getOpSignElement();
                    for (SqlExpression operand : union.getOperands()) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                    if (wrongUnion != null) {
                        this.addDescriptor(manager.createProblemDescriptor(wrongUnion, DatabaseBundle.message("inspection.message.supported.syntax", new Object[0]), true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[0]));
                        return true;
                    }
                }
                if (o instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlParsingInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

