/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql._MysqlLexer;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.containers.ImmutableUserMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlLexer
extends SqlLexer {
    private boolean myStatementStart;
    private String myDelimiter;
    private boolean myInSpecialComment;

    public MysqlLexer() {
        super(MysqlDialect.INSTANCE, (FlexLexer)new _MysqlLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            MysqlLexer.$$$reportNull$$$0(0);
        }
        this.myStatementStart = true;
        this.myInSpecialComment = false;
        this.myDelimiter = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        int delimiterIndex;
        if (baseLexer == null) {
            MysqlLexer.$$$reportNull$$$0(1);
        }
        if (this.lookAheadRangeOperator(baseLexer)) {
            return;
        }
        IElementType tokenType = baseLexer.getTokenType();
        if (this.myStatementStart && MysqlOptionalKeywords.MYSQL_DELIMITER.toString().equalsIgnoreCase(baseLexer.getTokenText())) {
            this.advanceAs(baseLexer, MysqlOptionalKeywords.MYSQL_DELIMITER);
            if (baseLexer.getTokenType() != SqlTokens.SQL_WHITE_SPACE) {
                this.advanceAs(baseLexer, SqlTokens.BAD_CHARACTER);
                this.myStatementStart = true;
            } else {
                this.advanceAs(baseLexer, SqlTokens.SQL_WHITE_SPACE);
                this.myStatementStart = this.lookAheadForDelimiter(baseLexer, null);
            }
        } else if (this.myDelimiter != null && (delimiterIndex = baseLexer.getBufferSequence().subSequence(baseLexer.getTokenStart(), Math.min(baseLexer.getBufferEnd(), baseLexer.getTokenEnd() + this.myDelimiter.length() - 1)).toString().indexOf(this.myDelimiter)) > -1) {
            int tokenStart = baseLexer.getTokenStart();
            int bufferEnd = baseLexer.getBufferEnd();
            if (delimiterIndex > 0) {
                baseLexer.start(baseLexer.getBufferSequence(), tokenStart, tokenStart + delimiterIndex, baseLexer.getState());
                while (baseLexer.getTokenType() != null) {
                    this.advanceAs(baseLexer, this.getSqlTokenType(baseLexer));
                }
            }
            int delimiterEnd = tokenStart + delimiterIndex + this.myDelimiter.length();
            this.addToken(delimiterEnd, SqlTokens.MYSQL_DELIMITER_TOKEN);
            baseLexer.start(baseLexer.getBufferSequence(), delimiterEnd, bufferEnd, 0);
            this.myStatementStart = true;
        } else if (tokenType == SqlTokens.SQL_SEMICOLON) {
            this.myStatementStart = true;
            this.advanceAs(baseLexer, SqlTokens.SQL_SEMICOLON);
        } else if (tokenType == SqlTokens.SQL_BLOCK_COMMENT) {
            CharSequence tokenSequence = baseLexer.getBufferSequence().subSequence(baseLexer.getTokenStart(), Math.min(baseLexer.getBufferEnd(), baseLexer.getTokenEnd()));
            if (StringUtil.startsWith((CharSequence)tokenSequence, (CharSequence)"/*!")) {
                char c2;
                int start2;
                this.myInSpecialComment = true;
                int len = tokenSequence.length();
                for (start2 = 3; start2 < len && '0' <= (c2 = tokenSequence.charAt(start2)) && c2 <= '9'; ++start2) {
                }
                this.addToken(start2 += baseLexer.getTokenStart(), SqlTokens.MYSQL_PRAGMA_BEGIN);
                baseLexer.start(baseLexer.getBufferSequence(), start2, baseLexer.getBufferEnd(), baseLexer.getState());
            } else {
                this.myInSpecialComment = false;
                super.lookAhead(baseLexer);
            }
        } else if (this.myInSpecialComment && tokenType == SqlTokens.SQL_ASTERISK && baseLexer.getTokenEnd() < baseLexer.getBufferEnd() && baseLexer.getBufferSequence().charAt(baseLexer.getTokenEnd()) == '/') {
            this.myInSpecialComment = false;
            this.addToken(baseLexer.getTokenEnd() + 1, SqlTokens.MYSQL_PRAGMA_END);
            baseLexer.start(baseLexer.getBufferSequence(), baseLexer.getTokenEnd() + 1, baseLexer.getBufferEnd(), baseLexer.getState());
        } else {
            if (this.myStatementStart && !SqlTokens.WS_OR_COMMENTS.contains(tokenType)) {
                this.myStatementStart = false;
            }
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadForDelimiter(Lexer baseLexer, @Nullable String delimiter) {
        String text2;
        int tokenStart = baseLexer.getTokenStart();
        int currentTokenEnd = 0;
        IElementType type = baseLexer.getTokenType();
        while (type != SqlTokens.WHITE_SPACE && type != null) {
            currentTokenEnd = baseLexer.getTokenEnd();
            baseLexer.advance();
            type = baseLexer.getTokenType();
        }
        String string = text2 = currentTokenEnd > tokenStart ? baseLexer.getBufferSequence().subSequence(tokenStart, currentTokenEnd).toString() : "";
        if (delimiter == null) {
            if (text2.equals(";")) {
                this.addToken(currentTokenEnd, SqlTokens.SQL_SEMICOLON);
                this.myDelimiter = null;
                return true;
            }
            if (!text2.isEmpty()) {
                this.myDelimiter = text2;
                this.addToken(currentTokenEnd, SqlTokens.MYSQL_DELIMITER_TOKEN);
                return true;
            }
        } else if (delimiter.equals(text2)) {
            this.addToken(currentTokenEnd, SqlTokens.MYSQL_DELIMITER_TOKEN);
            return true;
        }
        return false;
    }

    @NotNull
    public LookAheadLexer.LookAheadLexerPosition getCurrentPosition() {
        return new MyPosition(this, ImmutableUserMap.EMPTY);
    }

    protected void restore(@NotNull LookAheadLexer.LookAheadLexerPosition position) {
        if (position == null) {
            MysqlLexer.$$$reportNull$$$0(2);
        }
        super.restore(position);
        if (position instanceof MyPosition) {
            this.myDelimiter = ((MyPosition)position).myDelimiter;
            this.myStatementStart = ((MyPosition)position).myStatementStart;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "restore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPosition
    extends LookAheadLexer.LookAheadLexerPosition {
        final String myDelimiter;
        final boolean myStatementStart;

        MyPosition(@NotNull MysqlLexer lookAheadLexer, @NotNull ImmutableUserMap map2) {
            if (lookAheadLexer == null) {
                MyPosition.$$$reportNull$$$0(0);
            }
            if (map2 == null) {
                MyPosition.$$$reportNull$$$0(1);
            }
            super((LookAheadLexer)lookAheadLexer, map2);
            this.myDelimiter = lookAheadLexer.myDelimiter;
            this.myStatementStart = lookAheadLexer.myStatementStart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lookAheadLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "map";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/mysql/MysqlLexer$MyPosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

