/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsql;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.hsql.HsqlDdlParsing;
import com.intellij.sql.dialects.hsql.HsqlDialect;
import com.intellij.sql.dialects.hsql.HsqlDmlParsing;
import com.intellij.sql.dialects.hsql.HsqlExpressionParsing;
import com.intellij.sql.dialects.hsql.HsqlGeneratedParser;
import java.util.Set;

public class HsqlParser
extends SqlParser {
    public HsqlParser() {
        super(HsqlDialect.INSTANCE);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return HsqlGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return HsqlGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return HsqlDmlParsing.top_query_expression(builder, level);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return HsqlGeneratedParser.parse_root_(root, builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = HsqlExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return HsqlDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, HsqlExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, BuiltinFunction definition, boolean plain, boolean ignoreParens, Set<BuiltinFunction.Location> locations) {
        if ("ARRAY".equals(functionName)) {
            if (SqlParserUtil.nextTokenIs(builder, SQL_LEFT_BRACKET)) {
                return false;
            }
            if (SqlParserUtil.consumeToken(builder, SQL_LEFT_PAREN)) {
                this.parseQueryExpression(builder, level);
                SqlParserUtil.consumeToken(builder, SQL_RIGHT_PAREN);
            }
            return true;
        }
        return super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain, ignoreParens, locations);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, HsqlExpressionParsing::parenthesized_values_expr, HsqlDmlParsing::top_query_expression_simple, HsqlParser::parseTopQueryExpressionTail, HsqlExpressionParsing::row_element_list, (b, l) -> HsqlExpressionParsing.root_expr_0(b, l, -1) && HsqlExpressionParsing.row_element_list_separator(b, l) && HsqlExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, HsqlDmlParsing::parenthesized_aliased_join_expression, HsqlDmlParsing::top_query_expression, HsqlParser::parseTopQueryExpressionTail, (b, l) -> HsqlDmlParsing.join_expression(b, l, -1), (b, l) -> HsqlDmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return HsqlGeneratedParser.table_opt_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        HsqlDmlParsing.query_expression_0(builder, level, -1);
        return HsqlDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

