/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hive;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.hive.HiveDialectBase;
import com.intellij.sql.dialects.hive.HiveTokens;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HiveDialect
extends HiveDialectBase {
    public static final HiveDialect INSTANCE = new HiveDialect();

    private HiveDialect() {
        super("HiveQL");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(HiveTokens.class);
        if (tokensHelper == null) {
            HiveDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            HiveDialect.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HIVE;
        if (dbms == null) {
            HiveDialect.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @Override
    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = HiveDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                HiveDialect.$$$reportNull$$$0(3);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, true);
        if (treePattern == null) {
            HiveDialect.$$$reportNull$$$0(4);
        }
        return treePattern;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            HiveDialect.$$$reportNull$$$0(5);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlMergeStatement.class}) != null;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        ObjectKind kind;
        if (place == null) {
            HiveDialect.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            HiveDialect.$$$reportNull$$$0(7);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor2)) {
            return false;
        }
        if (processor2.isExpected(ObjectKind.COLUMN) && DbImplUtilCore.isDataTable(kind = SqlImplUtil.getQualifierKind(place))) {
            DasTypeSystemBase typeSystem = this.getTypeSystem();
            if (!HiveDialect.processReservedEntitiesWithTypeSimple(LazyData.INPUT_FILE_NAME, typeSystem.getStringType(), name2, place, resolve2, processor2, true, null)) {
                return false;
            }
            if (!HiveDialect.processReservedEntitiesWithTypeSimple(LazyData.BLOCK_OFFSET_INSIDE_FILE, typeSystem.getIntType(), name2, place, resolve2, processor2, true, null)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            HiveDialect.$$$reportNull$$$0(8);
        }
        if (type == ObjectKind.MACRO && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type != ObjectKind.TABLE) {
            return super.shallResolve(o, type);
        }
        PsiElement clause = o.getParent();
        if (clause.getNode().getElementType() == HiveTypes.HIVE_IN_TABLE_CLAUSE) {
            return false;
        }
        return super.shallResolve(o, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/hive/HiveDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/hive/HiveDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final ReservedEntity INPUT_FILE_NAME = new ReservedEntity(Dbms.HIVE, "INPUT__FILE__NAME", ObjectKind.COLUMN);
        static final ReservedEntity BLOCK_OFFSET_INSIDE_FILE = new ReservedEntity(Dbms.HIVE, "BLOCK__OFFSET__INSIDE__FILE", ObjectKind.COLUMN);
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));

        LazyData() {
        }
    }
}

