/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dialects.h2.types.H2TypeSystemKt;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.types.DasType;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.h2.H2DateTimeLanguageHelper;
import com.intellij.sql.dialects.h2.H2OptionalKeywords;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2Dialect
extends SqlLanguageDialectBase {
    public static final H2Dialect INSTANCE = new H2Dialect();

    private H2Dialect() {
        super("H2");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(H2Tokens.class);
        if (tokensHelper == null) {
            H2Dialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.H2;
        if (dbms == null) {
            H2Dialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "UUID", "UUID", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "JSON", "JSON", (SqlLanguageDialectEx)this);
    }

    @Override
    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            H2Dialect.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            H2Dialect.$$$reportNull$$$0(4);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve2, processor2)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return res2;
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull SqlReference ref2, @NotNull DasType qualifierType) {
        if (processor2 == null) {
            H2Dialect.$$$reportNull$$$0(5);
        }
        if (state == null) {
            H2Dialect.$$$reportNull$$$0(6);
        }
        if (ref2 == null) {
            H2Dialect.$$$reportNull$$$0(7);
        }
        if (qualifierType == null) {
            H2Dialect.$$$reportNull$$$0(8);
        }
        if (H2TypeSystemKt.isJson(qualifierType)) {
            DasInlineSymbol symbol = new DasInlineSymbol(ref2, false){

                @Override
                @NotNull
                public ObjectKind getKind() {
                    ObjectKind objectKind = ObjectKind.COLUMN;
                    if (objectKind == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return objectKind;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/h2/H2Dialect$1", "getKind"));
                }
            };
            return processor2.executeTarget(symbol, null, false, state);
        }
        return super.processQualifiedResolve(processor2, state, ref2, qualifierType);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName[] dbAndSc = H2Dialect.getDatabaseAndSchema(dataSource);
        DasNamespace namespace = H2Dialect.getDefaultNamespace(dataSource, dbAndSc[0]);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(dbAndSc[1], ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                H2Dialect.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbAndSc[0], TreePatternUtils.create(dbAndSc[1], ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            H2Dialect.$$$reportNull$$$0(10);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlUpdateStatement.class}) != null;
    }

    @Override
    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        H2DateTimeLanguageHelper h2DateTimeLanguageHelper = H2DateTimeLanguageHelper.INSTANCE;
        if (h2DateTimeLanguageHelper == null) {
            H2Dialect.$$$reportNull$$$0(11);
        }
        return h2DateTimeLanguageHelper;
    }

    @NotNull
    private static ObjectName[] getDatabaseAndSchema(@Nullable DbDataSource dataSource) {
        ObjectName[] dbAndSc = new ObjectName[2];
        JdbcUrlParser parsed = SqlDialectImplUtilCore.getParsed(SqlImportUtil.getConnectionConfig(dataSource));
        if (parsed != null) {
            dbAndSc[0] = ObjectName.plain(StringUtil.nullize((String)parsed.getParameter("database")));
            if (dbAndSc[0] == null) {
                String path = StringUtil.nullize((String)parsed.getParameter("file"));
                if (path == null) {
                    path = StringUtil.nullize((String)parsed.getParameter("path"));
                }
                if (path != null) {
                    dbAndSc[0] = ObjectName.plain(new File(path).getName());
                }
            }
            dbAndSc[1] = ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)parsed.findProperty("schema"), (Object)parsed.getParameter("schema")));
        }
        if (dbAndSc[1] == null) {
            dbAndSc[1] = ObjectName.plain("public");
        }
        if (dbAndSc == null) {
            H2Dialect.$$$reportNull$$$0(12);
        }
        return dbAndSc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseAndSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 10 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_MODULO, H2OptionalKeywords.H2_REGEXP});

        LazyData() {
        }
    }
}

