/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.greenplum;

import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.greenplum.GPlumElementFactory;
import com.intellij.sql.dialects.greenplum.GPlumTokens;
import com.intellij.sql.dialects.greenplum.GPlumTypes;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GPlumDialect
extends Pg83Dialect {
    public static final GPlumDialect INSTANCE = new GPlumDialect();

    private GPlumDialect() {
        super("Greenplum");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(GPlumTokens.class);
        if (tokensHelper == null) {
            GPlumDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.GREENPLUM;
        if (dbms == null) {
            GPlumDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            GPlumDialect.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            GPlumDialect.$$$reportNull$$$0(5);
        }
        return (res2 = GPlumElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            GPlumDialect.$$$reportNull$$$0(6);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class}) != null;
    }

    @Override
    public boolean requiresAsForAliasAt(@NotNull PsiElement element) {
        if (element == null) {
            GPlumDialect.$$$reportNull$$$0(7);
        }
        return false;
    }

    @Override
    protected boolean supportsRowTypeSyntax() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/greenplum/GPlumDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/greenplum/GPlumDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadTokens(INSTANCE, "exceptions.txt"));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final Set<IElementType> ourSupportedOperators = Set.of(new IElementType[]{SqlTokens.SQL_QUESTION_MARK, GPlumTypes.GPLUM_OP_ABS, SqlTokens.SQL_OP_NOT2, GPlumTypes.GPLUM_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, GPlumTypes.GPLUM_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2});

        LazyData() {
        }
    }
}

