/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlKeywordCompletionContributor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlCommonTypes;
import com.intellij.sql.dialects.base.SqlGeneratedParser;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlGeneratedParserUtil
extends GeneratedParserUtilBase {
    public static final GeneratedParserUtilBase.Parser PARSE_FUNCTION_CALL_TAIL = new GeneratedParserUtilBase.Parser(){

        public boolean parse(PsiBuilder builder, int level) {
            return SqlGeneratedParserUtil.getParser(builder).parseFunctionCallTail(builder, level);
        }
    };
    public static final GeneratedParserUtilBase.Hook<Void> COLLAPSE = (builder, marker, param) -> {
        if (marker == null) {
            return null;
        }
        PsiBuilder.Marker res2 = marker.precede();
        res2.collapse(marker.getTokenType());
        return res2;
    };
    public static final GeneratedParserUtilBase.Hook<Void> UNWRAP_IF_SINGLE = (builder, marker, param) -> {
        int end;
        if (marker == null) {
            return null;
        }
        PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
        int start2 = m.getStartIndex();
        if (start2 + 1 == (end = m.getEndIndex())) {
            marker.drop();
        } else {
            int cnt = 0;
            int pos = builder.rawTokenIndex();
            for (int i2 = end; i2 > start2 && cnt < 2; --i2) {
                IElementType type = builder.rawLookup(i2 - pos - 1);
                if (type == null || SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) continue;
                ++cnt;
            }
            if (cnt == 1) {
                marker.drop();
            }
        }
        return marker;
    };
    public static final GeneratedParserUtilBase.Hook<Void> UNWRAP_WITH_STMT = (builder, marker, param) -> {
        if (marker == null) {
            return null;
        }
        PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
        IElementType backupType = m.getTokenType();
        PsiBuilder.Marker backup = marker.precede();
        marker.drop();
        LighterASTNode stmt = builder.getLatestDoneMarker();
        if (stmt == null || stmt.getTokenType() == SqlCompositeElementTypes.SQL_WITH_CLAUSE) {
            backup.done(backupType);
            return backup;
        }
        IElementType result2 = stmt.getTokenType();
        ((PsiBuilder.Marker)stmt).drop();
        if (result2 == SqlCompositeElementTypes.SQL_SELECT_STATEMENT) {
            PsiBuilder.Marker pre = backup.precede();
            backup.done((IElementType)SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION);
            backup = pre;
        }
        backup.done(result2);
        return backup;
    };
    public static final GeneratedParserUtilBase.Hook<Void> ATTACH_LABEL_IF_NEEDED = (builder, marker, param) -> {
        IElementType subType;
        if (marker == null) {
            return null;
        }
        PsiBuilder.Marker precede = marker.precede();
        marker.drop();
        LighterASTNode subMarker = builder.getLatestDoneMarker();
        if (subMarker != null && (subType = subMarker.getTokenType()) != SqlTokens.ERROR_ELEMENT) {
            ((PsiBuilder.Marker)subMarker).drop();
            precede.done(subType);
            return precede;
        }
        precede.drop();
        return precede;
    };
    public static final GeneratedParserUtilBase.Hook<Void> UNWRAP_ASSIGNMENT = (builder, marker, param) -> {
        SqlGeneratedParserUtil.setOff(builder, 0, "OPTIONAL_SELECT");
        LighterASTNode query = builder.getLatestDoneMarker();
        if (query == null || query.getTokenType() != SqlCompositeElementTypes.SQL_QUERY_EXPRESSION) {
            return null;
        }
        int startOffset = query.getStartOffset();
        int endOffset = query.getEndOffset();
        PsiBuilder.Marker newQuery = ((PsiBuilder.Marker)query).precede();
        ((PsiBuilder.Marker)query).drop();
        LighterASTNode selectClause = builder.getLatestDoneMarker();
        if (selectClause == null || selectClause.getTokenType() != SqlCompositeElementTypes.SQL_SELECT_CLAUSE || selectClause.getStartOffset() != startOffset || selectClause.getEndOffset() != endOffset) {
            newQuery.done((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION);
            return newQuery;
        }
        PsiBuilder.Marker newSelectClause = ((PsiBuilder.Marker)selectClause).precede();
        ((PsiBuilder.Marker)selectClause).drop();
        LighterASTNode expression = builder.getLatestDoneMarker();
        if (expression == null || expression.getStartOffset() != startOffset || expression.getEndOffset() != endOffset) {
            newSelectClause.done((IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE);
            newQuery.done((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION);
            return newQuery;
        }
        newSelectClause.drop();
        newQuery.drop();
        return (PsiBuilder.Marker)expression;
    };
    private static final WhitespacesAndCommentsBinder BLOCK_LEFT_BINDER = WhitespacesBinders.leadingCommentsBinder((TokenSet)SqlTokens.COMMENT_TOKENS);
    private static final WhitespacesAndCommentsBinder BLOCK_RIGHT_BINDER = WhitespacesBinders.trailingCommentsBinder((TokenSet)SqlTokens.COMMENT_TOKENS);
    private static final Key<Integer> POS_MARK = Key.create((String)"POS_MARK");
    private static final Key<Object2LongMap<String>> MODES_KEY = Key.create((String)"MODES_KEY");
    public static final GeneratedParserUtilBase.Hook<String> CLEAR_OFF = (builder, marker, param) -> {
        SqlGeneratedParserUtil.clearOff(builder, 0, param);
        return marker;
    };
    public static final GeneratedParserUtilBase.Hook<String> CLEAR_ON = (builder, marker, param) -> {
        SqlGeneratedParserUtil.clearOn(builder, 0, param);
        return marker;
    };
    public static final GeneratedParserUtilBase.Hook<String> CLEAR_IF_ON = (builder, marker, param) -> {
        SqlGeneratedParserUtil.clearIfOn(builder, 0, param);
        return marker;
    };
    public static final GeneratedParserUtilBase.Hook<String> DROP_LAST_IN_SPLIT_REF = (builder, marker, param) -> {
        PsiBuilder.Marker lastMarker;
        if (builder.getTokenType() != SqlCommonTypes.SQL_PERIOD && SqlGeneratedParserUtil.isOn(builder, 0, "SPLIT_REF") && (lastMarker = (PsiBuilder.Marker)builder.getLatestDoneMarker()) != null) {
            lastMarker.drop();
        }
        return marker;
    };
    private static final Key<LighterASTNode> EXPOSED_REF_KEY = Key.create((String)"EXPOSED_REF_KEY");
    private static final TokenSet[] EXTENDS_SETS = (TokenSet[])ArrayUtil.prepend((Object)TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_TYPE_ELEMENT, SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT, SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT}), (Object[])SqlGeneratedParser.EXTENDS_SETS_);
    private static final Key<Boolean> ERROR_MODE = Key.create((String)"ERROR_MODE");

    public static boolean isErrorMode(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlGeneratedParserUtil.$$$reportNull$$$0(0);
        }
        return builder.getUserData(ERROR_MODE) == Boolean.TRUE;
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser2, TokenSet[] tokenSets) {
        SqlKeywordCompletionContributor.SqlCompletionState state;
        TokenSet[] combinedTokenSets = tokenSets == null ? EXTENDS_SETS : (TokenSet[])ArrayUtil.mergeArrays((Object[])tokenSets, (Object[])EXTENDS_SETS);
        GeneratedParserUtilBase.ErrorState errorState = new GeneratedParserUtilBase.ErrorState();
        GeneratedParserUtilBase.ErrorState.initState((GeneratedParserUtilBase.ErrorState)errorState, (PsiBuilder)builder, (IElementType)root, (TokenSet[])combinedTokenSets);
        PsiElement chameleon = SqlLazyElementTypeImpl.getContextElement(builder);
        if (chameleon != null && (state = (SqlKeywordCompletionContributor.SqlCompletionState)((Object)ObjectUtils.tryCast((Object)errorState.completionState, SqlKeywordCompletionContributor.SqlCompletionState.class))) != null) {
            errorState.completionState = state.atOffset(state.offset - chameleon.getTextRange().getStartOffset());
        }
        errorState.braces = SqlImplUtil.TokenSets.BRACE_PAIRS;
        errorState.altMode = true;
        errorState.tokenAdvancer = SqlGeneratedParserUtil::sqlAdvanceToken;
        return new SqlBuilder(builder, errorState, parser2);
    }

    protected static SqlParser getParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlGeneratedParserUtil.$$$reportNull$$$0(1);
        }
        return (SqlParser)((GeneratedParserUtilBase.Builder)builder).parser;
    }

    protected static boolean sqlAdvanceToken(PsiBuilder builder, int level) {
        if (!SqlGeneratedParserUtil.parseUserParameter(builder, true, true)) {
            if (builder.eof()) {
                return false;
            }
            builder.advanceLexer();
        }
        return true;
    }

    public static boolean consumeDelimited(PsiBuilder builder, SqlTokenType startQuote, SqlTokenType endQuote) {
        if (SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)startQuote)) {
            PsiBuilder.Marker m = builder.mark();
            builder.advanceLexer();
            while (!builder.eof() && !SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)endQuote)) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            m.collapse((IElementType)SqlTokens.SQL_IDENT_DELIMITED);
            return true;
        }
        return false;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes_) {
        TokenSet set = TokenSet.create((IElementType[])tokenTypes_);
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION) || set.contains((IElementType)SqlCompositeElementTypes.SQL_BINARY_EXPRESSION)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_EXPRESSION, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE, SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_STRING_LITERAL, SqlCompositeElementTypes.SQL_STRING_LITERAL_CONCATENATION, SqlCompositeElementTypes.SQL_SPECIAL_LITERAL})});
        }
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT})});
        }
        return set;
    }

    public static boolean remapStatementType(PsiBuilder builder, int level, IElementType statementType) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        GeneratedParserUtilBase.Frame frame = state.currentFrame;
        while (frame != null) {
            if (state.typeExtends(frame.elementType, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
                if (frame.elementType instanceof IStubElementType && frame.elementType != SqlCompositeElementTypes.SQL_ALTER_STATEMENT) {
                    return true;
                }
                frame.elementType = statementType;
                return true;
            }
            frame = frame.parentFrame;
        }
        return true;
    }

    public static boolean convertToUseStatement(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.remapStatementType(builder, level, (IElementType)SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT);
    }

    public static LighterASTNode getExposedFunctionRef(PsiBuilder builder) {
        LighterASTNode ref2 = (LighterASTNode)EXPOSED_REF_KEY.get((UserDataHolder)builder);
        if (ref2 == null) {
            ref2 = builder.getLatestDoneMarker();
        }
        return ref2;
    }

    public static boolean exposeFunctionRef(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        LighterASTNode marker;
        LighterASTNode prev2 = (LighterASTNode)EXPOSED_REF_KEY.get((UserDataHolder)builder);
        if (prev2 == (marker = builder.getLatestDoneMarker())) {
            return parser2.parse(builder, level);
        }
        EXPOSED_REF_KEY.set((UserDataHolder)builder, (Object)marker);
        boolean result2 = parser2.parse(builder, level);
        EXPOSED_REF_KEY.set((UserDataHolder)builder, (Object)prev2);
        return result2;
    }

    private static Object2LongMap<String> getParsingModes(PsiBuilder builder) {
        Object2LongMap flags = (Object2LongMap)builder.getUserData(MODES_KEY);
        if (flags == null) {
            flags = new Object2LongOpenHashMap();
            builder.putUserData(MODES_KEY, (Object)flags);
        }
        return flags;
    }

    public static boolean doNotCollapse(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        if (frame != null && (frame.modifiers & 8) != 0) {
            frame = frame.parentFrame;
        }
        if (frame != null) {
            frame.modifiers &= 0xFFFFFFFE;
        }
        return true;
    }

    public static boolean setOn(PsiBuilder builder, int level, String mode) {
        return SqlGeneratedParserUtil.setMode(builder, level, mode, true);
    }

    public static boolean setOff(PsiBuilder builder, int level, String mode) {
        return SqlGeneratedParserUtil.setMode(builder, level, mode, false);
    }

    public static boolean setMode(PsiBuilder builder, int level, String mode, boolean val) {
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        map2.put((Object)mode, map2.getLong((Object)mode) << 1 | (long)(val ? 1 : 0));
        return true;
    }

    public static boolean isOn(PsiBuilder builder, int level, String mode) {
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        return (map2.getLong((Object)mode) & 1L) != 0L;
    }

    public static boolean wasOn(PsiBuilder builder, int level, String mode) {
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        return map2.getLong((Object)mode) != 0L;
    }

    public static boolean isQualificationForbidden(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.isOn(builder, level, "FORBID_QUALIFICATION");
    }

    public static boolean forbidQualification(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        return SqlGeneratedParserUtil.withOn(builder, level, "FORBID_QUALIFICATION", parser2);
    }

    public static boolean clearOn(PsiBuilder builder, int level, String mode) {
        return SqlGeneratedParserUtil.clearMode(builder, level, mode, true);
    }

    public static boolean clearOff(PsiBuilder builder, int level, String mode) {
        return SqlGeneratedParserUtil.clearMode(builder, level, mode, false);
    }

    public static boolean clearMode(PsiBuilder builder, int level, String mode, boolean expected) {
        boolean cur;
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        long prev2 = map2.getLong((Object)mode);
        boolean bl = cur = (prev2 & 1L) == 1L;
        if (cur == expected) {
            map2.put((Object)mode, prev2 >> 1);
        } else {
            builder.error(DatabaseBundle.message("parsing.error.could.clear.inactive.mode.at.offset", mode, builder.getCurrentOffset()));
        }
        return true;
    }

    public static boolean clearIfOn(PsiBuilder builder, int level, String mode) {
        boolean result2;
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        boolean bl = result2 = (map2.getLong((Object)mode) & 1L) != 0L;
        if (result2) {
            map2.put((Object)mode, map2.getLong((Object)mode) >> 1);
        }
        return result2;
    }

    public static boolean withClearedAfter(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser2) {
        boolean result2 = parser2.parse(builder, level);
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        map2.put((Object)mode, 0L);
        return result2;
    }

    public static boolean notEmpty(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        GeneratedParserUtilBase.Frame frame = state.currentFrame;
        GeneratedParserUtilBase.Frame frame2 = frame = frame == null ? null : frame.parentFrame;
        if (frame == null) {
            return true;
        }
        return frame.position != builder.rawTokenIndex();
    }

    public static boolean withOn(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser2) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, true, parser2, parser2);
    }

    public static boolean withOff(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser2) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, false, parser2, parser2);
    }

    public static boolean withCleared(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, false, whenOn, whenOff);
    }

    private static boolean withImpl(PsiBuilder builder, int level, String mode, boolean onOff, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        boolean change;
        Object2LongMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        long prev2 = map2.getLong((Object)mode);
        boolean bl = change = (prev2 & 1L) == 0L == onOff;
        if (change) {
            map2.put((Object)mode, prev2 << 1 | (long)(onOff ? 1 : 0));
        }
        boolean result2 = (change ? whenOn : whenOff).parse(builder, level);
        if (change) {
            map2.put((Object)mode, prev2);
        }
        return result2;
    }

    public static boolean withProtectedLastVariantPos(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        int prev2 = state.currentFrame.lastVariantAt;
        boolean result2 = parser2.parse(builder, level);
        state.currentFrame.lastVariantAt = prev2;
        return result2;
    }

    public static boolean parseAndMarkError(PsiBuilder builder, int level, String contentName, GeneratedParserUtilBase.Parser parser2) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        SqlKeywordCompletionContributor.SqlCompletionState completionState = (SqlKeywordCompletionContributor.SqlCompletionState)((Object)ObjectUtils.tryCast((Object)state.completionState, SqlKeywordCompletionContributor.SqlCompletionState.class));
        boolean report = state.currentFrame.errorReportedAt < builder.rawTokenIndex();
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, null);
        if (completionState != null) {
            completionState.setErrorMode(true);
        }
        boolean parse = parser2.parse(builder, level);
        if (completionState != null) {
            completionState.setErrorMode(false);
        }
        state.clearVariants(state.currentFrame);
        if (parse && report) {
            m.precede().error(DatabaseBundle.message("parsing.error.unexpected", contentName));
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, null, (boolean)true, (boolean)false, null);
        return parse;
    }

    public static boolean otherBranchGuard(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        PsiBuilder.Marker mark2 = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)8);
        boolean result2 = !SqlGeneratedParserUtil.withProtectedLastVariantPos(builder, level, parser2);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)mark2, (boolean)result2, (boolean)false, null);
        return result2;
    }

    public static boolean commaParenSemicolonStrict(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_COMMA || tokenType == SqlTokens.SQL_RIGHT_PAREN || tokenType == SqlTokens.SQL_SEMICOLON;
    }

    public static boolean commaParenSemicolonFast(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_COMMA || tokenType == SqlTokens.SQL_RIGHT_PAREN || SqlGeneratedParserUtil.getParser(builder).getLanguage().getStatementSeparators().contains(tokenType);
    }

    public static boolean commaAngleSemicolonFast(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_COMMA || tokenType == SqlTokens.SQL_OP_GT || SqlGeneratedParserUtil.getParser(builder).getLanguage().getStatementSeparators().contains(tokenType);
    }

    public static boolean parenSemicolonFast(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_RIGHT_PAREN || SqlGeneratedParserUtil.getParser(builder).getLanguage().getStatementSeparators().contains(tokenType);
    }

    public static boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        return SqlGeneratedParserUtil.getParser(builder).statementRecover(builder, level, prefixParser);
    }

    public static boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).statementRecoverPrefixParser(builder, level);
    }

    public static boolean isCompletionHere(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.CompletionState completionState = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).completionState;
        String txt = builder.getTokenText();
        int offset = builder.getCurrentOffset();
        int tokLen = txt == null ? 0 : txt.length();
        return completionState != null && (offset + tokLen == completionState.offset || offset == completionState.offset);
    }

    public static boolean clearVariants(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        state.clearVariants(state.currentFrame == null ? null : state.currentFrame.parentFrame);
        return true;
    }

    public static boolean reservedKeywordHereCondition(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).isReservedKeywordHere(builder, builder.getTokenType());
    }

    public static boolean reservedKeywordCondition(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.getParser(builder).getLanguage().isReservedKeyword(tokenType);
    }

    public static boolean reservedKeywordConditionPL(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.getParser(builder).getLanguage().isReservedKeywordPL(tokenType);
    }

    public static boolean consumeTokenIgnoreCase(PsiBuilder builder, int level, String text2) {
        return SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (String)text2, (boolean)false);
    }

    public static boolean consumeAllTokensUpTo(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2, boolean canBeEmpty) {
        builder.eof();
        boolean res2 = SqlGeneratedParserUtil.parseAsTree(builder, level, SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, TOKEN_ADVANCER, parser2);
        return canBeEmpty || res2;
    }

    public static boolean parseBlockContent(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        return SqlGeneratedParserUtil.parseBlockContent(builder, level, parser2, parser2);
    }

    public static boolean consumeStringTokenSilently(PsiBuilder builder, int level) {
        if (builder.getTokenType() == SqlTokens.SQL_STRING_TOKEN) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeStringToken(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).consumeStringToken(builder, true);
    }

    public static boolean parseBlockContent(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser0, GeneratedParserUtilBase.Parser parser2) {
        boolean r;
        PsiBuilder.Marker m = builder.mark();
        boolean p2 = r = parser0.parse(builder, level + 1);
        boolean bl = r = r && SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser2, (GeneratedParserUtilBase.Parser)TRUE_CONDITION);
        if (r || p2) {
            m.done(SqlElementTypes.SQL_DUMMY_BLOCK);
            m.setCustomEdgeTokenBinders(BLOCK_LEFT_BINDER, BLOCK_RIGHT_BINDER);
        } else {
            m.rollbackTo();
        }
        return r || p2;
    }

    public static boolean parseAsTree(PsiBuilder builder, int level, IElementType element, boolean checkParens, GeneratedParserUtilBase.Parser advancer, GeneratedParserUtilBase.Parser condition) {
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)element, (boolean)checkParens, (GeneratedParserUtilBase.Parser)advancer, (GeneratedParserUtilBase.Parser)condition);
    }

    public static boolean parseAsTree(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser2, (GeneratedParserUtilBase.Parser)TRUE_CONDITION);
    }

    public static boolean parseTwoPartStatementList(PsiBuilder builder, int level, final GeneratedParserUtilBase.Parser stmt1, final GeneratedParserUtilBase.Parser stmt2, GeneratedParserUtilBase.Parser stmtPreCheck, final GeneratedParserUtilBase.Parser stmtRecover) {
        return SqlGeneratedParserUtil.parseStatementList(builder, level, new GeneratedParserUtilBase.Parser(){
            boolean two = false;

            public boolean parse(PsiBuilder b, int l) {
                boolean r;
                PsiBuilder.Marker m = GeneratedParserUtilBase.enter_section_((PsiBuilder)b, (int)l, (int)0);
                if (stmt2.parse(b, l)) {
                    this.two = true;
                    r = true;
                } else {
                    r = !this.two && stmt1.parse(b, l);
                }
                GeneratedParserUtilBase.exit_section_((PsiBuilder)b, (int)l, (PsiBuilder.Marker)m, (boolean)r, (boolean)true, (GeneratedParserUtilBase.Parser)stmtRecover);
                return true;
            }
        }, stmtPreCheck);
    }

    public static boolean allowNoSeparator(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.getParser(builder).statementSeparatorParsed(builder);
        return true;
    }

    public static boolean withoutSpace(PsiBuilder builder, int level) {
        builder.eof();
        IElementType prev2 = builder.rawLookup(-1);
        return prev2 != null && !SqlTokens.WS_TOKENS.contains(prev2);
    }

    public static boolean parseStatementList(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser stmt, GeneratedParserUtilBase.Parser stmtPreCheck) {
        return SqlGeneratedParserUtil.getParser(builder).parseStatementBlockBody(builder, false, stmt, stmtPreCheck);
    }

    public static boolean parseBlockBody(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser stmt, GeneratedParserUtilBase.Parser stmtPreCheck, GeneratedParserUtilBase.Parser sep, String name2) {
        return SqlGeneratedParserUtil.getParser(builder).parseGenericBlockBody(builder, stmt, stmtPreCheck, sep, true, name2);
    }

    public static boolean parseListAsTree(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2, GeneratedParserUtilBase.Parser separator) {
        boolean result2 = SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (boolean)parser2.parse(builder, level));
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser2, (GeneratedParserUtilBase.Parser)separator) || result2;
    }

    public static boolean parseScript(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        SqlGeneratedParserUtil.parseAsTree(builder, level, SqlElementTypes.SQL_DUMMY_BLOCK, true, parser2, TRUE_CONDITION);
        return true;
    }

    public static boolean parseReference(PsiBuilder builder, int level, SqlReferenceElementType type) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)(type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE ? "<operator>" : "<reference>"));
        return SqlGeneratedParserUtil.getParser(builder).parseReferenceExpressionOrVariable(builder, type);
    }

    public static boolean remapToPositionalRef(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser expressionParser2) {
        if (!expressionParser2.parse(builder, level)) {
            return false;
        }
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker != null && marker.getTokenType() == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) {
            PsiBuilder.Marker newMarker = ((PsiBuilder.Marker)marker).precede();
            ((PsiBuilder.Marker)marker).drop();
            newMarker.done((IElementType)SqlCompositeElementTypes.SQL_POSITIONAL_REFERENCE);
        }
        return true;
    }

    public static boolean checkReference(PsiBuilder builder, int level, SqlReferenceElementType type) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        return marker instanceof PsiBuilderImpl.ProductionMarker && marker.getTokenType() == type;
    }

    public static boolean parseIdentifierInner(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<identifier>");
        return SqlGeneratedParserUtil.getParser(builder).parseIdentifierInner(builder, true, true, false, null);
    }

    public static boolean parseIdentifier(PsiBuilder b, int l) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)b, (int)l, (int)0, null, (String)"<identifier>");
        boolean r = SqlGeneratedParserUtil.parseIdentifierInner(b, l + 1) && SqlGeneratedParserUtil.noDotAhead(b, l);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)b, (int)l, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    private static boolean parseMultiIdentifierInner(PsiBuilder b, int l) {
        SqlParser parser2 = SqlGeneratedParserUtil.getParser(b);
        if (!parser2.consumeIdentifier(b)) {
            return false;
        }
        do {
            if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)b, (IElementType)SqlCommonTypes.SQL_PERIOD)) continue;
            return true;
        } while (parser2.consumeIdentifier(b));
        return false;
    }

    public static boolean parseMultiIdentifier(PsiBuilder b, int l) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)b, (int)l, (int)0, (IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER, null);
        boolean r = SqlGeneratedParserUtil.parseMultiIdentifierInner(b, l + 1);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)b, (int)l, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    private static boolean noDotAhead(PsiBuilder b, int l) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)b, (int)l, (int)16);
        boolean r = !SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)b, (IElementType)SqlCommonTypes.SQL_PERIOD);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)b, (int)l, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    public static boolean consumeIdentifier(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<identifier>");
        return SqlGeneratedParserUtil.getParser(builder).consumeIdentifier(builder);
    }

    public static boolean consumeDelimitedIdentifier(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_IDENT_DELIMITED);
    }

    public static boolean parseReferenceOrFunction(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseReferenceOrFunction(builder, level, true);
    }

    public static boolean parseFunctionCallExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseJdbcFunctionCallExpression(builder, level);
    }

    public static boolean parseLValueExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseLValueExpression(builder, level);
    }

    public static boolean parseOdbcSequence(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseOdbcSequence(builder);
    }

    public static boolean parseStringLiteral(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseStringLiteral(builder, level);
    }

    public static boolean parseValueExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseValueExpression(builder, level, true);
    }

    public static boolean parseSplitIdentifierStart(PsiBuilder builder, int level) {
        boolean result2 = SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SqlGeneratedParserUtil.getParser(builder).getSplitIdentifierStart());
        if (result2) {
            SqlGeneratedParserUtil.setOn(builder, 0, "SPLIT_REF");
        }
        return result2;
    }

    public static boolean parseSplitIdentifierEnd(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.setOff(builder, 0, "SPLIT_REF");
        SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (boolean)SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SqlGeneratedParserUtil.getParser(builder).getSplitIdentifierEnd()));
        return true;
    }

    public static boolean parseQualificationItem(PsiBuilder builder, int level) {
        if (!SqlGeneratedParserUtil.getParser(builder).parseIdentifierOrAsteriskInner(builder, true, true, false, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE)) {
            return false;
        }
        return SqlGeneratedParserUtil.remapCurrentReference(builder, level);
    }

    public static boolean remapCurrentReference(PsiBuilder builder, int level) {
        IElementType type;
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        IElementType iElementType = type = state.currentFrame == null ? null : (IElementType)ObjectUtils.chooseNotNull((Object)state.currentFrame.elementType, (Object)((Object)SqlCompositeElementTypes.SQL_REFERENCE));
        if (type == SqlCompositeElementTypes.SQL_REFERENCE && !SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlCommonTypes.SQL_PERIOD)) {
            state.currentFrame.elementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
        }
        return true;
    }

    public static boolean identifierCondition(PsiBuilder builder, int level) {
        IElementType type = builder.getTokenType();
        SqlParser parser2 = SqlGeneratedParserUtil.getParser(builder);
        SqlLanguageDialectEx language = parser2.getLanguage();
        boolean skipFunction = parser2.isReservedKeywordHere(builder, type) && !language.getSupportedFunctions().contains(builder.getTokenText()) && builder.rawLookup(1) != SqlCommonTypes.SQL_PERIOD;
        return !skipFunction;
    }

    public static boolean parsePossiblySplitSimpleRefOrFunction(PsiBuilder builder, int level) {
        boolean isSplitRef;
        SqlParser parser2 = SqlGeneratedParserUtil.getParser(builder);
        IElementType type = builder.getTokenType();
        boolean allowSplit = parser2.allowIdentifierSplit(SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        boolean bl = isSplitRef = allowSplit && parser2.getSplitIdentifierStart() == type && builder.rawLookup(2) == SqlCommonTypes.SQL_PERIOD;
        if (!isSplitRef) {
            return SqlGeneratedParserUtil.parseSimpleRefOrFunction(builder, level, null);
        }
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = SqlGeneratedParserUtil.parseReference(builder, level, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        if (!result2) {
            marker.drop();
            return false;
        }
        marker.done((IElementType)SqlCompositeElementTypes.SQL_REFERENCE);
        SqlGeneratedParserUtil.parseArgumentListAfterReference(builder, level, null);
        return true;
    }

    public static boolean parseSimpleRefOrFunction(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser extra) {
        if (!SqlGeneratedParserUtil.identifierCondition(builder, level)) {
            return false;
        }
        PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE, null);
        boolean result2 = SqlGeneratedParserUtil.getParser(builder).parseIdentifierOrAsteriskInner(builder, true, true, false, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        result2 = result2 && (extra == null || extra.parse(builder, level));
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, (boolean)result2, (boolean)false, null);
        if (!result2) {
            return false;
        }
        SqlGeneratedParserUtil.parseArgumentListAfterReference(builder, level, marker);
        return true;
    }

    public static boolean parseArgumentListTail(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.exposeFunctionRef(builder, level, PARSE_FUNCTION_CALL_TAIL);
    }

    public static boolean parseString(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<string>");
        return SqlGeneratedParserUtil.getParser(builder).parseStringLiteralOrParameter(builder);
    }

    private static void parseArgumentListAfterReference(PsiBuilder builder, int level, PsiBuilder.Marker marker) {
        PsiBuilderImpl.ProductionMarker refMarker = Objects.requireNonNull((PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker());
        if (marker == null) {
            marker = (PsiBuilder.Marker)refMarker;
        }
        int offset = builder.getCurrentOffset();
        if (SqlGeneratedParserUtil.parseArgumentListTail(builder, level)) {
            marker.precede().done((IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL);
            if (offset != builder.getCurrentOffset() && refMarker.getTokenType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                refMarker.remapTokenType((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE);
            }
        } else if (!SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlCommonTypes.SQL_PERIOD)) {
            SqlReferenceElementType refType = SqlGeneratedParserUtil.isQualificationForbidden(builder, level) ? SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE : SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            refMarker.remapTokenType((IElementType)refType);
        }
    }

    public static boolean parseNumber(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<number>");
        return SqlGeneratedParserUtil.getParser(builder).parseNumberLiteralOrParameter(builder, false);
    }

    public static boolean parseFloat(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<number>");
        return SqlGeneratedParserUtil.getParser(builder).parseNumberLiteralOrParameter(builder, true);
    }

    public static boolean consumeNumericToken(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlTokens.SQL_INTEGER_TOKEN) || SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlTokens.SQL_FLOAT_TOKEN);
    }

    public static boolean parseAndRemapToCallable(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        boolean result2;
        PsiBuilderImpl.ProductionMarker refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType type = refMarker == null ? null : refMarker.getTokenType();
        int offset = builder.getCurrentOffset();
        boolean bl = result2 = SqlGeneratedParserUtil.getParser(builder).canBeCalled(type) && parser2.parse(builder, level);
        if (result2) {
            boolean empty;
            boolean bl2 = empty = offset == builder.getCurrentOffset();
            if (type instanceof SqlReferenceElementType && type != SqlCompositeElementTypes.SQL_METHOD_REFERENCE) {
                refMarker.remapTokenType((IElementType)(empty ? SqlCompositeElementTypes.SQL_REFERENCE : SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE));
            } else {
                result2 = !empty;
            }
        }
        return result2;
    }

    public static boolean parseAndRemapToGenericReference(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2) {
        IElementType type;
        boolean result2 = parser2.parse(builder, level);
        PsiBuilderImpl.ProductionMarker refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType iElementType = type = refMarker == null ? null : refMarker.getTokenType();
        if (type instanceof SqlReferenceElementType) {
            refMarker.remapTokenType((IElementType)SqlCompositeElementTypes.SQL_REFERENCE);
        }
        return result2;
    }

    public static SqlReferenceElementType shorten(SqlReferenceElementType ref2) {
        if (ref2 == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            return SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
        }
        return ref2;
    }

    public static boolean remapReference(PsiBuilder builder, int level, IElementType ref2, GeneratedParserUtilBase.Parser parser2) {
        PsiBuilderImpl.ProductionMarker refMarker;
        SqlReferenceElementType refType = (SqlReferenceElementType)((Object)ObjectUtils.tryCast((Object)ref2, SqlReferenceElementType.class));
        if (refType != null && refType.isQualified() && SqlGeneratedParserUtil.isQualificationForbidden(builder, level)) {
            ref2 = SqlGeneratedParserUtil.shorten(refType);
        }
        IElementType type = (refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class)) == null ? null : refMarker.getTokenType();
        boolean subscript = SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_LEFT_BRACKET);
        boolean result2 = parser2.parse(builder, level);
        if (result2 && type == SqlCompositeElementTypes.SQL_REFERENCE && subscript) {
            refMarker.remapTokenType(ref2);
        }
        return result2;
    }

    public static boolean remapAnyReference(PsiBuilder builder, int level, IElementType ref2) {
        LighterASTNode refMarker = builder.getLatestDoneMarker();
        if (refMarker == null || !(refMarker.getTokenType() instanceof SqlReferenceElementType)) {
            return true;
        }
        ((PsiBuilderImpl.ProductionMarker)refMarker).remapTokenType(ref2);
        return true;
    }

    public static boolean remapReference(PsiBuilder builder, int level, IElementType ref2) {
        return SqlGeneratedParserUtil.remapReference(builder, level, ref2, TRUE_CONDITION);
    }

    public static boolean statementSeparatorParsed(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).isStatementSeparatorParsed(builder);
    }

    public static boolean parseKnownFunctionArgumentList(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseKnownFunctionArgumentList(builder, level);
    }

    public static boolean parseKnownFunctionArgumentListInner(PsiBuilder builder, int level) {
        SqlExpressionList list = (SqlExpressionList)ObjectUtils.tryCast((Object)SqlLazyElementTypeImpl.getContextElement(builder), SqlExpressionList.class);
        SqlFunctionCallExpression call = list == null ? null : (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)list.getParent(), SqlFunctionCallExpression.class);
        SqlReferenceExpression fName = call == null ? null : call.getNameElement();
        return SqlGeneratedParserUtil.getParser(builder).parseKnownFunctionArgumentList(builder, 0, fName == null ? null : fName.getName(), DbSqlUtilCore.isQuoted(fName), true, fName != null && fName.getQualifierExpression() != null);
    }

    public static boolean parseFunctionArgument(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionArgument(builder, level, true, true);
    }

    public static boolean parseCustomReferenceExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParameterOrVariableReference(builder, true);
    }

    public static boolean consumeSystemVar(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeWellKnownTokens(builder, SqlGeneratedParserUtil.getParser(builder).getLanguage().getSystemVariables(), "<system variable>");
    }

    public static boolean consumeExceptionName(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeWellKnownTokens(builder, SqlGeneratedParserUtil.getParser(builder).getLanguage().getExceptionNames(), "<exception name>");
    }

    public static boolean consumeWellKnownTokens(PsiBuilder builder, Set<String> tokens, String tokenName) {
        if (SqlGeneratedParserUtil.isInCompletion(builder, 0)) {
            for (String t : tokens) {
                SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)t);
            }
        } else {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)tokenName);
        }
        IElementType type = builder.getTokenType();
        if ((type == SqlTokens.SQL_IDENT || type instanceof SqlTokenType) && tokens.contains(builder.getTokenText())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean isInCompletion(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).completionState != null;
    }

    public static boolean argumentListStart(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionParametersStart(builder, level, null);
    }

    public static boolean argumentListEnd(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionParametersEnd(builder, level, null);
    }

    public static boolean argumentListRecover(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).argumentListRecover(builder, level);
    }

    public static boolean isText(PsiBuilder builder, int level, String txt) {
        builder.eof();
        return Strings.startsWith((CharSequence)builder.getOriginalText(), (int)builder.getCurrentOffset(), (CharSequence)txt);
    }

    public static boolean remapCurrentFrame(PsiBuilder builder, int level, IElementType type) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        if (frame != null) {
            frame.elementType = type;
        }
        return true;
    }

    public static void remapCurrentFrameStrict(PsiBuilder builder, IElementType type) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        if (frame != null) {
            frame.elementType = type;
        }
    }

    public static boolean expandPrevFrame(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker != null) {
            while (frame != null && frame.elementType == null) {
                frame = frame.parentFrame;
            }
            if (frame != null) {
                frame.elementType = marker.getTokenType();
                ((PsiBuilder.Marker)marker).drop();
            }
        }
        return true;
    }

    public static boolean isQueryParsed(PsiBuilder builder, int level) {
        IElementType type = SqlGeneratedParserUtil.getLastMarkerType(builder);
        return type == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION || type == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION || type == SqlCompositeElementTypes.SQL_UNION_EXPRESSION || type == SqlCompositeElementTypes.SQL_INTERSECT_EXPRESSION || type == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION;
    }

    public static boolean dispatchQandXconflict(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser recParser, GeneratedParserUtilBase.Parser qParser, GeneratedParserUtilBase.Parser qTailParser, GeneratedParserUtilBase.Parser xParser, GeneratedParserUtilBase.Parser xTailParser) {
        if (builder.getTokenType() == SqlTokens.SQL_LEFT_PAREN) {
            return SqlGeneratedParserUtil.dispatchQandXconflictP(builder, level, recParser, qTailParser, xTailParser);
        }
        if (qParser.parse(builder, level)) {
            return SqlGeneratedParserUtil.remapCurrentFrame(builder, level, SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION);
        }
        return xParser.parse(builder, level);
    }

    public static boolean dispatchQandXconflictP(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser recParser, GeneratedParserUtilBase.Parser qTailParser, GeneratedParserUtilBase.Parser xTailParser) {
        boolean tryX;
        if (!recParser.parse(builder, level)) {
            return false;
        }
        IElementType type = SqlGeneratedParserUtil.getLastMarkerType(builder);
        boolean isQuery = type == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION;
        int offset = builder.getCurrentOffset();
        boolean bl = tryX = !isQuery;
        if (!tryX) {
            qTailParser.parse(builder, level);
            boolean bl2 = tryX = offset == builder.getCurrentOffset();
        }
        if (tryX) {
            xTailParser.parse(builder, level);
            isQuery &= offset == builder.getCurrentOffset();
        }
        if (isQuery) {
            SqlGeneratedParserUtil.remapCurrentFrame(builder, level, SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION);
        }
        return true;
    }

    @Nullable
    private static IElementType getLastMarkerType(PsiBuilder builder) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        return marker == null ? null : marker.getTokenType();
    }

    public static boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParenContentQorJ(builder, level);
    }

    public static boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParenContentQorV(builder, level);
    }

    public static boolean consumeText(PsiBuilder b, int l) {
        b.eof();
        int c2 = 0;
        while (!SqlGeneratedParserUtil.isTextBreaker(b.rawLookup(0))) {
            b.advanceLexer();
            ++c2;
        }
        if (c2 == 0) {
            b.advanceLexer();
        }
        return true;
    }

    private static boolean isTextBreaker(IElementType item) {
        return item == null || SqlTokens.WS_OR_COMMENTS.contains(item) || SqlTokens.STRING_TOKENS.contains(item) || SqlTokens.STATEMENT_SEPARATORS.contains(item) || item == SqlTokens.SQL_IDENT_DELIMITED;
    }

    public static boolean delimitedWithText(PsiBuilder builder, int level, String text2, boolean sensitive) {
        if (!SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_IDENT_DELIMITED)) {
            return false;
        }
        SqlLanguageDialectEx language = SqlGeneratedParserUtil.getParser(builder).getLanguage();
        String identifier = builder.getTokenText();
        String unquoted = identifier == null ? null : NamingServices.getNamingService(language.getDbms()).unquoteIdentifier(identifier);
        return Comparing.strEqual((String)text2, (String)unquoted, (boolean)sensitive);
    }

    public static boolean suggestInjection(PsiBuilder builder, int level, SqlSuggestedInjection language) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker == null || marker.getTokenType() != SqlCompositeElementTypes.SQL_STRING_LITERAL && marker.getTokenType() != SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT) {
            return true;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        mark2.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        mark2.done(SqlInfoElementType.getElementType(language));
        return true;
    }

    public static boolean injectSql(PsiBuilder builder, int level) {
        SqlSuggestedInjection injection = SqlGeneratedParserUtil.getParser(builder).getCurrentSqlInjection();
        return injection == null || SqlGeneratedParserUtil.suggestInjection(builder, level, injection);
    }

    public static boolean injectJson(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.JSON);
    }

    public static boolean injectXml(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.XML);
    }

    public static boolean injectXPath(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.XPath2);
    }

    public static boolean injectRegExp(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.RegExp);
    }

    public static boolean nonEmpty(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        GeneratedParserUtilBase.Frame frame2 = frame = frame == null ? null : frame.parentFrame;
        if (frame == null) {
            return true;
        }
        return frame.offset < builder.getCurrentOffset();
    }

    public static boolean hasFrameUpward(PsiBuilder builder, int level, int nframes, IElementType type) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        for (int i2 = 0; i2 < nframes && frame != null && frame.elementType != type; ++i2) {
            frame = frame.parentFrame;
        }
        return frame != null && frame.elementType == type;
    }

    public static boolean consumeNonWsUpTo(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser2, boolean canBeEmpty) {
        builder.eof();
        POS_MARK.set((UserDataHolder)builder, (Object)builder.getCurrentOffset());
        boolean res2 = SqlGeneratedParserUtil.parseAsTree(builder, level, SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, TOKEN_ADVANCER, (b, l) -> !SqlGeneratedParserUtil.isWhiteSpace(b) && parser2.parse(b, l));
        return canBeEmpty || res2;
    }

    public static boolean isWhiteSpace(PsiBuilder builder_) {
        if (builder_.eof()) {
            return true;
        }
        if (Comparing.equal((Object)builder_.getCurrentOffset(), (Object)((Integer)POS_MARK.get((UserDataHolder)builder_)))) {
            return false;
        }
        char prevTokenStart = builder_.getOriginalText().charAt(builder_.rawTokenTypeStart(-1));
        return Character.isWhitespace(prevTokenStart);
    }

    public static boolean parseUserParameter(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        IElementType next;
        boolean suffix;
        IElementType cur;
        IElementType iElementType = cur = checkStart ? builder.rawLookup(0) : builder.getTokenType();
        if (!SqlGeneratedParserUtil.isExternalParameterFirst(cur)) {
            return false;
        }
        boolean prefix = cur == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || cur == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE;
        boolean bl = suffix = cur == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE && builder.rawLookup(2) == SqlTokens.SQL_CUSTOM_PARAM_RQUOTE;
        IElementType iElementType2 = checkEnd ? builder.rawLookup(prefix && suffix ? 3 : (prefix ? 2 : 1)) : (next = null);
        if (next == SqlTokens.SQL_IDENT || next instanceof SqlKeywordTokenType) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        if (prefix) {
            builder.advanceLexer();
        }
        builder.advanceLexer();
        if (suffix) {
            builder.advanceLexer();
        }
        marker.done((IElementType)SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE);
        return true;
    }

    public static boolean isExternalParameterFirst(IElementType cur) {
        return cur == SqlTokens.SQL_EXTERNAL_PARAM || cur == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || cur == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE;
    }

    public static boolean parseLazyBody(PsiBuilder builder, int level, IElementType lazyBlockType) {
        if (builder.getTokenType() != SqlTokens.SQL_CUSTOM_LQUOTE) {
            return false;
        }
        if (builder.rawLookup(1) != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN && !SqlGeneratedParserUtil.isExternalParameterFirst(builder.rawLookup(1))) {
            return false;
        }
        builder.advanceLexer();
        PsiBuilder.Marker mark2 = builder.mark();
        while (true) {
            IElementType type;
            if ((type = builder.getTokenType()) == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN || type == SqlTokens.SQL_EXTERNAL_PARAM) {
                builder.advanceLexer();
                continue;
            }
            if (type == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX) {
                builder.advanceLexer();
                builder.advanceLexer();
                continue;
            }
            if (type != SqlTokens.SQL_CUSTOM_PARAM_LQUOTE || builder.rawLookup(2) != SqlTokens.SQL_CUSTOM_PARAM_RQUOTE) break;
            builder.advanceLexer();
            builder.advanceLexer();
            builder.advanceLexer();
        }
        mark2.collapse(lazyBlockType);
        SqlParserUtil.consumeToken(builder, false, SqlTokens.SQL_CUSTOM_RQUOTE);
        return true;
    }

    public static boolean consumeInsideParens(PsiBuilder builder, int level) {
        int balance = 0;
        while (!builder.eof() && builder.getTokenType() != SqlCommonTokens.SQL_SEMICOLON) {
            if (builder.getTokenType() == SqlTokens.SQL_LEFT_PAREN) {
                ++balance;
            } else if (builder.getTokenType() == SqlTokens.SQL_RIGHT_PAREN) {
                if (balance == 0) break;
                --balance;
            }
            builder.advanceLexer();
        }
        return true;
    }

    public static boolean isUnder(PsiBuilder builder, int level, IElementType elementType) {
        PsiElement element = SqlLazyElementTypeImpl.getContextElement(builder);
        PsiElement p2 = element == null ? null : element.getParent();
        return PsiUtilCore.getElementType((PsiElement)p2) == elementType;
    }

    public static boolean isAfter(PsiBuilder builder, int level, IElementType elementType) {
        PsiElement element = SqlLazyElementTypeImpl.getContextElement(builder);
        while (element != null) {
            if (PsiUtilCore.getElementType((PsiElement)(element = element.getPrevSibling())) != elementType) continue;
            return true;
        }
        return false;
    }

    public static boolean isAfterToken(@NotNull PsiBuilder builder, int ignoredLevel, @NotNull IElementType tokenType) {
        if (builder == null) {
            SqlGeneratedParserUtil.$$$reportNull$$$0(2);
        }
        if (tokenType == null) {
            SqlGeneratedParserUtil.$$$reportNull$$$0(3);
        }
        int i2 = -1;
        IElementType curr;
        while ((curr = builder.rawLookup(i2)) != null) {
            if (!SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)curr)) {
                return curr == tokenType;
            }
            --i2;
        }
        return false;
    }

    public static boolean parsePathAsSchemaList(PsiBuilder builder, int level) {
        SqlParser parser2 = SqlGeneratedParserUtil.getParser(builder);
        if (SqlParserUtil.consumeToken(builder, true, SqlTokens.SQL_DEFAULT)) {
            return true;
        }
        SqlGeneratedParser.simple_list(builder, level, (b, l) -> {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"schema reference");
            PsiBuilder.Marker m = b.mark();
            if (b.getTokenType() != SqlTokens.SQL_DEFAULT && parser2.consumeIdentifier(b, true, true)) {
                m.done((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER);
                m.precede().done((IElementType)SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE);
                return true;
            }
            m.drop();
            return false;
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/base/SqlGeneratedParserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isErrorMode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SqlBuilder
    extends GeneratedParserUtilBase.Builder {
        public SqlBuilder(PsiBuilder builder, GeneratedParserUtilBase.ErrorState state_, PsiParser parser_) {
            super(builder, state_, parser_);
        }

        @Nullable
        public IElementType getTokenType() {
            IElementType type = this.myDelegate.getTokenType();
            if (type == SqlTokens.BAD_CHARACTER) {
                PsiBuilder.Marker mark2 = this.mark();
                do {
                    this.advanceLexer();
                } while ((type = this.myDelegate.getTokenType()) == SqlTokens.BAD_CHARACTER);
                mark2.error(DatabaseBundle.message("parsing.error.bad.characters", new Object[0]));
            }
            return type;
        }
    }
}

