/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlImportUtil {
    public static final ObjectKind DATA_SOURCE = ObjectKind.ROOT;
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted("SOME NON MATCHING NAME");
    public static final ObjectName[] NON_MATCHING_NAMES = (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{NON_MATCHING_NAME});

    private SqlImportUtil() {
    }

    @NotNull
    public static ObjectName getDataSourceName(@NotNull DasDataSource dataSource) {
        String id;
        if (dataSource == null) {
            SqlImportUtil.$$$reportNull$$$0(0);
        }
        ObjectName objectName = ObjectName.quoted(StringUtil.isEmpty((String)(id = dataSource.getUniqueId())) ? dataSource.getName() : id);
        if (objectName == null) {
            SqlImportUtil.$$$reportNull$$$0(1);
        }
        return objectName;
    }

    public static ObjectName @Nullable [] getRealDsNames(@Nullable DbDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        if (!(dataSource.getDelegate() instanceof SqlDataSource)) {
            return (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{SqlImportUtil.getDataSourceName(dataSource)});
        }
        SmartList res2 = new SmartList();
        do {
            res2.add(SqlImportUtil.getDataSourceName(dataSource));
        } while ((dataSource = dataSource.getDelegate() instanceof SqlDataSource ? ((SqlDataSource)dataSource.getDelegate()).getParentDataSource() : null) != null);
        return ObjectName.toArray((Iterable<ObjectName>)res2);
    }

    @NotNull
    public static TreePatternNode.Group createDataSources(ObjectName @Nullable [] names, TreePatternNode.Group ... groups) {
        TreePatternNode.Group group = TreePatternUtils.create(names == null ? NON_MATCHING_NAMES : names, DATA_SOURCE, groups);
        if (group == null) {
            SqlImportUtil.$$$reportNull$$$0(2);
        }
        return group;
    }

    @NotNull
    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile sqlFile) {
        SqlDataSource sqlDs;
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(3);
        }
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(4);
        }
        if ((sqlDs = SqlImportUtil.getSqlDataSource(ds, sqlFile)) != null) {
            TreePattern pattern = SqlImportUtil.createSqlDataSourceScopeIfAny(ds, sqlDs, language, sqlFile);
            TreePattern treePattern = pattern != null ? pattern : language.getDefaultImports(ds);
            if (treePattern == null) {
                SqlImportUtil.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = language.getDefaultImports(ds);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static SqlDataSource getSqlDataSource(@Nullable DbDataSource ds, @NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(7);
        }
        SqlDataSource sqlDs = ds == null ? null : (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
        return sqlDs != null && sqlDs.containsFile(sqlFile.getVirtualFile()) ? sqlDs : null;
    }

    @Nullable
    public static TreePattern createScopePatternIfAny(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile sqlFile) {
        SqlDataSource sqlDs;
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(8);
        }
        if (sqlFile == null) {
            SqlImportUtil.$$$reportNull$$$0(9);
        }
        return (sqlDs = SqlImportUtil.getSqlDataSource(ds, sqlFile)) != null ? SqlImportUtil.createSqlDataSourceScopeIfAny(ds, sqlDs, language, sqlFile) : null;
    }

    @Nullable
    private static TreePattern createSqlDataSourceScopeIfAny(@NotNull DbDataSource dbDs, @NotNull SqlDataSource ds, @NotNull SqlLanguageDialectEx language, @NotNull SqlFile file) {
        VirtualFile vfile;
        ObjectPath scope2;
        if (dbDs == null) {
            SqlImportUtil.$$$reportNull$$$0(10);
        }
        if (ds == null) {
            SqlImportUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            SqlImportUtil.$$$reportNull$$$0(12);
        }
        if (file == null) {
            SqlImportUtil.$$$reportNull$$$0(13);
        }
        ObjectPath objectPath = scope2 = (vfile = file.getVirtualFile()) == null ? null : ds.getScope(vfile, language.getDbms());
        if (scope2 != null) {
            ObjectName[] names = SqlImportUtil.getRealDsNames(dbDs);
            TreePattern res2 = SqlDialectImplUtilCore.createObjectPattern(names, language.getDbms(), scope2, (TreePatternNode.Group[])null);
            return language.applyImplicitImports(names, res2);
        }
        return null;
    }

    @NotNull
    public static TreePattern processResolveScopePattern(@NotNull TreePattern resolvePattern, @Nullable TreePattern defaultPattern) {
        if (resolvePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(14);
        }
        TreePatternUtils.GroupedGroupFactory factory = new TreePatternUtils.GroupedGroupFactory(){
            private boolean myAccept = false;
            private TreePatternNode.Group myUnAccept = null;

            @Override
            protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                TreePatternNode.Group first2;
                if (this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                TreePatternNode.Group group = first2 = it.hasNext() ? it.next() : null;
                if (first2 != null) {
                    return;
                }
                TreePatternNode.Group group2 = second = it.hasNext() ? it.next() : null;
                if (second == null) {
                    return;
                }
                this.myAccept = true;
                this.myUnAccept = second;
            }

            @Override
            protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                if (!this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                TreePatternNode.Group group = second = it.hasNext() ? it.next() : null;
                if (second != this.myUnAccept) {
                    return;
                }
                this.myAccept = false;
                this.myUnAccept = null;
            }

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterator<TreePatternNode.Group> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                Iterator<TreePatternNode> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            @Override
            public boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups) {
                return !1.containsNotNull(groups);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        List<TreePattern> patterns2 = defaultPattern != null ? Arrays.asList(resolvePattern, defaultPattern) : Collections.singletonList(resolvePattern);
        TreePattern treePattern = factory.merge(patterns2);
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(15);
        }
        return treePattern;
    }

    private static TreePatternNode.Group @Nullable [] removeNulls(TreePatternNode.Group @Nullable [] groups) {
        if (groups == null) {
            return null;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return TreePatternNode.NO_GROUPS;
        }
        if (nonNulls == groups.length) {
            return groups;
        }
        TreePatternNode.Group[] newGroups = new TreePatternNode.Group[nonNulls];
        int i2 = 0;
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            newGroups[i2++] = group;
        }
        return newGroups;
    }

    @NotNull
    public static TreePattern createPattern(@NotNull List<?> names, @NotNull List<ObjectKind> kinds, TreePatternNode.Group @Nullable [] tail) {
        if (names == null) {
            SqlImportUtil.$$$reportNull$$$0(16);
        }
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(17);
        }
        TreePatternNode.Group[] children2 = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)SqlImportUtil.removeNulls(tail), (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            TreePatternNode n;
            Object name2 = names.get(i2);
            ObjectKind kind = kinds.get(i2);
            if (name2 == null) {
                n = new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, children2);
            } else {
                TreePatternNode.PositiveNaming naming;
                if (name2 instanceof ObjectName) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName)name2);
                } else if (name2 instanceof ObjectName[]) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName[])name2);
                } else if (name2 instanceof Iterable) {
                    naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)name2));
                } else {
                    throw new AssertionError((Object)("Unexpected: " + name2.getClass().getSimpleName()));
                }
                n = new TreePatternNode(naming, children2);
            }
            children2 = new TreePatternNode.Group[]{new TreePatternNode.Group(kind, new TreePatternNode[]{n})};
        }
        return new TreePattern(children2);
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull Dbms dbms) {
        BasicMetaModel<?> metaModel;
        JBIterable<List<ObjectKind>> roots2;
        ArrayList<ObjectKind> root;
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(18);
        }
        if (dbms == null) {
            SqlImportUtil.$$$reportNull$$$0(19);
        }
        if ((root = (ArrayList<ObjectKind>)(roots2 = (metaModel = DbImplUtilCore.getMetaModel(dbms)).getPathsToRoot(kind)).first()) == null || root.isEmpty() || !roots2.skip(1).isEmpty()) {
            Logger.getInstance(metaModel.getClass()).warn("To many roots from " + String.valueOf(kind));
            return null;
        }
        root = new ArrayList<ObjectKind>(root);
        assert (!root.isEmpty());
        assert (root.get(root.size() - 1) == ObjectKind.ROOT);
        root.set(root.size() - 1, DATA_SOURCE);
        return root;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref2, @NotNull ObjectKind refKind, @NotNull Dbms dbms) {
        if (ref2 == null) {
            SqlImportUtil.$$$reportNull$$$0(20);
        }
        if (refKind == null) {
            SqlImportUtil.$$$reportNull$$$0(21);
        }
        if (dbms == null) {
            SqlImportUtil.$$$reportNull$$$0(22);
        }
        assert (refKind != SqlDbElementType.ANY);
        List<ObjectKind> kinds = SqlImportUtil.getSingleRootPath(refKind, dbms);
        if (kinds == null) {
            return null;
        }
        SmartList names = new SmartList();
        names.add(new ObjectName(ref2.getName(), !ref2.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref2.getQualifierExpression(), SqlReferenceExpression.class);
        while (names.size() < kinds.size()) {
            names.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtil.createPattern(names, kinds, null);
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    @Nullable
    public static TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name2, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            SqlImportUtil.$$$reportNull$$$0(23);
        }
        return name2 == null ? null : TreePatternUtils.create(name2, kind, groups);
    }

    @Nullable
    public static TreePattern getResolveScopePattern(@NotNull SqlFile file) {
        if (file == null) {
            SqlImportUtil.$$$reportNull$$$0(24);
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(file.getProject());
        VirtualFile vFile = SqlImplUtil.getTopLevelFile(file);
        return (TreePattern)mapping.getMapping(vFile);
    }

    @NotNull
    public static TreePatternNode.Group createPositiveDatabase(@NotNull ObjectName name2, TreePatternNode.Group ... groups) {
        if (name2 == null) {
            SqlImportUtil.$$$reportNull$$$0(25);
        }
        TreePatternNode.Group group = TreePatternUtils.create(name2, ObjectKind.DATABASE, groups);
        if (group == null) {
            SqlImportUtil.$$$reportNull$$$0(26);
        }
        return group;
    }

    @Nullable
    public static TreePatternNode.Group createPositiveDatabase(boolean useNonMatching, @Nullable ObjectName name2, TreePatternNode.Group ... groups) {
        return name2 == null && !useNonMatching ? null : TreePatternUtils.create((ObjectName)ObjectUtils.chooseNotNull((Object)name2, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups);
    }

    @NotNull
    public static TreePattern createAddPattern(ObjectName @Nullable [] ds, ObjectKind @NotNull [] kinds) {
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(27);
        }
        TreePatternNode.Group[] children2 = TreePatternNode.NO_GROUPS;
        for (int i2 = kinds.length - 1; i2 >= 0; --i2) {
            children2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{kinds[i2] == DATA_SOURCE && ds != null ? SqlImportUtil.createDataSources(ds, children2) : TreePatternUtils.create((ObjectName)null, kinds[i2], children2)});
        }
        return new TreePattern(children2);
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull TreePattern pattern, ObjectName @Nullable [] dsNames, @NotNull List<ObjectName> names, boolean atBegin, ObjectKind ... path) {
        if (pattern == null) {
            SqlImportUtil.$$$reportNull$$$0(28);
        }
        if (names == null) {
            SqlImportUtil.$$$reportNull$$$0(29);
        }
        if (path == null) {
            SqlImportUtil.$$$reportNull$$$0(30);
        }
        ObjectKind targetKind = path[path.length - 1];
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern, SqlImportUtil.createAddPattern(dsNames, path), (g, parent, parentKind) -> {
            if (parent instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g.kind != targetKind) {
                return g;
            }
            SmartList notFound = new SmartList();
            for (ObjectName name2 : names) {
                if (g.matchedChildren(name2, null, null)) continue;
                notFound.add(name2);
            }
            if (notFound.isEmpty()) {
                return g;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable<ObjectName>)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g);
            builder.children.add(atBegin ? 0 : builder.children.size(), new TreePatternNode(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g.kind);
        });
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(31);
        }
        return treePattern;
    }

    @Nullable
    public static TreePatternNode.Group getRootGroup(boolean schemaRoot, MultiMap<String, String> databases, boolean integrateStar) {
        return schemaRoot ? SqlImportUtil.getSchemaGroup(databases) : SqlImportUtil.getDbGroup(databases, integrateStar);
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroup(MultiMap<String, String> databases) {
        if (!databases.containsKey((Object)"*")) {
            return null;
        }
        return SqlImportUtil.getSchemaGroups(databases.get((Object)"*"));
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroups(Collection<String> schemas) {
        if (schemas.contains("*")) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
        }
        if (schemas.isEmpty()) {
            return null;
        }
        return TreePatternUtils.create(JBIterable.from(schemas).transform(n -> ObjectName.quoted(n)).toList(), ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
    }

    @Nullable
    public static TreePatternNode.Group getDbGroup(MultiMap<String, String> databases, boolean integrateStar) {
        if (databases.containsKey((Object)"*") && !integrateStar) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.DATABASE, TreePatternNode.NO_GROUPS);
        }
        if (databases.size() == 0) {
            return null;
        }
        ArrayList<TreePatternNode.Group> gr = new ArrayList<TreePatternNode.Group>();
        for (Map.Entry entry : databases.entrySet()) {
            TreePatternNode.Group sgr = SqlImportUtil.getSchemaGroups((Collection)entry.getValue());
            gr.add(TreePatternUtils.create(((String)entry.getKey()).equals("*") ? null : ObjectName.quoted((String)entry.getKey()), ObjectKind.DATABASE, SqlImportUtil.optAr(sgr)));
        }
        return TreePatternUtils.UNION_PROCESSOR.mergeGroups(ObjectKind.DATABASE, gr);
    }

    public static TreePatternNode.Group[] optAr(TreePatternNode.Group x) {
        return x == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{x});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 15, 26, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvePattern";
                break;
            }
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refKind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultScopePattern";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processResolveScopePattern";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositiveDatabase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectsByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 26: 
            case 31: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultScopePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDataSource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createScopePatternIfAny";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDataSourceScopeIfAny";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processResolveScopePattern";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSingleRootPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNodeIfNotNull";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopePattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveDatabase";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createAddPattern";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addObjectsByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 15, 26, 31 -> new IllegalStateException(string);
        };
    }
}

