/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlDialectImplUtil
extends SqlDialectImplUtilCore {
    private SqlDialectImplUtil() {
    }

    @NotNull
    private static HelpResource getHelpResource(Class<?> dialectClass) throws IOException {
        @NonNls String resourceName = null;
        InputStream zipIs = null;
        for (Class<?> c2 = dialectClass; c2 != null; c2 = c2.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c2) + "-help.zip";
            ClassLoader loader = c2.getClassLoader();
            zipIs = loader == null ? null : loader.getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", StringUtil.notNullize(resourceName)));
        }
        return new HelpResource(resourceName, zipIs);
    }

    @NotNull
    public static String getDialectHelpResource(Class<?> dialectClass, @NonNls String name2) throws IOException {
        String text2;
        HelpResource help = SqlDialectImplUtil.getHelpResource(dialectClass);
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(help.inputStream(), name2);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlBundle.message("help.file.0.not.found", name2) + "\n" + e.getMessage(), e);
        }
        if (text2 == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", help.name() + "!/" + name2));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = SqlDialectImplUtil.loadDoc(zip);
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    @TestOnly
    @Nullable
    public static Set<BuiltinDoc> loadAllBuiltinDocs(Class<?> dialectClass) throws IOException {
        HelpResource help = SqlDialectImplUtil.getHelpResource(dialectClass);
        return SqlDialectImplUtil.loadAllBuiltinDocs(help.inputStream());
    }

    @Nullable
    private static Set<BuiltinDoc> loadAllBuiltinDocs(@Nullable InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        HashSet<BuiltinDoc> res2 = new HashSet<BuiltinDoc>();
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                String dirPrefix = "functions/";
                String entryName = zipEntry.getName();
                if (entryName.startsWith(dirPrefix)) {
                    String name2;
                    int overload;
                    String fileName = entryName.substring(dirPrefix.length());
                    int overloadSepIdx = fileName.lastIndexOf(45);
                    if (overloadSepIdx > 0) {
                        overload = Integer.parseInt(fileName.substring(overloadSepIdx + 1, fileName.length() - ".html".length()));
                        name2 = fileName.substring(0, overloadSepIdx);
                    } else {
                        overload = 0;
                        name2 = fileName.substring(0, fileName.length() - ".html".length());
                    }
                    String doc = SqlDialectImplUtil.loadDoc(zip);
                    res2.add(new BuiltinDoc(name2, doc, overload));
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return res2;
    }

    @NotNull
    private static String loadDoc(@NotNull ZipInputStream zip) throws IOException {
        if (zip == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        return new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
    }

    @NotNull
    public static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = StringUtil.toLowerCase((String)className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()));
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void dumpHelpResource(@NotNull String filePath, @NotNull Set<BuiltinDoc> docs) throws IOException {
        if (filePath == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(4);
        }
        if (docs == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(5);
        }
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (BuiltinDoc doc : docs) {
                String zipPath = "functions/" + doc.filename() + ".html";
                ZipEntry zipEntry = new ZipEntry(zipPath);
                zos.putNextEntry(zipEntry);
                byte[] contentBytes = doc.doc().getBytes(StandardCharsets.UTF_8);
                zos.write(contentBytes);
                zos.closeEntry();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDoc";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpHelpResource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private record HelpResource(String name, InputStream inputStream) {
    }

    public record BuiltinDoc(@NotNull String name, @NotNull String doc, int overload) {
        @NotNull
        private final String name;
        @NotNull
        private final String doc;

        public BuiltinDoc(@NotNull String name2, @NotNull String doc, int overload) {
            if (name2 == null) {
                BuiltinDoc.$$$reportNull$$$0(0);
            }
            if (doc == null) {
                BuiltinDoc.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        String filename() {
            Object object = this.overload == 0 ? this.name : this.name + "-" + this.overload;
            if (object == null) {
                BuiltinDoc.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                BuiltinDoc.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String doc() {
            String string = this.doc;
            if (string == null) {
                BuiltinDoc.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil$BuiltinDoc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil$BuiltinDoc";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filename";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

