/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasPredefinedSymbol;
import com.intellij.database.types.DasType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PairConsumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltinFunction
extends DasPredefinedSymbol
implements DasObject {
    public static final Parameter COMMA = new SyntaxParameter(-1, ",");
    public static final String PARAM_TYPE_PREFIX = "P";
    protected final Map<String, String> myDialectAttrs;
    protected final String myName;
    protected final Prototype[] myPrototypes;
    protected final String myAliasedFunction;
    protected final Location myLocation;
    protected final Dbms myDbms;

    public BuiltinFunction(String name2, String aliasedFunction, Map<String, String> dialectAttrs, List<Prototype> prototypes, @NotNull Dbms dbms) {
        if (dbms == null) {
            BuiltinFunction.$$$reportNull$$$0(0);
        }
        this.myDialectAttrs = dialectAttrs;
        this.myName = name2;
        this.myAliasedFunction = aliasedFunction;
        this.myDbms = dbms;
        this.myLocation = BuiltinFunction.parseLocation(this.getDialectAttribute("location"));
        this.myPrototypes = new Prototype[prototypes.size()];
        for (int i2 = 0; i2 < prototypes.size(); ++i2) {
            Prototype p2 = prototypes.get(i2);
            this.myPrototypes[i2] = new Prototype(this, p2.getReturnType(), p2.getPrototypeId(), p2.getHeadBlock(), p2.getParams(), p2.getAttributes());
        }
    }

    @NotNull
    protected static Location parseLocation(@Nullable String location) {
        Location location2;
        if (location == null) {
            Location location3 = Location.NORMAL;
            if (location3 == null) {
                BuiltinFunction.$$$reportNull$$$0(1);
            }
            return location3;
        }
        try {
            location2 = Location.valueOf(StringUtil.toUpperCase((String)location));
        }
        catch (IllegalArgumentException e) {
            Location location4 = Location.NORMAL;
            if (location4 == null) {
                BuiltinFunction.$$$reportNull$$$0(3);
            }
            return location4;
        }
        if (location2 == null) {
            BuiltinFunction.$$$reportNull$$$0(2);
        }
        return location2;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            BuiltinFunction.$$$reportNull$$$0(4);
        }
        return objectKind;
    }

    @Override
    public boolean isQuoted() {
        return true;
    }

    public String getPostfixType() {
        return this.getDialectAttribute("postfix");
    }

    @Override
    @Nullable
    public String getComment() {
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            BuiltinFunction.$$$reportNull$$$0(5);
        }
        return string;
    }

    public Prototype[] getPrototypes() {
        return this.myPrototypes;
    }

    public String getAliasedFunction() {
        return this.myAliasedFunction;
    }

    public Map<String, String> getDialectAttrs() {
        return this.myDialectAttrs;
    }

    @Nullable
    public String getDialectAttribute(String name2) {
        return this.myDialectAttrs.get(name2);
    }

    @Nullable
    public String getSelf() {
        return this.getDialectAttribute("self");
    }

    public boolean isOptionalSelf() {
        return "true".equals(this.getDialectAttribute("opt_self"));
    }

    public boolean isInstanceMethod() {
        return Boolean.parseBoolean(this.getDialectAttribute("instance"));
    }

    @NotNull
    private Location getLocation() {
        Location location = this.myLocation;
        if (location == null) {
            BuiltinFunction.$$$reportNull$$$0(6);
        }
        return location;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            BuiltinFunction.$$$reportNull$$$0(7);
        }
        return dbms;
    }

    public boolean isOverloadable() {
        return !"no".equals(this.getDialectAttribute("overloadable"));
    }

    public String toString() {
        return this.myName + Prototype.toString(this.myDialectAttrs) + String.valueOf(Arrays.asList(this.myPrototypes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/BuiltinFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/BuiltinFunction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static enum Location {
        NORMAL(true),
        TABLE_FUNCTION(true),
        TABLE_ENGINE_SPEC(false),
        DATABASE_ENGINE_SPEC(false),
        CODEC_SPEC(false),
        INDEX_TYPE_SPEC(false),
        DICTIONARY_SOURCE_SPEC(false),
        DICTIONARY_LAYOUT_SPEC(false),
        ROW_NAVIGATION_OPERATION(true);

        private final boolean myHasReturnType;

        private Location(boolean special) {
            this.myHasReturnType = special;
        }

        public boolean hasReturnType() {
            return this.myHasReturnType;
        }
    }

    public static class Prototype
    extends ParameterBlock {
        public static final Prototype[] EMPTY_ARRAY = new Prototype[0];
        private final Type myReturnType;
        private final BuiltinFunction myFunction;
        private final Parameter myHeadBlock;
        private final Map<String, String> myAttributes;

        public Prototype(@Nullable BuiltinFunction function, @NotNull Type returnType, int id, @Nullable Parameter headBlock, Parameter[] parameters, @NotNull Map<String, String> attributes) {
            if (returnType == null) {
                Prototype.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                Prototype.$$$reportNull$$$0(1);
            }
            super(id, ParameterBlockType.SEQUENCE, parameters, null);
            this.myFunction = function;
            this.myReturnType = returnType;
            this.myHeadBlock = headBlock;
            this.myAttributes = attributes.isEmpty() ? Collections.emptyMap() : attributes;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            throw new UnsupportedOperationException();
        }

        public Type getReturnType() {
            return this.myReturnType;
        }

        @Override
        public String toString() {
            return Prototype.toString(this.myAttributes) + (String)(this.myHeadBlock == null ? "" : String.valueOf(this.myHeadBlock) + " ") + super.toString() + (String)(this.myFunction == null || this.getLocation().hasReturnType() ? ":" + String.valueOf(this.myReturnType) : "");
        }

        @NotNull
        public BuiltinFunction getFunction() {
            assert (this.myFunction != null);
            BuiltinFunction builtinFunction = this.myFunction;
            if (builtinFunction == null) {
                Prototype.$$$reportNull$$$0(2);
            }
            return builtinFunction;
        }

        public Location getLocation() {
            String locationName = this.myAttributes.get("location");
            return locationName != null ? BuiltinFunction.parseLocation(locationName) : this.myFunction.getLocation();
        }

        @Nullable
        public Parameter getHeadBlock() {
            return this.myHeadBlock;
        }

        @NotNull
        public Map<String, String> getAttributes() {
            Map<String, String> map2 = this.myAttributes;
            if (map2 == null) {
                Prototype.$$$reportNull$$$0(3);
            }
            return map2;
        }

        private static String toString(Map<String, String> attrs) {
            if (attrs.isEmpty()) {
                return "";
            }
            return "{" + StringUtil.join(attrs.entrySet(), entry -> (String)entry.getKey() + ":" + (String)entry.getValue(), (String)",") + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/BuiltinFunction$Prototype";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/BuiltinFunction$Prototype";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class Type {
        private final String myName;
        private final DasType myDasType;

        public Type(@NonNls String name2) {
            this(name2, null);
        }

        public Type(@NonNls String name2, DasType dasType) {
            this.myName = name2;
            this.myDasType = dasType;
        }

        public String getName() {
            return this.myName;
        }

        public String getDisplayName() {
            return this.myDasType == null ? this.myName : this.myDasType.getSpecification();
        }

        @Nullable
        public DasType getDasType() {
            return this.myDasType;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static abstract class Parameter {
        public static final Parameter[] EMPTY_ARRAY = new Parameter[0];
        private final int myPrototypeId;

        public Parameter(int prototypeId) {
            this.myPrototypeId = prototypeId;
        }

        public int getPrototypeId() {
            return this.myPrototypeId;
        }

        public boolean isMany() {
            return false;
        }

        public abstract Parameter copyWithPrototype(int var1);
    }

    public static class SyntaxParameter
    extends Parameter {
        private final String myText;

        public SyntaxParameter(int prototypeId, @NotNull String text2) {
            if (text2 == null) {
                SyntaxParameter.$$$reportNull$$$0(0);
            }
            super(prototypeId);
            this.myText = text2;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                SyntaxParameter.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return !"()[]{}.\\:|".contains(this.myText) ? this.myText : "'" + this.myText + "'";
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SyntaxParameter(prototypeId, this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/BuiltinFunction$SyntaxParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/BuiltinFunction$SyntaxParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParamType
    extends Type {
        private final int myIndex;

        public ParamType(int index) {
            super(BuiltinFunction.PARAM_TYPE_PREFIX + index);
            this.myIndex = index;
        }

        @Override
        public String getDisplayName() {
            return "TypeOf(" + this.myIndex + ")";
        }

        public int getIndex() {
            return this.myIndex;
        }
    }

    public static class ReferenceParameter
    extends SimpleParameter {
        private final String myRefTypeName;

        public ReferenceParameter(int prototypeId, String name2, Type type, @NotNull String refTypeName, boolean many) {
            if (refTypeName == null) {
                ReferenceParameter.$$$reportNull$$$0(0);
            }
            super(prototypeId, name2, type, many);
            this.myRefTypeName = refTypeName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new ReferenceParameter(prototypeId, this.getName(), this.getType(), this.myRefTypeName, this.isMany());
        }

        public String getRefTypeName() {
            return this.myRefTypeName;
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.myRefTypeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refTypeName", "com/intellij/sql/dialects/BuiltinFunction$ReferenceParameter", "<init>"));
        }
    }

    public static class SimpleParameter
    extends Parameter {
        private final String myName;
        private final Type myType;
        private final boolean myMany;

        public SimpleParameter(int prototypeId, String name2, @NotNull Type type, boolean many) {
            if (type == null) {
                SimpleParameter.$$$reportNull$$$0(0);
            }
            super(prototypeId);
            this.myName = name2 == null ? StringUtil.toLowerCase((String)type.getName()) : name2;
            this.myType = type;
            this.myMany = many;
        }

        @Override
        public boolean isMany() {
            return this.myMany;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new SimpleParameter(prototypeId, this.myName, this.myType, this.myMany);
        }

        public String getName() {
            return this.myName;
        }

        public Type getType() {
            return this.myType;
        }

        public String toString() {
            return this.myName + ":" + this.myType.getDisplayName() + (this.myMany ? "*" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/BuiltinFunction$SimpleParameter", "<init>"));
        }
    }

    public static class ParameterBlock
    extends Parameter {
        private final Parameter[] myParams;
        private final ParameterBlockQuantifier myQuantifier;
        private final ParameterBlockType myBlockType;

        public ParameterBlock(int prototypeId, ParameterBlockType blockType, Parameter[] params, ParameterBlockQuantifier quantifier) {
            super(prototypeId);
            this.myBlockType = blockType;
            this.myParams = params;
            this.myQuantifier = quantifier;
        }

        public ParameterBlock(int prototypeId, ParameterBlockType blockType, Parameter[] params, boolean many) {
            this(prototypeId, blockType, params, many ? ParameterBlockQuantifier.ELLIPSIS : null);
        }

        public ParameterBlockType getBlockType() {
            return this.myBlockType;
        }

        public Parameter[] getParams() {
            return this.myParams;
        }

        @Override
        public boolean isMany() {
            return this.myQuantifier != null;
        }

        public boolean isAtLeastOne() {
            return this.myQuantifier == null || this.myQuantifier.atLeastOne;
        }

        public boolean isGreedy() {
            return this.myQuantifier == null || this.myQuantifier.greedy;
        }

        public boolean isFollowedByComma() {
            return this.myQuantifier == null || this.myQuantifier.commaSeparated;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            Parameter[] params = this.myParams.length == 0 ? EMPTY_ARRAY : new Parameter[this.myParams.length];
            for (int i2 = 0; i2 < this.myParams.length; ++i2) {
                params[i2] = this.myParams[i2].copyWithPrototype(prototypeId);
            }
            return new ParameterBlock(prototypeId, this.myBlockType, params, this.myQuantifier);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, null);
            return sb.toString();
        }

        public void toString(StringBuilder sb, @Nullable PairConsumer<Parameter, Boolean> markerProcessor) {
            boolean first2 = true;
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)true);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("{");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("[");
                    break;
                }
                case SEQUENCE: {
                    sb.append("(");
                }
            }
            for (Parameter param : this.myParams) {
                if (first2) {
                    first2 = false;
                } else if (this.myBlockType == ParameterBlockType.CHOICE) {
                    sb.append(" | ");
                } else if (param != COMMA) {
                    sb.append(' ');
                }
                if (param instanceof ParameterBlock) {
                    ((ParameterBlock)param).toString(sb, markerProcessor);
                    continue;
                }
                if (markerProcessor != null) {
                    markerProcessor.consume((Object)param, (Object)true);
                }
                sb.append(param);
                if (markerProcessor == null) continue;
                markerProcessor.consume((Object)param, (Object)false);
            }
            switch (this.myBlockType) {
                case CHOICE: {
                    sb.append("}");
                    break;
                }
                case OPTIONAL_SEQUENCE: {
                    sb.append("]");
                    break;
                }
                case SEQUENCE: {
                    sb.append(")");
                }
            }
            if (this.isMany()) {
                sb.append("...");
            }
            if (markerProcessor != null) {
                markerProcessor.consume((Object)this, (Object)false);
            }
        }
    }

    public static enum ParameterBlockQuantifier {
        ELLIPSIS(true, true, true),
        NON_GREEDY_ELLIPSIS(false, true, true),
        STAR(true, false, false);

        final boolean greedy;
        final boolean atLeastOne;
        final boolean commaSeparated;

        private ParameterBlockQuantifier(boolean greedy, boolean atLeastOne, boolean commaSeparated) {
            this.greedy = greedy;
            this.atLeastOne = atLeastOne;
            this.commaSeparated = commaSeparated;
        }
    }

    public static enum ParameterBlockType {
        SEQUENCE,
        OPTIONAL_SEQUENCE,
        CHOICE;

    }

    public static class Keyword
    extends Parameter {
        private final String myName;

        public Keyword(int prototypeId, String name2) {
            super(prototypeId);
            this.myName = name2;
        }

        public String getName() {
            return this.myName;
        }

        public String toString() {
            return this.myName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new Keyword(prototypeId, this.myName);
        }
    }

    public static class ExternalParameter
    extends Parameter {
        private final IElementType myNodeType;
        private final String myDisplayName;

        public ExternalParameter(int prototypeId, IElementType nodeType, String displayName) {
            super(prototypeId);
            this.myNodeType = nodeType;
            this.myDisplayName = displayName;
        }

        @NotNull
        public IElementType getNodeType() {
            IElementType iElementType = this.myNodeType;
            if (iElementType == null) {
                ExternalParameter.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        public String toString() {
            return this.myDisplayName;
        }

        @Override
        public Parameter copyWithPrototype(int prototypeId) {
            return new ExternalParameter(prototypeId, this.myNodeType, this.myDisplayName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/BuiltinFunction$ExternalParameter", "getNodeType"));
        }
    }
}

