/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDataSourceValidator
extends DatabaseConfigValidator<SqlDataSourceImpl> {
    @Override
    public Class<SqlDataSourceImpl> getTargetClass() {
        return SqlDataSourceImpl.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull SqlDataSourceImpl target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(2);
        }
        this.detectDialectProblems(project, target2, problems, configInfoProvider);
        if (target2.getUrls().isEmpty()) {
            problems.consume((Object)new DataSourceProblem(target2, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(SqlBundle.message("notification.title.incomplete.configuration", new Object[0]), SqlBundle.message("notification.content.no.ddl.files.specified", new Object[0]), SqlBundle.message("notification.content.no.ddl.files.specified", new Object[0]), new Object[0]), null));
        }
    }

    private void detectDialectProblems(@NotNull Project project, @NotNull SqlDataSourceImpl target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        boolean dialectConflict;
        SqlLanguageDialect parentDsDialect;
        Dbms definedDbms;
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(5);
        }
        SqlLanguageDialect explicitDialect = (definedDbms = target2.getDefinedDbms()) == null ? null : DbSqlUtilCore.getSqlDialect(definedDbms);
        Set<SqlLanguageDialect> dialects = SqlDataSourceValidator.collectDialects(project, target2);
        DbDataSource parentDs = target2.getParentDataSource();
        SqlLanguageDialect sqlLanguageDialect = parentDsDialect = parentDs == null ? null : DbSqlUtilCore.getSqlDialect(parentDs);
        if (parentDsDialect != null) {
            dialects.add(parentDsDialect);
        }
        Set dbms = (Set)JBIterable.from(dialects).map(SqlLanguageDialect::getDbms).addAllTo(new LinkedHashSet());
        Dbms explicitDbms = explicitDialect == null ? null : explicitDialect.getDbms();
        boolean explicitConflict = !dbms.isEmpty() && explicitDbms != null && !dbms.contains(explicitDbms);
        ContainerUtil.addIfNotNull((Collection)dbms, (Object)explicitDbms);
        boolean bl = dialectConflict = dbms.size() > 1;
        if (!explicitConflict && !dialectConflict) {
            return;
        }
        ContainerUtil.addIfNotNull(dialects, (Object)explicitDialect);
        @Nls String msg = SqlBundle.message("inconsistent.dialects.for.files.0.choice.0.and.parent.data.source.1", parentDs != null ? 0 : 1);
        ArrayList<Object> actions = new ArrayList<Object>(dialects.size());
        @NlsSafe StringBuilder actionsText = new StringBuilder(SqlBundle.message("sql.data.source.dialect.set.all.to", new Object[0])).append(" ");
        int sz = actionsText.length();
        for (SqlLanguageDialect dialect : ContainerUtil.sorted(dialects, Comparator.comparing(Language::getDisplayName))) {
            if (actionsText.length() != sz) {
                actionsText.append(", ");
            }
            actionsText.append("<a href='$ACTION").append(actions.size()).append("'>");
            actionsText.append(dialect.getDisplayName());
            actionsText.append("</a>");
            actions.add(editor2 -> {
                SqlDataSourceConfigurable configurable = editor2 == null ? null : editor2.getConfigurable(target2, false, SqlDataSourceConfigurable.class);
                SqlDataSourceValidator.setAllFilesTo(project, target2, dialect.getDbms(), dialect, configurable);
            });
        }
        actionsText.append(". ").append("<a href='$ACTION").append(actions.size()).append("'>").append(SqlBundle.message("sql.data.source.dialect.configure", new Object[0])).append("</a>");
        actions.add(() -> SqlDataSourceValidator.configureMappings(project, target2));
        problems.consume((Object)new DataSourceProblem(target2, this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(msg, actionsText.toString(), actionsText.toString(), actions.toArray()), null));
    }

    @NotNull
    private static Set<SqlLanguageDialect> collectDialects(@NotNull Project project, @NotNull SqlDataSourceImpl target2) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(6);
        }
        if (target2 == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(7);
        }
        TreeSet<SqlLanguageDialect> dialects = new TreeSet<SqlLanguageDialect>(Comparator.comparing(Language::getDisplayName));
        SqlDialectMappings mapping = SqlDialectMappings.getInstance(project);
        target2.processFilesInner(true, (Processor<VirtualFile>)((Processor)f -> {
            ContainerUtil.addIfNotNull((Collection)dialects, (Object)((SqlLanguageDialect)mapping.getImmediateMapping((VirtualFile)f)));
            return true;
        }));
        for (VirtualFile root : target2.getRoots()) {
            SqlLanguageDialect dialect = (SqlLanguageDialect)mapping.getDirectlyConfiguredMapping(root);
            if (dialect == null) {
                dialect = (SqlLanguageDialect)mapping.getImmediateMapping(null);
            }
            if (dialect == null) {
                dialect = mapping.getDefaultMapping(root);
            }
            ContainerUtil.addIfNotNull(dialects, (Object)dialect);
        }
        TreeSet<SqlLanguageDialect> treeSet = dialects;
        if (treeSet == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(8);
        }
        return treeSet;
    }

    public static void configureMappings(Project project, SqlDataSourceImpl target2) {
        List<VirtualFile> files2 = target2.getRoots();
        SqlDialectsConfigurable.openDialectsConfigurable(project, files2);
    }

    public static void setAllFilesTo(@NotNull Project project, SqlDataSourceImpl target2, @NotNull Dbms dbms, SqlLanguageDialect dialect, SqlDataSourceConfigurable configurable) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(9);
        }
        if (dbms == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(10);
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance(project);
        for (VirtualFile root : target2.getRoots()) {
            if (instance.getMapping(root) == dialect) continue;
            instance.setMapping(root, dialect);
        }
        target2.setDefinedDbms(dbms);
        if (configurable != null) {
            configurable.setCurrentDbms(dbms);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectDialectProblems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDialects";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAllFilesTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

