/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LoadingState;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceAutoSyncManager;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceTextStorage;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="SqlDataSourceStorage", storages={@Storage(value="sqlDataSources.xml")})
public final class SqlDataSourceStorage
implements PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(SqlDataSourceStorage.class);
    private final Project myProject;
    private final List<SqlDataSourceImpl> myDataSources;
    private final LoadingState.Holder<SqlDataSourceImpl> myLoadingState;

    public static SqlDataSourceStorage getInstance(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(0);
        }
        return (SqlDataSourceStorage)project.getService(SqlDataSourceStorage.class);
    }

    public SqlDataSourceStorage(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(1);
        }
        this.myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadingState = new LoadingState.Holder();
        this.myProject = project;
        DataSourceStorage.getProjectStorage(project);
    }

    public void dispose() {
    }

    public State getState() {
        State state = new State();
        for (SqlDataSourceImpl dataSource : this.myDataSources) {
            state.dataSources.add(dataSource.getState());
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(2);
        }
        this.myLoadingState.run(AsyncTask.frame(SqlBundle.message("progress.title.loading.ddl.data.sources", new Object[0])), currentState -> this.loadState(state, (LoadingState<SqlDataSourceImpl>)currentState));
    }

    @NotNull
    private AsyncTask<?> loadState(@NotNull State state, LoadingState<SqlDataSourceImpl> currentState) {
        if (state == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(3);
        }
        AsyncTask asyncTask = AsyncTask.currentFrame().compute(null, () -> {
            this.myDataSources.clear();
            for (SqlDataSourceImpl.State dataSourceState : state.dataSources) {
                SqlDataSourceImpl dataSource = new SqlDataSourceImpl(DasUtil.NO_NAME, this.myProject, null);
                dataSource.loadState(dataSourceState);
                currentState.markLoading(dataSource);
                this.addDataSource(dataSource);
            }
            return null;
        }).apply(AsyncUtil.getPoolExecutor(), r -> {
            for (SqlDataSourceImpl dataSource : this.myDataSources) {
                SqlDataSourceStorage.tryLoadModel(dataSource, currentState);
            }
            return null;
        });
        if (asyncTask == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(4);
        }
        return asyncTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryLoadModel(SqlDataSourceImpl dataSource, LoadingState<SqlDataSourceImpl> currentState) {
        try {
            ModelImporter importer = new ModelImporter(new ModelFactory(new SqlDataSourceTextStorage(dataSource)));
            BasicModModel model = importer.restoreFromStorageOnly();
            if (model != null) {
                dataSource.setModel(model);
            }
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable th) {
            LOG.error(th);
        }
        finally {
            currentState.markLoaded(dataSource);
        }
    }

    public List<SqlDataSourceImpl> getDataSources() {
        return new ArrayList<SqlDataSourceImpl>(this.myDataSources);
    }

    public void removeDataSource(SqlDataSourceImpl dataSource) {
        this.myDataSources.remove(dataSource);
        dataSource.unregistered();
        ((SqlDataSourceAutoSyncManager)this.myProject.getService(SqlDataSourceAutoSyncManager.class)).onDataSourceRemoved(dataSource);
    }

    public void addDataSource(SqlDataSourceImpl dataSource) {
        this.myDataSources.add(dataSource);
        dataSource.registered();
    }

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull SqlDataSourceImpl dataSource) {
        LoadingState<SqlDataSourceImpl> state;
        if (dataSource == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(5);
        }
        Promise<?> promise = (state = this.myLoadingState.get()) == null ? Promises.resolvedPromise() : state.getLoadingPromise(dataSource);
        if (promise == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(6);
        }
        return promise;
    }

    public boolean isLoading(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(7);
        }
        return this.getLoadingPromise(dataSource).getState() == Promise.State.PENDING;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceStorage";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }

    public static class State {
        public List<SqlDataSourceImpl.State> dataSources = new ArrayList<SqlDataSourceImpl.State>();
    }
}

