/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationSettingsEditor;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingLink;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.ide.actions.AttachDirectoryUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceDialectComponent;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceManager;
import com.intellij.sql.database.SqlDataSourceRootsList;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class SqlDataSourceConfigurable
extends AbstractDataSourceConfigurable<SqlDataSourceManager, SqlDataSourceImpl> {
    private final PathColumnInfo myPathColumn;
    private final TableView<FileScope> myScopesTable;
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private JPanel myNamePanel;
    private JPanel myDdlListPanel;
    private ComboBox<Path> myOutLayout;
    private TextFieldWithBrowseButton myOutPath;
    private JPanel myGenerationSettingsPanel;
    private JPanel myDdlFooter;
    private ComboBox<@NlsSafe String> myCodeStyle;
    private JBCheckBox myAutoSync;
    private JPanel myScopesPanel;
    private JBScrollPane mySettingsScroll;
    private final ListTableModel<FileScope> myScopesModel;
    private DdlMappingLink myMappingLink;
    private final SqlDataSourceRootsList myRootsList;
    private SqlDataSourceDialectComponent myDialectComponent;
    private DatabaseNameComponent myNameComponent;
    private final ScriptOptionsPanel myScriptOptionsPanel;
    private Dbms myDbms;
    private final SqlDataSourceImpl myTempDataSource;

    public SqlDataSourceConfigurable(SqlDataSourceManager manager, SqlDataSourceImpl dataSource) {
        super(manager, dataSource, dataSource.getProject());
        Function0 function0 = () -> null;
        this.$$$setupUI$$$();
        this.myScriptOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)function0);
        this.myTempDataSource = dataSource.copy(true);
        Dbms dbms = dataSource.getDbms();
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dbms);
        this.myCodeStyle.setModel(DataSourceOptionsPanel.createCodeStyleComboBox(dialect));
        final CollectionComboBoxModel model = new CollectionComboBoxModel(new ArrayList<Path>(SchemaLayoutScripts.getScriptFiles()));
        this.myOutLayout.setModel((ComboBoxModel)model);
        this.myOutLayout.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Path>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Path> list, Path value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    this.append(FileUtil.getNameWithoutExtension((String)StringUtil.notNullize((String)SqlDataSourceImpl.getDefaultLayout())), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(FileUtil.getNameWithoutExtension((String)value.getFileName().toString()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceConfigurable$1", "customizeCellRenderer"));
            }
        });
        this.myOutLayout.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                model.replaceAll(SchemaLayoutScripts.getScriptFiles());
            }
        });
        this.mySettingsScroll.setBorder(null);
        this.myGenerationSettingsPanel.add((Component)this.myScriptOptionsPanel.getComponent(), "Center");
        this.updateScriptUi(dataSource.getDbms(), DefaultScriptingOptions.INSTANCE);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DatabaseBundle.message("dialog.title.root.path", new Object[0])).withDescription(DatabaseBundle.message("label.where.to.generate.sources", new Object[0]));
        this.myOutPath.addBrowseFolderListener(dataSource.getProject(), fileChooserDescriptor);
        this.myPathColumn = new PathColumnInfo(this.myProject);
        this.myScopesModel = new ListTableModel<FileScope>(new ColumnInfo[]{this.myPathColumn, new ScopeColumnInfo(this.myProject, this)}){

            public void addRow() {
                FileScope item = new FileScope();
                item.path = StringUtil.notNullize((String)SqlDataSourceConfigurable.this.myPathColumn.myRootPath);
                this.addRow(item);
            }
        };
        this.myScopesTable = new TableView(this.myScopesModel);
        this.myScopesTable.setTableHeader(null);
        this.myScopesPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myScopesTable.getComponent()).createPanel(), "Center");
        this.myRootsList = new SqlDataSourceRootsList(this);
    }

    private void updateMappingLink() {
        this.myDialectComponent.update();
    }

    private void updateScriptUi(@Nullable Dbms dbms, @Nullable ScriptingOptions options) {
        if (dbms == null) {
            dbms = this.getCurrentDbms();
        }
        ScriptingSingleModelTask task = new ScriptingSingleModelTaskBuilder((BasicModel)ModelFactory.BLACK_HOLE.createModel(dbms), ScriptCategory.CREATE_COMPLETE).build();
        if (options == null) {
            this.myScriptOptionsPanel.adjustOptionsVisibility(task);
        } else {
            this.myScriptOptionsPanel.adjustOptionsUI(task, options);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Override
    @NotNull
    public SqlDataSourceImpl getTempDataSource() {
        this.saveData(this.myTempDataSource);
        SqlDataSourceImpl sqlDataSourceImpl = this.myTempDataSource;
        if (sqlDataSourceImpl == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        return sqlDataSourceImpl;
    }

    public static boolean checkGenericDialectUsage(final Project project, Collection<String> urls) {
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        final Ref selectFile = Ref.create(null);
        final List<VirtualFile> files2 = SqlDataSourceConfigurable.getFiles(urls);
        for (VirtualFile file : files2) {
            if (!selectFile.isNull() || mappings.getMapping(file) != SqlDialects.getGenericDialect()) continue;
            selectFile.set((Object)file);
        }
        if (!selectFile.isNull()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    final SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
                    SingleConfigurableEditor editor2 = new SingleConfigurableEditor(project, (Configurable)configurable){

                        protected ValidationInfo doValidate() {
                            for (VirtualFile file : files2) {
                                SqlLanguageDialect dialect = (SqlLanguageDialect)configurable.getNewMapping(file);
                                if (dialect != SqlDialects.getGenericDialect()) continue;
                                return new ValidationInfo(SqlBundle.message("generic.sql.dialect.usage.error.message", VfsUtilCore.urlToPath((String)file.getPresentableUrl()), StringUtil.escapeXmlEntities((String)SqlDialects.getGenericDialect().getDisplayName())));
                            }
                            return super.doValidate();
                        }

                        protected boolean postponeValidation() {
                            return false;
                        }
                    };
                    configurable.selectFile((VirtualFile)selectFile.get());
                    editor2.show();
                }
            });
        }
        return true;
    }

    public static void applyPresetMapping(@NotNull Project project, @NotNull Collection<String> urls, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (urls == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        List<VirtualFile> files2 = SqlDataSourceConfigurable.getFiles(urls);
        for (VirtualFile file : files2) {
            if (mappings.getMapping(file) == dialect || mappings.getImmediateMapping(file) != null) continue;
            mappings.setMapping(file, dialect);
        }
    }

    @NotNull
    private static List<VirtualFile> getFiles(Collection<String> urls) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            files2.add(file);
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nls
    private String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "data.sources.and.drivers.dialog";
    }

    @Nullable
    public JComponent createComponent() {
        this.myDialectComponent = new SqlDataSourceDialectComponent(this);
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myNamePanel.add((Component)this.myNameComponent.getComponent(), "Center");
        JComponent panel2 = this.myRootsList.createPanel();
        panel2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        this.myDdlListPanel.add((Component)panel2, "Center");
        this.myContentPanel.setBorder(null);
        this.myDdlFooter.setBorder((Border)JBUI.Borders.empty((int)4, (int)UIUtil.PANEL_REGULAR_INSETS.left, (int)0, (int)UIUtil.PANEL_REGULAR_INSETS.right));
        this.myMappingLink = new DdlMappingLink(this.getController()){

            @Override
            protected void setUp(DdlMapping mapping) {
                mapping.setName(SqlDataSourceConfigurable.this.getController().generateObjectName(mapping, SqlDataSourceConfigurable.this.getNameValue() + " Mapping"));
                mapping.setDdlDataSourceId(((SqlDataSourceImpl)SqlDataSourceConfigurable.this.getDataSource()).getUniqueId());
            }

            @Override
            protected JBIterable<DdlMapping> getMappings() {
                String id = ((SqlDataSourceImpl)SqlDataSourceConfigurable.this.getTarget()).getUniqueId();
                return SqlDataSourceConfigurable.this.getController().getMappings().map(SqlDataSourceConfigurable.this.getController()::getTempTargetOrTarget).filter(m -> id.equals(m.getDdlDataSourceId()));
            }
        };
        this.myNameComponent.getComponent().add((Component)((Object)this.myMappingLink), DatabaseUIUtils.createSimpleConstraints(0, 3, 2));
        return this.myRootPanel;
    }

    public void saveData(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        this.myRootsList.saveData(dataSource);
        this.myNameComponent.save(dataSource);
        dataSource.setDefinedDbms(this.myDbms);
        Path layout = (Path)this.myOutLayout.getItem();
        dataSource.setOutputLayout(layout == null ? null : layout.getFileName().toString());
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        this.myScriptOptionsPanel.gatherOptions().export(opts);
        dataSource.setScriptOptions(opts);
        dataSource.setOutputPath(StringUtil.nullize((String)this.myOutPath.getText()));
        dataSource.setCodeStyleName(StringUtil.nullize((String)((String)this.myCodeStyle.getSelectedItem()), (String)"Default"));
        dataSource.setAutoSync(this.myAutoSync.isSelected());
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        for (FileScope item : this.myScopesModel.getItems()) {
            scopes.put(item.path, item.scope);
        }
        dataSource.setScopes(scopes);
        if (this.myDbms == null) {
            dataSource.setDefinedDbms(dataSource.detectDbms());
        }
    }

    public void apply() throws ConfigurationException {
        this.myScopesTable.stopEditing();
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (this.myDbms != null) {
            SqlDataSourceConfigurable.applyPresetMapping(this.myProject, tempDataSource.getUrls(), DbSqlUtilCore.getSqlDialect(this.myDbms));
        }
        SqlDataSourceConfigurable.checkGenericDialectUsage(this.myProject, tempDataSource.getUrls());
        this.saveData((SqlDataSourceImpl)this.myDataSource);
        if (this.isNewDataSource()) {
            ((SqlDataSourceManager)this.myManager).addDataSource((SqlDataSourceImpl)this.myDataSource);
        }
        if (PlatformUtils.isDataGrip()) {
            AttachDirectoryUtils.addDirectoriesWithUndo((Project)this.myProject, ((SqlDataSourceImpl)this.myDataSource).getRoots());
        }
    }

    @Override
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    protected void reset(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(6);
        }
        this.myNameComponent.reset(o, null);
        this.myRootsList.reset(o);
        String layout = o.getState().outLayout;
        this.myDbms = o.getDefinedDbms();
        this.myOutLayout.setItem((Object)(layout == null ? null : SchemaLayoutScripts.findScript(layout)));
        this.myOutPath.setText(o.getState().outPath);
        this.myCodeStyle.setSelectedItem((Object)StringUtil.notNullize((String)o.getCodeStyleName(), (String)"Default"));
        this.updateScriptUi(o.getDbms(), ScriptingOptionStatic.importScriptingOptions(o.getScriptOptions()));
        this.myAutoSync.setSelected(o.isAutoSync());
        ArrayList<FileScope> scopes = new ArrayList<FileScope>();
        for (Map.Entry<String, String> e : o.getScopes().entrySet()) {
            FileScope res2 = new FileScope();
            res2.path = e.getKey();
            res2.scope = e.getValue();
            scopes.add(res2);
        }
        this.myScopesModel.setItems(scopes);
        this.updateMappingLink();
    }

    void updateDefaultTexts(@NotNull Collection<String> urls) {
        if (urls == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(7);
        }
        String path = SqlDataSourceImpl.getDefaultOutputPath(this.getProject(), SqlDataSourceConfigurable.getFiles(urls));
        ((JBTextField)this.myOutPath.getTextField()).getEmptyText().setText(StringUtil.notNullize((String)path));
        this.myPathColumn.setRootPath(path);
    }

    @Override
    public JComponent getCommonBar() {
        return this.myDialectComponent.getComponent();
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((SqlDataSourceImpl)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((SqlDataSourceImpl)this.myDataSource) || this.myNameComponent.isModified();
    }

    @Override
    public void onUserActivity() {
        this.validateDeps();
    }

    @Override
    protected void validateDeps() {
        this.myDialectComponent.update();
        this.myMappingLink.updateText();
        this.updateScriptUi(null, null);
    }

    @NotNull
    public Dbms getCurrentDbms() {
        Dbms dbms = this.myDbms != null ? this.myDbms : this.getTempDataSource().getDbms();
        if (dbms == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(8);
        }
        return dbms;
    }

    public void setCurrentDbms(@Nullable Dbms dbms) {
        this.myDbms = dbms;
        this.fireChanged();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBScrollPane jBScrollPane;
        JPanel jPanel3;
        ComboBox comboBox;
        ComboBox comboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel7.add((Component)jBTabbedPane, "Center");
        this.myContentPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/SqlBundle", SqlDataSourceConfigurable.class).getString("sources.tab.title"), null, jPanel6, null);
        this.myDdlListPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel5, "Center");
        this.myDdlFooter = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, "South");
        this.myAutoSync = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("data.source.auto.sync.label"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/SqlBundle", SqlDataSourceConfigurable.class).getString("generation.tab.title"), null, jPanel8, null);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("output.path"));
        jPanel9.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel9.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("output.layout"));
        jPanel9.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutLayout = comboBox2 = new ComboBox();
        jPanel9.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("data.source.code.style.label"));
        jPanel9.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeStyle = comboBox = new ComboBox();
        jPanel9.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myScopesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlDataSourceConfigurable.class).getString("default.schemas.databases"));
        jPanel8.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySettingsScroll = jBScrollPane = new JBScrollPane();
        jPanel8.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myGenerationSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBScrollPane.setViewportView(jPanel2);
        this.myNamePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDbms";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyPresetMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultTexts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class PathColumnInfo
    extends ColumnInfo<FileScope, String> {
        private final Project myProject;
        private String myRootPath;

        private PathColumnInfo(@NotNull Project project) {
            if (project == null) {
                PathColumnInfo.$$$reportNull$$$0(0);
            }
            super("Path");
            this.myProject = project;
        }

        @Nullable
        public String valueOf(FileScope scope2) {
            return scope2.path;
        }

        public void setValue(FileScope scope2, String value) {
            scope2.path = value;
        }

        public TableCellRenderer getRenderer(FileScope scope2) {
            return new DatabaseScriptRunConfigurationSettingsEditor.FileRenderer(this.myProject){

                @Override
                @Nullable
                protected @SystemIndependent @NonNls String getRootPath() {
                    return myRootPath == null ? super.getRootPath() : myRootPath;
                }
            };
        }

        public boolean isCellEditable(FileScope scope2) {
            return true;
        }

        public TableCellEditor getEditor(FileScope scope2) {
            return new LocalPathCellEditor(this.myProject){
                {
                    super(arg0);
                    this.normalizePath(false);
                }

                protected String getDefaultPath() {
                    return myRootPath;
                }
            };
        }

        public void setRootPath(String path) {
            this.myRootPath = path == null ? null : FileUtil.toSystemIndependentName((String)path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/database/SqlDataSourceConfigurable$PathColumnInfo", "<init>"));
        }
    }

    private class ScopeColumnInfo
    extends ColumnInfo<FileScope, String> {
        private final Project myProject;
        private final Disposable myParent;

        private ScopeColumnInfo(@NotNull Project project, Disposable parent) {
            if (project == null) {
                ScopeColumnInfo.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ScopeColumnInfo.$$$reportNull$$$0(1);
            }
            super("Scope");
            this.myProject = project;
            this.myParent = parent;
        }

        @Nullable
        public String valueOf(FileScope scope2) {
            return scope2.scope;
        }

        public void setValue(FileScope scope2, String value) {
            scope2.scope = value;
        }

        public boolean isCellEditable(FileScope scope2) {
            return true;
        }

        public TableCellRenderer getRenderer(FileScope scope2) {
            return new EditorTextFieldCellRenderer(this.myProject, SqlDialects.getGenericDialect(), this.myParent){

                protected String getText(JTable table, Object value, int row, int column2) {
                    String text2 = value == null ? "" : value.toString();
                    return text2.isEmpty() ? "-- database.schema" : text2;
                }
            };
        }

        public TableCellEditor getEditor(FileScope scope2) {
            return new AbstractTableCellEditor(){
                private final EditorTextField myField = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)this.createFragment(SqlDialects.getGenericDialect()));

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
                    DatabaseDialogsHelper.setTextFieldLanguage(this.myField, DbSqlUtilCore.getSqlDialect(SqlDataSourceConfigurable.this.getCurrentDbms()), dialect -> this.createFragment((SqlLanguageDialect)dialect));
                    this.myField.setText(value == null ? "" : value.toString());
                    return this.myField;
                }

                @NotNull
                private PsiCodeFragment createFragment(SqlLanguageDialect dialect) {
                    return new SqlCodeFragmentImpl(ScopeColumnInfo.this.myProject, dialect, SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE, "a.sql", "", true);
                }

                public Object getCellEditorValue() {
                    return this.myField.getText();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/database/SqlDataSourceConfigurable$ScopeColumnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileScope {
        String path = "";
        String scope = "";

        private FileScope() {
        }
    }
}

