/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.actions.members;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.actions.members.SqlImplementMembersHandler;
import com.intellij.sql.actions.members.SqlMemberChooser;
import com.intellij.sql.actions.members.SqlMemberChooserObject;
import com.intellij.sql.actions.members.SqlMembersHelper;
import com.intellij.sql.actions.members.SqlRoutineChooserObject;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J!\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0096\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/actions/members/SqlImplementMembersHandler;", "Lcom/intellij/lang/LanguageCodeInsightActionHandler;", "Lcom/intellij/codeInsight/generation/actions/PresentableCodeInsightActionHandler;", "<init>", "()V", "isValidFor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "update", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "getMemberContainer", "Lcom/intellij/psi/PsiElement;", "chooseMembers", "", "Lcom/intellij/sql/actions/members/SqlMemberChooserObject;", "members", "appendToBlock", "Lcom/intellij/sql/psi/SqlDefinition;", "definition", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlImplementMembersHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlImplementMembersHandler.kt\ncom/intellij/sql/actions/members/SqlImplementMembersHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n295#2,2:100\n295#2,2:106\n37#3:102\n36#3,3:103\n1321#4,2:108\n*S KotlinDebug\n*F\n+ 1 SqlImplementMembersHandler.kt\ncom/intellij/sql/actions/members/SqlImplementMembersHandler\n*L\n77#1:100,2\n92#1:106,2\n84#1:102\n84#1:103,3\n70#1:108,2\n*E\n"})
public final class SqlImplementMembersHandler
implements LanguageCodeInsightActionHandler,
PresentableCodeInsightActionHandler {
    public boolean isValidFor(@Nullable Editor editor2, @Nullable PsiFile file) {
        return file instanceof SqlFile && editor2 != null && this.getMemberContainer(editor2, file) != null;
    }

    public void update(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable Presentation presentation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Presentation presentation2 = presentation;
            if (presentation2 == null) break block0;
            presentation2.setText(SqlBundle.message("action.sql.ImplementMembersAction.text", new Object[0]));
        }
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        List<SqlMemberChooserObject<?>> selectedMembers;
        JBIterable jBIterable;
        JBIterable jBIterable2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)psiFile);
        SqlMembersHelper sqlMembersHelper = SqlMembersHelper.EP.forDbms(dbms);
        if (sqlMembersHelper == null) {
            return;
        }
        SqlMembersHelper membersHelper = sqlMembersHelper;
        NavigationHelper navigationHelper = NavigationHelper.EP.forDbms(dbms);
        if (navigationHelper == null) {
            return;
        }
        NavigationHelper navigationHelper2 = navigationHelper;
        PsiElement psiElement = this.getMemberContainer(editor2, psiFile);
        if (psiElement == null) {
            return;
        }
        PsiElement container = psiElement;
        PsiElement psiElement2 = container;
        if ((psiElement2 instanceof SqlBlockStatement ? JBIterable.of((Object)container) : (psiElement2 instanceof SqlDefinition ? ((jBIterable2 = navigationHelper2.findSuperDefinitions((DasObject)container, false)) != null && (jBIterable2 = (JBIterable)jBIterable2.second) != null ? jBIterable2.filter(SqlDefinition.class) : null) : (jBIterable = null))) == null) {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        JBIterable headerContainers = jBIterable;
        JBIterable jBIterable4 = headerContainers.flatMap(arg_0 -> SqlImplementMembersHandler.invoke$lambda$0(invoke.candidates.1.INSTANCE, arg_0)).filter(SqlRoutineDefinition.class).filter(arg_0 -> SqlImplementMembersHandler.invoke$lambda$2(arg_0 -> SqlImplementMembersHandler.invoke$lambda$1(container, navigationHelper2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
        JBIterable candidates2 = jBIterable4;
        if (candidates2.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor2, SqlBundle.message("implement.members.no.members.to.implement", new Object[0]));
            return;
        }
        PsiElementMemberChooserObject rootNode = new PsiElementMemberChooserObject(container, SqlBundle.message("implement.members.code.block", new Object[0]));
        List<SqlMemberChooserObject<?>> list = candidates2.map(arg_0 -> SqlImplementMembersHandler.invoke$lambda$4(arg_0 -> SqlImplementMembersHandler.invoke$lambda$3(rootNode, dbms, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List<SqlMemberChooserObject<?>> members = list;
        List<SqlMemberChooserObject<?>> list2 = selectedMembers = !ApplicationManager.getApplication().isUnitTestMode() ? this.chooseMembers(project, members) : members;
        if (selectedMembers.isEmpty()) {
            return;
        }
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).run(() -> SqlImplementMembersHandler.invoke$lambda$8(selectedMembers, project, membersHelper, this, container, psiFile));
    }

    private final PsiElement getMemberContainer(Editor editor2, PsiFile file) {
        Object v2;
        block2: {
            SqlMembersHelper sqlMembersHelper = SqlMembersHelper.EP.forDbms(SqlImplUtil.getDbms((PsiElement)file));
            if (sqlMembersHelper == null) {
                return null;
            }
            SqlMembersHelper helper = sqlMembersHelper;
            PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
            JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlParents(element);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlParents(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!helper.isMemberImplHolder(it)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final List<SqlMemberChooserObject<?>> chooseMembers(Project project, List<? extends SqlMemberChooserObject<?>> members) {
        Collection $this$toTypedArray$iv = members;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SqlMemberChooser chooser = new SqlMemberChooser(thisCollection$iv.toArray(new SqlMemberChooserObject[0]), project);
        chooser.setTitle(SqlBundle.message("implement.members.chooser.title", new Object[0]));
        chooser.show();
        List list = chooser.getExitCode() != 0 ? null : chooser.getSelectedElements();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final SqlDefinition appendToBlock(PsiElement $this$appendToBlock, SqlDefinition definition) {
        Object v1;
        block2: {
            SqlTokenType stopKeywordType = $this$appendToBlock instanceof SqlBlockStatement ? SqlCommonKeywords.SQL_BEGIN : SqlCommonKeywords.SQL_END;
            JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlRevChildren($this$appendToBlock);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlRevChildren(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)((Object)stopKeywordType))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        if (psiElement == null) {
            return null;
        }
        PsiElement anchor = psiElement;
        PsiParserFacade parserFacade = PsiParserFacade.getInstance((Project)$this$appendToBlock.getProject());
        PsiElement definitionInPlace = $this$appendToBlock.addBefore((PsiElement)definition, anchor);
        $this$appendToBlock.addBefore(parserFacade.createWhiteSpaceFromText("\n"), anchor);
        $this$appendToBlock.addBefore(parserFacade.createWhiteSpaceFromText("\n\n"), definitionInPlace);
        Intrinsics.checkNotNull((Object)definitionInPlace, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlDefinition");
        return (SqlDefinition)definitionInPlace;
    }

    private static final Iterable invoke$lambda$0(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean invoke$lambda$1(PsiElement $container, NavigationHelper $navigationHelper, SqlRoutineDefinition it) {
        if ($container instanceof SqlBlockStatement) {
            if (!it.getBody().isEmpty()) return false;
        }
        JBIterable jBIterable = $navigationHelper.findDefinitions(it, false);
        JBIterable jBIterable2 = jBIterable;
        if (jBIterable == null) return true;
        JBIterable jBIterable3 = (JBIterable)jBIterable2.second;
        jBIterable2 = jBIterable3;
        if (jBIterable3 == null) return true;
        if (!jBIterable2.isNotEmpty()) return true;
        return false;
    }

    private static final boolean invoke$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final SqlRoutineChooserObject invoke$lambda$3(PsiElementMemberChooserObject $rootNode, Dbms $dbms, SqlRoutineDefinition it) {
        Intrinsics.checkNotNull((Object)it);
        DasRoutine dasRoutine = it;
        MemberChooserObject memberChooserObject = (MemberChooserObject)$rootNode;
        Intrinsics.checkNotNull((Object)$dbms);
        return new SqlRoutineChooserObject(dasRoutine, memberChooserObject, $dbms);
    }

    private static final SqlRoutineChooserObject invoke$lambda$4(Function1 $tmp0, Object p0) {
        return (SqlRoutineChooserObject)((Object)$tmp0.invoke(p0));
    }

    private static final SqlDefinition invoke$lambda$8$lambda$5(SqlMembersHelper $membersHelper, SqlImplementMembersHandler this$0, PsiElement $container, SqlMemberChooserObject selectedElement) {
        Object t = selectedElement.getDasObject();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        SqlRoutineDefinition sqlRoutineDefinition = $membersHelper.generateImplementation((SqlRoutineDefinition)t);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition, (String)"generateImplementation(...)");
        SqlRoutineDefinition definition = sqlRoutineDefinition;
        return this$0.appendToBlock($container, definition);
    }

    private static final void invoke$lambda$8(List $selectedMembers, Project $project, SqlMembersHelper $membersHelper, SqlImplementMembersHandler this$0, PsiElement $container, PsiFile $psiFile) {
        Sequence declarationsInPlace = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$selectedMembers), arg_0 -> SqlImplementMembersHandler.invoke$lambda$8$lambda$5($membersHelper, this$0, $container, arg_0));
        PsiDocumentManager $this$invoke_u24lambda_u248_u24lambda_u246 = PsiDocumentManager.getInstance((Project)$project);
        boolean bl = false;
        Document document = $this$invoke_u24lambda_u248_u24lambda_u246.getDocument($psiFile);
        if (document != null) {
            $this$invoke_u24lambda_u248_u24lambda_u246.doPostponedOperationsAndUnblockDocument(document);
        }
        Sequence $this$forEach$iv = declarationsInPlace;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlDefinition it = (SqlDefinition)element$iv;
            boolean bl2 = false;
            CodeStyleManager.getInstance((Project)$project).reformat((PsiElement)it);
        }
    }
}

