/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriverPropertiesComponent {
    private static final String USER_DEFINED_DESCRIPTION = "User defined driver property.";
    private static final Set<String> PROHIBITED_PROPERTIES_NAMES = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("user", "password", "host", "port", "dbname", "pwd", "uid", "pghost", "pgport", "pgdbname"));
    private JPanel myRoot;
    private JBLoadingPanel myLoadingPanel;
    private TableView<DriverPropertyInfo> myPropertiesTable;
    private JTextArea myPropertyInfo;
    private final FallThroughValues myValuesMap;
    private final Map<String, String> myDriverDefaults;
    private final List<DriverPropertyInfo> myUserProperties;
    private String myPropertiesDriverName;
    private List<SimpleClasspathElement> myClassPath;
    private final Project myProject;
    private final AbstractDatabaseConfigurable<?> myOwner;
    private final DatabaseConfigEditor myController;

    public DriverPropertiesComponent(@NotNull Project project, @NotNull Map<String, String> properties2, @NotNull AbstractDatabaseConfigurable<?> owner, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(0);
        }
        if (properties2 == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(3);
        }
        this.myValuesMap = new FallThroughValues();
        this.myDriverDefaults = new HashMap<String, String>();
        this.myUserProperties = new ArrayList<DriverPropertyInfo>();
        this.myClassPath = Collections.emptyList();
        this.myProject = project;
        this.myOwner = owner;
        this.myController = controller;
        if (owner instanceof DataSourceConfigurable) {
            DatabaseDriver driver = ((LocalDataSource)((DataSourceConfigurable)owner).getDataSource()).getDatabaseDriver();
            this.myValuesMap.setDefaults(driver == null ? Collections.emptyMap() : driver.getDriverProperties());
        }
        this.$$$setupUI$$$();
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPropertyInfo.setEditable(false);
        this.myPropertyInfo.setRows(3);
        this.myPropertyInfo.setWrapStyleWord(true);
        this.myPropertyInfo.setLineWrap(true);
        this.myPropertyInfo.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myPropertyInfo.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myPropertyInfo.setText(DatabaseBundle.message("jdbc.properties.property.description", new Object[0]));
        this.myLoadingPanel.setMinimumSize((Dimension)JBUI.size((int)150));
        UiNotifyConnector.installOn(this.myPropertiesTable, (Activatable)new Activatable(){

            public void showNotify() {
                DriverPropertiesComponent.this.refreshAdvancedProperties(false);
            }
        });
        this.myPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = DriverPropertiesComponent.this.myPropertiesTable.getSelectionModel().getLeadSelectionIndex();
                if (index < 0) {
                    DriverPropertiesComponent.this.myPropertyInfo.setText("");
                } else {
                    int modelIndex = DriverPropertiesComponent.this.myPropertiesTable.convertRowIndexToModel(index);
                    DriverPropertyInfo info2 = (DriverPropertyInfo)DriverPropertiesComponent.this.myPropertiesTable.getListTableModel().getItems().get(modelIndex);
                    DriverPropertiesComponent.this.myPropertyInfo.setText(info2.description);
                }
                DriverPropertiesComponent.this.myPropertyInfo.setCaretPosition(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DriverPropertiesComponent$2", "valueChanged"));
            }
        });
        PopupHandler.installPopupMenu(this.myPropertiesTable, (ActionGroup)new DefaultActionGroup(new AnAction[]{new AnAction(DatabaseBundle.message("jdbc.properties.refresh", new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DriverPropertiesComponent.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DriverPropertiesComponent$3", "actionPerformed"));
            }
        }, new AnAction(DatabaseBundle.message("jdbc.properties.reset.to.driver", new Object[0]), null, AllIcons.Diff.Revert){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                DriverPropertyInfo info2;
                boolean enabled;
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                boolean bl = enabled = (info2 = DriverPropertiesComponent.this.getSelected()) != null && DriverPropertiesComponent.this.myValuesMap.isOverridden(info2.name);
                if (enabled) {
                    String def = StringUtil.notNullize((String)DriverPropertiesComponent.this.myValuesMap.getDefault(info2.name));
                    e.getPresentation().setText(DatabaseBundle.message("jdbc.properties.reset.to.driver2", def));
                } else {
                    e.getPresentation().setText(DatabaseBundle.message("jdbc.properties.reset.to.driver", new Object[0]));
                }
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DriverPropertyInfo info2;
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((info2 = DriverPropertiesComponent.this.getSelected()) != null) {
                    DriverPropertiesComponent.this.myValuesMap.reset(info2.name);
                }
                DriverPropertiesComponent.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DriverPropertiesComponent$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DriverPropertiesComponent$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }, new AnAction(DatabaseBundle.message("jdbc.properties.reset.to.default", new Object[0]), null, AllIcons.Diff.Revert){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                DriverPropertyInfo info2;
                boolean enabled;
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                boolean bl = enabled = (info2 = DriverPropertiesComponent.this.getSelected()) != null && DriverPropertiesComponent.this.myValuesMap.get(info2.name) != null;
                if (enabled) {
                    String def = StringUtil.notNullize((String)DriverPropertiesComponent.this.myDriverDefaults.get(info2.name));
                    e.getPresentation().setText(DatabaseBundle.message("jdbc.properties.reset.to.default2", def));
                } else {
                    e.getPresentation().setText(DatabaseBundle.message("jdbc.properties.reset.to.default", new Object[0]));
                }
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DriverPropertyInfo info2;
                if (e == null) {
                    5.$$$reportNull$$$0(2);
                }
                if ((info2 = DriverPropertiesComponent.this.getSelected()) != null) {
                    DriverPropertiesComponent.this.myValuesMap.put(info2.name, null);
                }
                DriverPropertiesComponent.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DriverPropertiesComponent$5";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DriverPropertiesComponent$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }}), (String)"DatabaseDriverPropertiesPopup");
        this.myPropertyInfo.setBackground(this.myRoot.getBackground());
        for (Map.Entry<String, String> prop : properties2.entrySet()) {
            this.addUserDefinedProperty(prop.getKey(), prop.getValue(), true);
        }
        this.ensureNewPropertyPresent();
        this.setupTableView();
    }

    @Nullable
    private DriverPropertyInfo getSelected() {
        int index = this.myPropertiesTable.getSelectionModel().getLeadSelectionIndex();
        int modelIndex = index < 0 ? -1 : this.myPropertiesTable.convertRowIndexToModel(index);
        return modelIndex < 0 ? null : (DriverPropertyInfo)this.myPropertiesTable.getListTableModel().getItems().get(modelIndex);
    }

    public void migrateDriver(@Nullable DatabaseDriver prevDriver, @Nullable DatabaseDriver newDriver) {
        this.myValuesMap.setDefaults(newDriver == null ? Collections.emptyMap() : newDriver.getDriverProperties());
    }

    private DriverPropertyInfo addUserDefinedProperty(String propertyName, String value, boolean changed) {
        DriverPropertyInfo property = new DriverPropertyInfo(propertyName, null);
        property.description = USER_DEFINED_DESCRIPTION;
        this.myUserProperties.add(property);
        if (changed) {
            this.myValuesMap.put(property.name, value);
        }
        return property;
    }

    public void refreshAdvancedProperties(boolean force) {
        boolean emptyDriver;
        DatabaseDriver databaseDriver;
        if (this.myOwner instanceof DataSourceConfigurable) {
            databaseDriver = ((DataSourceConfigurable)this.myOwner).getTempDataSource().getDatabaseDriver();
        } else if (this.myOwner instanceof DatabaseDriverConfigurable) {
            databaseDriver = ((DatabaseDriverConfigurable)this.myOwner).getTempDriver();
        } else {
            throw new AssertionError(this.myOwner);
        }
        if (databaseDriver == null || databaseDriver.getClasspathElements().isEmpty()) {
            return;
        }
        final LocalDataSource tempDataSource = LocalDataSource.fromDriver(databaseDriver, DriverPropertiesComponent.getTempUrl(databaseDriver), true);
        boolean bl = emptyDriver = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || tempDataSource.getClasspathElements().isEmpty();
        if (emptyDriver) {
            this.myPropertiesTable.getEmptyText().setText(DatabaseBundle.message("jdbc.properties.no.properties", new Object[0]));
            this.myPropertiesTable.getListTableModel().setItems(new ArrayList<DriverPropertyInfo>(this.myUserProperties));
            return;
        }
        if (!force && this.isUpToDate(tempDataSource)) {
            return;
        }
        this.myPropertiesTable.getEmptyText().setText("");
        this.myLoadingPanel.startLoading();
        this.myPropertiesDriverName = tempDataSource.getDriverClass();
        this.myClassPath = new ArrayList<SimpleClasspathElement>(tempDataSource.getClasspathElements());
        final ModalityState state = ModalityState.current();
        final String url = this.myOwner instanceof DataSourceConfigurable ? ((DataSourceConfigurable)this.myOwner).getTempDataSource().getUrl() : tempDataSource.getUrl();
        new Task.Backgroundable(this.myProject, DatabaseBundle.message("progress.title.refreshing.driver.properties", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                Project project = DriverPropertiesComponent.this.myProject;
                ArrayList rows = new ArrayList();
                Ref exRef = Ref.create(null);
                try {
                    DatabaseConnectionManager.getInstance().useDriver(project, tempDataSource, DriverPropertiesComponent.this.myController.getSecretService(), (ThrowableConsumer<? super RemoteDriver, ? extends Exception>)((ThrowableConsumer)driver -> {
                        DriverPropertyInfo[] propertyInfo;
                        for (DriverPropertyInfo info2 : propertyInfo = driver.getPropertyInfo(url, new Properties())) {
                            if (PROHIBITED_PROPERTIES_NAMES.contains(info2.name)) continue;
                            if (info2.choices != null && info2.choices.length == 1 && "?".equals(info2.choices[0])) {
                                info2.choices = null;
                            }
                            rows.add(info2);
                        }
                    }));
                }
                catch (Exception e) {
                    exRef.set((Object)e);
                }
                finally {
                    Runnable runnable = () -> {
                        if (Disposer.isDisposed(DriverPropertiesComponent.this.myOwner)) {
                            return;
                        }
                        if (!DriverPropertiesComponent.this.isUpToDate(tempDataSource)) {
                            return;
                        }
                        DriverPropertiesComponent.this.myLoadingPanel.stopLoading();
                        DriverPropertiesComponent.this.myPropertiesTable.getEmptyText().setText(DatabaseBundle.message(exRef.isNull() ? "jdbc.properties.no.properties.found" : "jdbc.properties.error", new Object[0]));
                        DriverPropertiesComponent.this.myDriverDefaults.clear();
                        for (DriverPropertyInfo row : rows) {
                            DriverPropertiesComponent.this.myDriverDefaults.put(row.name, row.value);
                            String existing2 = DriverPropertiesComponent.this.myValuesMap.get(row.name);
                            if (existing2 == null) continue;
                            row.value = existing2;
                        }
                        Iterator<DriverPropertyInfo> it = DriverPropertiesComponent.this.myUserProperties.iterator();
                        while (it.hasNext()) {
                            DriverPropertyInfo property = it.next();
                            if (!DriverPropertiesComponent.this.myDriverDefaults.containsKey(property.name)) {
                                rows.add(property);
                                continue;
                            }
                            it.remove();
                        }
                        Set selection = ContainerUtil.map2Set((Collection)DriverPropertiesComponent.this.myPropertiesTable.getSelectedObjects(), pi -> pi.name);
                        DriverPropertiesComponent.this.myPropertiesTable.getListTableModel().setItems(rows);
                        List selected = ContainerUtil.filter((Collection)rows, pi -> selection.contains(pi.name));
                        DriverPropertiesComponent.this.myPropertiesTable.setSelection((Collection)selected);
                        TableUtil.scrollSelectionToVisible(DriverPropertiesComponent.this.myPropertiesTable);
                        DriverPropertiesComponent.this.myController.showErrorNotification(DriverPropertiesComponent.this.myOwner, "PROPERTIES_LOAD_FAILED", (Exception)exRef.get());
                    };
                    if (project.isOpen()) {
                        ApplicationManager.getApplication().invokeLater(runnable, state);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverPropertiesComponent$6", "run"));
            }
        }.queue();
    }

    @NotNull
    public static String getTempUrl(DatabaseDriver driver) {
        String string = driver.getSampleUrl();
        if (string == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setProperties(@NotNull Map<String, String> properties2) {
        if (properties2 == null) {
            DriverPropertiesComponent.$$$reportNull$$$0(5);
        }
        this.myValuesMap.setProperties(properties2);
        ListTableModel model = this.myPropertiesTable.getListTableModel();
        Set props = ContainerUtil.map2Set((Collection)model.getItems(), pi -> pi.name);
        for (Map.Entry<String, String> prop : properties2.entrySet()) {
            if (props.contains(prop.getKey())) continue;
            model.addRow((Object)this.addUserDefinedProperty(prop.getKey(), prop.getValue(), true));
        }
    }

    private void setupTableView() {
        TableSpeedSearch.installOn(this.myPropertiesTable).setComparator(new SpeedSearchComparator(false));
        final Comparator comparator = (o1, o2) -> {
            if (DriverPropertiesComponent.isUserDefined(o1) && !DriverPropertiesComponent.isUserDefined(o2)) {
                return 1;
            }
            if (DriverPropertiesComponent.isUserDefined(o2) && !DriverPropertiesComponent.isUserDefined(o1)) {
                return -1;
            }
            if (StringUtil.isEmpty((String)o1.name) && !StringUtil.isEmpty((String)o2.name)) {
                return 1;
            }
            if (StringUtil.isEmpty((String)o2.name) && !StringUtil.isEmpty((String)o1.name)) {
                return -1;
            }
            return StringUtil.naturalCompare((String)o1.name, (String)o2.name);
        };
        final DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
                String hint2;
                int style;
                boolean isUser;
                if (table == null) {
                    7.$$$reportNull$$$0(0);
                }
                Component result2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column2);
                DriverPropertyInfo o = (DriverPropertyInfo)DriverPropertiesComponent.this.myPropertiesTable.getListTableModel().getItems().get(DriverPropertiesComponent.this.myPropertiesTable.convertRowIndexToModel(row));
                String propertyValue = DriverPropertiesComponent.this.myValuesMap.get(o.name);
                boolean isJdbcDef = propertyValue == null;
                boolean resetsDrivers = isJdbcDef && DriverPropertiesComponent.this.myValuesMap.isOverridden(o.name);
                boolean bl = isUser = !isJdbcDef && DriverPropertiesComponent.this.myValuesMap.isUser(o.name);
                if (isUser) {
                    style = 1;
                    hint2 = DatabaseBundle.message("jdbc.properties.value.user", new Object[0]);
                } else if (resetsDrivers) {
                    style = column2 == 0 ? 0 : 1;
                    hint2 = DatabaseBundle.message("jdbc.properties.value.resets.driver", new Object[0]);
                } else if (isJdbcDef) {
                    style = 0;
                    hint2 = DatabaseBundle.message("jdbc.properties.value.default", new Object[0]);
                } else {
                    style = column2 == 0 ? 1 : 0;
                    hint2 = DatabaseBundle.message("jdbc.properties.value.driver", new Object[0]);
                }
                result2.setFont(result2.getFont().deriveFont(style));
                ((JComponent)result2).setToolTipText(hint2);
                if (StringUtil.isEmpty((String)o.name) && StringUtil.isEmpty((String)o.value)) {
                    this.setText(column2 == 0 ? DatabaseBundle.message("user.defined", new Object[0]) : DatabaseBundle.message("value", new Object[0]));
                }
                if (!isSelected) {
                    if (StringUtil.isEmpty((String)o.name)) {
                        result2.setForeground(NamedColorUtil.getInactiveTextColor());
                    } else if (DriverPropertiesComponent.isUserDefined(o)) {
                        result2.setForeground(PlatformColors.BLUE);
                    } else {
                        result2.setForeground(UIUtil.getLabelForeground());
                    }
                }
                Component component = result2;
                if (component == null) {
                    7.$$$reportNull$$$0(1);
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DriverPropertiesComponent$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DriverPropertiesComponent$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTableCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTableCellRendererComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        JBTextField editor1Field = new JBTextField();
        editor1Field.setBorder(renderer2.getBorder());
        final ComboBox editor2Combo = new ComboBox();
        editor2Combo.setBorder(null);
        editor2Combo.setEditable(false);
        final DefaultCellEditor editor1 = new DefaultCellEditor((JTextField)editor1Field);
        final DefaultCellEditor editor2 = new DefaultCellEditor((JComboBox<?>)editor2Combo);
        editor2Combo.registerTableCellEditor((TableCellEditor)editor2);
        editor1.setClickCountToStart(1);
        editor2.setClickCountToStart(1);
        this.myPropertiesTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<DriverPropertyInfo, String>(DatabaseBundle.message("jdbc.properties.column.name", new Object[0])){

            public String valueOf(DriverPropertyInfo o) {
                return o.required ? o.name + " *" : o.name;
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer2;
            }

            public Comparator<DriverPropertyInfo> getComparator() {
                return comparator;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return DriverPropertiesComponent.isUserDefined(driverPropertyInfo);
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value) {
                String prevName = driverPropertyInfo.name;
                if (Objects.equals(prevName, value)) {
                    return;
                }
                driverPropertyInfo.name = value;
                String propValue = DriverPropertiesComponent.this.myValuesMap.reset(prevName);
                if (StringUtil.isNotEmpty((String)value) && propValue != null) {
                    driverPropertyInfo.value = propValue;
                }
                if (StringUtil.isEmpty((String)driverPropertyInfo.value) || StringUtil.isEmpty((String)value)) {
                    DbUIUtil.invokeLater(() -> {
                        if (!DriverPropertiesComponent.this.myPropertiesTable.isShowing()) {
                            return;
                        }
                        int index = DriverPropertiesComponent.this.myPropertiesTable.getListTableModel().getItems().indexOf(driverPropertyInfo);
                        if (index < 0) {
                            return;
                        }
                        int row = DriverPropertiesComponent.this.myPropertiesTable.convertRowIndexToView(index);
                        TableUtil.editCellAt(DriverPropertiesComponent.this.myPropertiesTable, (int)row, (int)1);
                    });
                }
                DriverPropertiesComponent.this.ensureNewPropertyPresent();
            }

            public TableCellEditor getEditor(DriverPropertyInfo info2) {
                return editor1;
            }
        }, new ColumnInfo<DriverPropertyInfo, String>(DatabaseBundle.message("jdbc.properties.column.value", new Object[0])){

            public String valueOf(DriverPropertyInfo o) {
                String value = DriverPropertiesComponent.this.myValuesMap.get(o.name);
                return value == null ? o.value : value;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return true;
            }

            @Nullable
            public Comparator<DriverPropertyInfo> getComparator() {
                return Comparator.comparing(this::order);
            }

            private int order(DriverPropertyInfo driverPropertyInfo) {
                if (DriverPropertiesComponent.isUserDefined(driverPropertyInfo) && !driverPropertyInfo.name.isEmpty()) {
                    return 0;
                }
                if (DriverPropertiesComponent.this.myValuesMap.isUser(driverPropertyInfo.name)) {
                    return 1;
                }
                if (DriverPropertiesComponent.this.myValuesMap.isOverridden(driverPropertyInfo.name)) {
                    return 2;
                }
                return 3;
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value) {
                if (DriverPropertiesComponent.isUserDefined(driverPropertyInfo) && DriverPropertiesComponent.this.myValuesMap.get(driverPropertyInfo.name) == null) {
                    driverPropertyInfo.value = value;
                } else if (DriverPropertiesComponent.this.myValuesMap.hasDefault(driverPropertyInfo.name) || !Objects.equals(StringUtil.nullize((String)driverPropertyInfo.value), StringUtil.nullize((String)value))) {
                    DriverPropertiesComponent.this.myValuesMap.put(driverPropertyInfo.name, value);
                } else {
                    DriverPropertiesComponent.this.myValuesMap.reset(driverPropertyInfo.name);
                }
                DriverPropertiesComponent.this.ensureNewPropertyPresent();
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer2;
            }

            public TableCellEditor getEditor(DriverPropertyInfo o) {
                if (o.choices == null || o.choices.length == 0) {
                    return editor1;
                }
                editor2Combo.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList<String>(Arrays.asList(o.choices)), (Object)o.value));
                return editor2;
            }
        }}, new ArrayList<DriverPropertyInfo>(this.myUserProperties), 0));
    }

    private static boolean isUserDefined(DriverPropertyInfo propertyInfo) {
        return Strings.areSameInstance((String)propertyInfo.description, (String)USER_DEFINED_DESCRIPTION);
    }

    private void ensureNewPropertyPresent() {
        ArrayList<DriverPropertyInfo> emptyProperties = new ArrayList<DriverPropertyInfo>();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (!StringUtil.isEmpty((String)property.name) || !StringUtil.isEmpty((String)property.value)) continue;
            emptyProperties.add(property);
        }
        ArrayList<DriverPropertyInfo> toRemove = emptyProperties.isEmpty() ? emptyProperties : emptyProperties.subList(0, emptyProperties.size() - 1);
        this.myUserProperties.removeAll(toRemove);
        ListTableModel model = this.myPropertiesTable.getListTableModel();
        List items = model.getItems();
        if (!toRemove.isEmpty()) {
            int row = Math.min(this.myPropertiesTable.getSelectedRow(), model.getRowCount() - toRemove.size());
            for (DriverPropertyInfo property : toRemove) {
                model.removeRow(items.indexOf(property));
            }
            this.myPropertiesTable.getSelectionModel().setSelectionInterval(row, row);
        }
        if (emptyProperties.isEmpty()) {
            DriverPropertyInfo property = this.addUserDefinedProperty("", "", false);
            model.addRow((Object)property);
            Rectangle rect = this.myPropertiesTable.getCellRect(model.getRowCount() - 1, 0, false);
            this.myPropertiesTable.scrollRectToVisible(rect);
        }
    }

    public void saveProperties(Map<String, String> driverProperties) {
        driverProperties.clear();
        driverProperties.putAll(this.myValuesMap.getValues());
        List allProperties = this.myPropertiesTable.getListTableModel().getItems();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (StringUtil.isEmpty((String)property.name) || this.myValuesMap.get(property.name) != null || !allProperties.contains(property)) continue;
            driverProperties.put(property.name, property.value);
        }
    }

    private boolean isUpToDate(LocalDataSource tempDataSource) {
        return Objects.equals(this.myPropertiesDriverName, tempDataSource.getDriverClass()) && this.myClassPath.equals(tempDataSource.getClasspathElements());
    }

    private void createUIComponents() {
        this.myPropertiesTable = new TableView();
        this.myPropertiesTable.setEnableAntialiasing(true);
        this.myPropertiesTable.setRowHeight(new JTextField((String)"").getPreferredSize().height);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myOwner);
    }

    public JPanel getComponent() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        jBLoadingPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jBLoadingPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBLoadingPanel.add((Component)jBScrollPane, "Center");
        TableView<DriverPropertyInfo> tableView = this.myPropertiesTable;
        jBScrollPane.setViewportView((Component)tableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myPropertyInfo = jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jBScrollPane2.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DriverPropertiesComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DriverPropertiesComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class FallThroughValues {
        private final Map<String, String> myValues = new LinkedHashMap<String, String>();
        private final Map<String, String> myDefaults = new LinkedHashMap<String, String>();

        private FallThroughValues() {
        }

        @Nullable
        String get(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(0);
            }
            return this.myValues.containsKey(key2) ? this.myValues.get(key2) : this.getDefault(key2);
        }

        private String getDefault(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(1);
            }
            return this.myDefaults.get(key2);
        }

        void put(@NotNull String key2, @Nullable String value) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(2);
            }
            if (Objects.equals(value, this.myDefaults.get(key2))) {
                this.myValues.remove(key2);
            } else {
                this.myValues.put(key2, value);
            }
        }

        String reset(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(3);
            }
            return this.myValues.remove(key2);
        }

        boolean isOverridden(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(4);
            }
            return this.isUser(key2) && this.hasDefault(key2);
        }

        boolean hasDefault(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(5);
            }
            return this.myDefaults.containsKey(key2);
        }

        boolean isUser(@NotNull String key2) {
            if (key2 == null) {
                FallThroughValues.$$$reportNull$$$0(6);
            }
            return this.myValues.containsKey(key2);
        }

        public void setDefaults(@NotNull Map<String, String> map2) {
            if (map2 == null) {
                FallThroughValues.$$$reportNull$$$0(7);
            }
            this.myDefaults.clear();
            this.myDefaults.putAll(map2);
            Iterator<Map.Entry<String, String>> it = this.myValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                if (!Objects.equals(e.getValue(), this.myDefaults.get(e.getKey()))) continue;
                it.remove();
            }
        }

        @NotNull
        private Map<String, String> getValues() {
            Map<String, String> map2 = this.myValues;
            if (map2 == null) {
                FallThroughValues.$$$reportNull$$$0(8);
            }
            return map2;
        }

        public void setProperties(Map<String, String> properties2) {
            this.myValues.clear();
            for (Map.Entry<String, String> e : properties2.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriverPropertiesComponent$FallThroughValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriverPropertiesComponent$FallThroughValues";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefault";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isOverridden";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDefault";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isUser";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaults";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

