/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DbSchemaNode;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSchemasSelector {
    protected final TreeEditor myTree;
    protected final JComponent myPanel;

    public DbSchemasSelector(@NotNull Project project) {
        if (project == null) {
            DbSchemasSelector.$$$reportNull$$$0(0);
        }
        this.myTree = this.createTree(project);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setMinimumSize((Dimension)JBUI.size((int)400, (int)100));
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)northPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true), "Center");
    }

    @NotNull
    protected JComponent createNorthPanel() {
        this.myTree.installSimple();
        JPanel res2 = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("SqlResolveEditor", (ActionGroup)this.getTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        actionsToolbar.setReservePlaceAutoPopupIcon(false);
        res2.add((Component)actionsToolbar.getComponent(), "East");
        JPanel jPanel = res2;
        if (jPanel == null) {
            DbSchemasSelector.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void handleIntrospectionError(@NlsContexts.NotificationContent @Nullable String msg) {
        Component component = ((BorderLayout)this.myPanel.getLayout()).getLayoutComponent("South");
        if (component != null) {
            this.myPanel.remove(component);
        }
        if (msg != null) {
            ErrorNotificationPanel panel2 = ErrorNotificationPanel.create((String)msg, null).addDetailsButton().addCloseButton(() -> this.handleIntrospectionError(null)).build();
            this.myPanel.add((Component)panel2, "South");
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    protected DbSchemasTree.MyNode getRoot() {
        return (DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @NotNull
    public Tree getTree() {
        DbSchemasTree dbSchemasTree = this.myTree.getTree();
        if (dbSchemasTree == null) {
            DbSchemasSelector.$$$reportNull$$$0(2);
        }
        return dbSchemasTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DbSchemasSelector.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup getTreeActions() {
        return new DefaultActionGroup(new AnAction[]{new RefreshAction(this.myTree), new ExpandAllAction((JTree)this.getTree()), new CollapseAllAction((JTree)this.getTree())});
    }

    @NotNull
    protected abstract TreeEditor createTree(@NotNull Project var1);

    public static boolean isSingleRoot(@NotNull DasDataSource dataSource) {
        Dbms dbms;
        if (dataSource == null) {
            DbSchemasSelector.$$$reportNull$$$0(4);
        }
        return (dbms = dataSource.getDbms()).isH2() || dbms.isHsqldb();
    }

    @Nullable
    public static String getNodeName(DbSchemasTree.MyNode n) {
        if (n.getObject() == "*") {
            return "*";
        }
        if (n.getObject() instanceof DasDataSource) {
            return ((DasDataSource)n.getObject()).getUniqueId();
        }
        return n.getName();
    }

    public static Map<String, DbSchemasTree.MyNode> fillNodesCache(Iterable<DbSchemasTree.MyNode> children2) {
        HashMap<String, DbSchemasTree.MyNode> oldCache = new HashMap<String, DbSchemasTree.MyNode>();
        for (DbSchemasTree.MyNode node : children2) {
            if (node.getObject() == "*") continue;
            oldCache.put(DbSchemasSelector.getNodeName(node), node);
        }
        return oldCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public abstract class TreeEditor
    extends FilteringTree<CheckedTreeNode, DbSchemasTree.MyNode> {
        private final Project myProject;

        public TreeEditor(@NotNull Project project, @NotNull Tree tree2, CheckedTreeNode root) {
            if (project == null) {
                TreeEditor.$$$reportNull$$$0(0);
            }
            if (tree2 == null) {
                TreeEditor.$$$reportNull$$$0(1);
            }
            if (root == null) {
                TreeEditor.$$$reportNull$$$0(2);
            }
            super(tree2, (DefaultMutableTreeNode)root);
            this.myProject = project;
            SwingUtilities.invokeLater(() -> this.rebuildTree());
        }

        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @NotNull
        protected CheckedTreeNode createNode(@Nullable DbSchemasTree.MyNode obj2) {
            CheckedTreeNode checkedTreeNode = DbSchemasTree.createNode(obj2);
            if (checkedTreeNode == null) {
                TreeEditor.$$$reportNull$$$0(3);
            }
            return checkedTreeNode;
        }

        @NotNull
        protected Iterable<DbSchemasTree.MyNode> getChildren(@NotNull DbSchemasTree.MyNode obj2) {
            if (obj2 == null) {
                TreeEditor.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = obj2.getChildNodes();
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Nullable
        protected String getText(@Nullable DbSchemasTree.MyNode object) {
            return object == null ? null : object.getName();
        }

        @NotNull
        public DbSchemasTree getTree() {
            DbSchemasTree dbSchemasTree = (DbSchemasTree)super.getTree();
            if (dbSchemasTree == null) {
                TreeEditor.$$$reportNull$$$0(6);
            }
            return dbSchemasTree;
        }

        private void rebuildTree() {
            DbSchemasTree.MyNode root = (DbSchemasTree.MyNode)this.getSearchModel().getRootObject();
            root.setHasAll(this.hasAll(null));
            Map<String, DbSchemasTree.MyNode> cache2 = DbSchemasSelector.fillNodesCache(root.getChildNodes());
            ArrayList<DbSchemasTree.MyNode> dataSources = new ArrayList<DbSchemasTree.MyNode>();
            List sorted = ContainerUtil.sorted(this.getDataSources(), (a, b) -> StringUtil.naturalCompare((String)a.getName(), (String)b.getName()));
            for (DasDataSource ds : sorted) {
                BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)ds.getModel(), BasicModel.class);
                DbSchemasTree.MyNode node = cache2.remove(ds.getUniqueId());
                if (node == null || node.getObject() != ds) {
                    DbSchemasTree.MyNode newNode = new DbSchemasTree.MyNode(ds.getName(), ((BasicMetaModel)(model == null ? DbImplUtilCore.getMetaModel((Dbms)Dbms.UNKNOWN) : model.getMetaModel())).root, ds);
                    if (node != null) {
                        newNode.setChecked(node.isChecked());
                        List children2 = node.getChildren();
                        node.setChildren(null);
                        newNode.setChildren(children2);
                        List shadows = node.getShadowChildren();
                        node.setShadowChildren(null);
                        newNode.setShadowChildren(shadows);
                    }
                    node = newNode;
                }
                dataSources.add(node);
                this.addNodes(node, (Iterable<BasicNamespace>)(model == null ? JBIterable.empty() : TreeEditor.sorted(model.getRoot().getNamespaces())), this.hasAll(ds));
            }
            root.setChildren(dataSources);
            root.setShadowChildren(cache2.values());
            cache2.values().forEach(DbSchemaNode::makeShadow);
            this.createShadowStructure(root);
            this.getSearchModel().updateStructure();
        }

        public void update() {
            this.rebuildTree();
            this.getTree().revalidate();
            this.getTree().repaint();
        }

        protected boolean hasAll(@Nullable Object obj2) {
            return false;
        }

        @NotNull
        protected ObjectKind getDsKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                TreeEditor.$$$reportNull$$$0(7);
            }
            return objectKind;
        }

        @NotNull
        protected Iterable<? extends DasDataSource> getDataSources() {
            JBIterable jBIterable = JBIterable.from(DbPsiFacade.getInstance(this.myProject).getDataSources()).transform(DbDataSource::getDelegate);
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        private void addNodes(@NotNull DbSchemasTree.MyNode p2, @NotNull Iterable<BasicNamespace> objects, boolean hasAll) {
            if (p2 == null) {
                TreeEditor.$$$reportNull$$$0(9);
            }
            if (objects == null) {
                TreeEditor.$$$reportNull$$$0(10);
            }
            Map<String, DbSchemasTree.MyNode> oldCache = DbSchemasSelector.fillNodesCache(p2.getChildNodes());
            ArrayList<DbSchemasTree.MyNode> children2 = new ArrayList<DbSchemasTree.MyNode>();
            for (BasicNamespace object : objects) {
                DbSchemasTree.MyNode node = oldCache.remove(object.getName());
                if (node != null) {
                    node.setObject(object);
                } else {
                    node = new DbSchemasTree.MyNode(object.getName(), object.getMetaObject(), object);
                }
                children2.add(node);
                if (!this.shouldExpand(object)) continue;
                this.addNodes(node, TreeEditor.sorted((Iterable<? extends BasicNamespace>)object.getChildren().filter(BasicNamespace.class)), this.hasAll(object));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p2.setHasAll(hasAll);
            p2.setChildren(children2);
            p2.setShadowChildren(oldCache.values());
        }

        protected boolean shouldExpand(BasicNamespace object) {
            ObjectKind kind = object.getKind();
            return kind == this.getDsKind() || kind == ObjectKind.DATABASE;
        }

        private static Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children2) {
            ArrayList namespaces2 = ContainerUtil.newArrayList(children2);
            namespaces2.sort(DasObject.NATURAL_COMPARATOR);
            return namespaces2;
        }

        protected abstract void createShadowStructure(@NotNull DbSchemasTree.MyNode var1);

        public boolean canReintrospect(@NotNull List<LocalDataSource> dataSources) {
            if (dataSources == null) {
                TreeEditor.$$$reportNull$$$0(11);
            }
            for (LocalDataSource dataSource : dataSources) {
                if (!this.canReintrospect(dataSource)) continue;
                return true;
            }
            return false;
        }

        public boolean canReintrospect(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                TreeEditor.$$$reportNull$$$0(12);
            }
            return DbImplUtilCore.canConnectTo(dataSource) && DataSourceSyncManager.getInstance().isAbleToPerform(this.myProject, dataSource);
        }

        public void reintrospect(@NotNull MultiMap<LocalDataSource, BasicNamespace> objects) {
            if (objects == null) {
                TreeEditor.$$$reportNull$$$0(13);
            }
            while (objects.size() != 0) {
                List<DefiniteIntrospectionTask> tasks;
                Collection namespaces2;
                LocalDataSource dataSource = (LocalDataSource)ContainerUtil.getFirstItem((Collection)objects.keySet());
                if (dataSource == null || !this.canReintrospect(dataSource) || (namespaces2 = objects.remove((Object)dataSource)) == null || namespaces2.isEmpty() || (tasks = namespaces2.stream().map(n -> {
                    BasicDatabase db;
                    return n instanceof BasicDatabase ? (db = (BasicDatabase)n) : (n instanceof BasicSchema ? n.getDatabase() : null);
                }).filter(db -> db != null).distinct().map(db -> IntrospectionTasks.prepareListSchemasTask(dataSource.getUniqueId(), db)).toList()).isEmpty()) continue;
                LoaderContext context = LoaderContext.selectTasks(this.myProject, dataSource, tasks);
                AsyncTask<SyncQueue.SyncResult> promise = DataSourceSyncManager.getInstance().tryPerformAsync(context, true, true);
                if (promise == null) continue;
                promise.whenComplete(AsyncUtil.getEdtExecutor(), (res2, e) -> {
                    AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource());
                    DbSchemasSelector.this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
                    if (res2 != null) {
                        this.update();
                    }
                    if (e == null) {
                        this.reintrospect(objects);
                    }
                });
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDsKind";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodes";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "canReintrospect";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "reintrospect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class RefreshAction
    extends DumbAwareAction {
        private final TreeEditor myTreeEditor;

        public RefreshAction(TreeEditor treeEditor) {
            super(DatabaseBundle.messagePointer("action.DbSchemasSelector.refresh.text", new Object[0]), DatabaseBundle.messagePointer("action.DbSchemasSelector.refresh.description", new Object[0]), AllIcons.Actions.Refresh);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{ActionManager.getInstance().getKeyboardShortcut("Synchronize")}), (JComponent)((Object)treeEditor.getTree()));
            this.myTreeEditor = treeEditor;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            List dataSources;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            boolean enabled = !(dataSources = JBIterable.of((Object[])((CheckedTreeNode[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null))).transform(n -> RefreshAction.getDatabaseSystem((DbSchemasTree.MyNode)this.myTreeEditor.getUserObject((TreeNode)n))).filter(LocalDataSource.class).unique().toList()).isEmpty() && this.myTreeEditor.canReintrospect(dataSources);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription(DatabaseBundle.message("action.DbSchemasSelector.refresh.schemas.list.description", enabled ? 0 : 1));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(2);
            }
            MultiMap objects = MultiMap.createLinked();
            JBIterable nodes2 = JBIterable.of((Object[])((CheckedTreeNode[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null))).transform(arg_0 -> ((TreeEditor)this.myTreeEditor).getUserObject(arg_0)).filter(Conditions.notNull());
            for (DbSchemasTree.MyNode node : nodes2) {
                LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)RefreshAction.getDatabaseSystem(node), LocalDataSource.class);
                if (ds == null) continue;
                ContainerUtil.addIfNotNull((Collection)objects.getModifiable((Object)ds), (Object)((BasicNamespace)ObjectUtils.tryCast((Object)node.getObject(), BasicNamespace.class)));
            }
            this.myTreeEditor.reintrospect((MultiMap<LocalDataSource, BasicNamespace>)objects);
        }

        @Nullable
        private static DasDataSource getDatabaseSystem(@Nullable DbSchemasTree.MyNode n) {
            return n == null ? null : (DasDataSource)JBIterable.generate((Object)n, DbSchemaNode::getParent).transform(DbSchemaNode::getObject).filter(DasDataSource.class).first();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector$RefreshAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector$RefreshAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

