/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 M2\u00020\u0001:\u0001MB.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0004J\b\u0010\"\u001a\u00020\tH\u0014J\b\u0010#\u001a\u00020$H$J\u000e\u0010%\u001a\u00020$H\u00a4@\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0004J\u0012\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010(H$J\n\u0010,\u001a\u0004\u0018\u00010-H\u0014J\b\u0010.\u001a\u00020-H\u0004J\u0006\u0010/\u001a\u00020\tJ\b\u00100\u001a\u00020 H\u0014J\b\u00101\u001a\u000202H\u0004J\b\u00103\u001a\u000202H\u0014J\u001e\u00104\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000202H\u0082@\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020 2\u0006\u0010\u0004\u001a\u000206H\u0084@\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020=H\u0084@\u00a2\u0006\u0002\u0010>J\u001e\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u0002062\u0006\u0010A\u001a\u000202H\u0086@\u00a2\u0006\u0002\u00108J\u0010\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u000206H\u0004J\b\u0010D\u001a\u0004\u0018\u00010\u0007J\u0010\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020CH\u0014J\u0010\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020IH\u0004J\u0010\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020JH\u0004J\u0006\u0010K\u001a\u00020 J\u0006\u0010L\u001a\u000202R\u0010\u0010\r\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u00158\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/view/ui/DatabaseScriptDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/RawDataSource;Lcom/intellij/database/util/SearchPath;Ljava/lang/String;)V", "myProject", "myDataSource", "getMyDataSource", "()Lcom/intellij/database/model/RawDataSource;", "mySearchPath", "getMySearchPath", "()Lcom/intellij/database/util/SearchPath;", "myPreviewPanel", "Lcom/intellij/database/view/ui/SqlPreviewComponent;", "myOptionsPanel", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "getMyOptionsPanel", "()Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "myLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "createPreviewActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "init", "", "applyOptions", "getDimensionServiceKey", "getTask", "Lcom/intellij/database/script/generator/ScriptingTask;", "applyAndGetTask", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "appendCodeStyle", "Lcom/intellij/database/script/generator/ScriptingOptions;", "op", "settingsChanged", "options", "createCenterPanel", "Ljavax/swing/JComponent;", "createTopComponent", "getStatement", "doOKAction", "isInstantClose", "", "perform", "performInDatabaseAndClose", "lds", "Lcom/intellij/database/dataSource/LocalDataSource;", "instantClose", "(Lcom/intellij/database/dataSource/LocalDataSource;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performInDatabase", "(Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateSqlDataSource", "ds", "Lcom/intellij/sql/database/SqlDataSource;", "(Lcom/intellij/sql/database/SqlDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runScript", "localDataSource", "nonModalSync", "createRefactoringHandler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "getSearchPath", "fillContext", "handler", "updateText", "script", "Lcom/intellij/database/script/generator/ScriptingResult;", "Lcom/intellij/database/model/properties/CompositeText;", "initAndShow", "initAndGet", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptDialog.kt\ncom/intellij/database/view/ui/DatabaseScriptDialog\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,302:1\n40#2,3:303\n40#2,3:306\n*S KotlinDebug\n*F\n+ 1 DatabaseScriptDialog.kt\ncom/intellij/database/view/ui/DatabaseScriptDialog\n*L\n156#1:303,3\n162#1:306,3\n*E\n"})
public abstract class DatabaseScriptDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project myProject;
    @NotNull
    private final RawDataSource myDataSource;
    @Nullable
    private final SearchPath mySearchPath;
    @JvmField
    @NotNull
    protected final SqlPreviewComponent myPreviewPanel;
    @NotNull
    private final ScriptOptionsPanel myOptionsPanel;
    @JvmField
    @NotNull
    protected final JBLoadingPanel myLoadingPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull RawDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(project);
        this.myProject = project;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        Project project2 = this.myProject;
        RawDataSource rawDataSource = this.myDataSource;
        SearchPath searchPath2 = this.mySearchPath;
        Runnable runnable = () -> DatabaseScriptDialog._init_$lambda$0(this);
        this.myPreviewPanel = new SqlPreviewComponent(project2, rawDataSource, searchPath2, runnable){

            @Override
            public List<AnAction> createActions(DasDataSource delegate) {
                Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
                List list = ContainerUtil.concat(this.createPreviewActions(), super.createActions(delegate));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
                return list;
            }
        };
        (this.myPreviewPanel).getEditor().setMinimumSize((Dimension)JBUI.size((int)120, (int)120));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), arg_0 -> DatabaseScriptDialog._init_$lambda$1(this, arg_0));
        EditorTextField editorTextField2 = (this.myPreviewPanel).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getEditor(...)");
        this.myLoadingPanel.add((Component)editorTextField2, (Object)"Center");
        this.myOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> DatabaseScriptDialog._init_$lambda$2(this)));
        this.setTitle(title);
    }

    @NotNull
    protected final RawDataSource getMyDataSource() {
        return this.myDataSource;
    }

    @Nullable
    protected final SearchPath getMySearchPath() {
        return this.mySearchPath;
    }

    @NotNull
    protected final ScriptOptionsPanel getMyOptionsPanel() {
        return this.myOptionsPanel;
    }

    @NotNull
    protected List<AnAction> createPreviewActions() {
        return new ArrayList();
    }

    protected void init() {
        super.init();
        ScriptingTask task = this.getTask();
        this.myOptionsPanel.adjustOptionsUI(task, task.getOptions());
    }

    protected final void applyOptions() {
        this.settingsChanged(this.appendCodeStyle(this.myOptionsPanel.gatherOptions()));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    protected abstract ScriptingTask getTask();

    @Nullable
    protected abstract Object applyAndGetTask(@NotNull Continuation<? super ScriptingTask> var1);

    @NotNull
    protected final ScriptingOptions appendCodeStyle(@NotNull ScriptingOptions op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        CodeStyleSettings style = ScriptingTaskBuilderKt.getCodeStyle(this.myDataSource);
        DelegateScriptingOptions res2 = new DelegateScriptingOptions(op);
        res2.set(ScriptingOptionStatic.CODE_STYLE, style);
        return res2;
    }

    protected abstract void settingsChanged(@Nullable ScriptingOptions var1);

    @Nullable
    protected JComponent createCenterPanel() {
        ShutSplitter shutSplitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message("separator.preview", new Object[0]), this.createTopComponent(), (JComponent)this.myLoadingPanel, this.getDimensionServiceKey(), 0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)shutSplitter), (String)"createHideableSplitter(...)");
        ShutSplitter splitter = shutSplitter;
        splitter.setTrailWidget(this.myPreviewPanel.createToolbar());
        return (JComponent)((Object)splitter);
    }

    @NotNull
    protected final JComponent createTopComponent() {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myOptionsPanel.getComponent(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane pane = jScrollPane;
        pane.setMinimumSize((Dimension)JBUI.size((int)300, (int)50));
        return pane;
    }

    @NotNull
    public final String getStatement() {
        String string = this.myPreviewPanel.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        return string;
    }

    protected void doOKAction() {
        if (!this.perform()) {
            return;
        }
        super.doOKAction();
    }

    protected final boolean isInstantClose() {
        return true;
    }

    protected boolean perform() {
        boolean instantClose = this.isInstantClose();
        RawDataSource ds = this.myDataSource;
        if (ds instanceof LocalDataSource) {
            boolean $i$f$service = false;
            Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((DbScopeProvider)object).launchWithModality(CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ds, instantClose, null){
                int label;
                final /* synthetic */ DatabaseScriptDialog this$0;
                final /* synthetic */ RawDataSource $ds;
                final /* synthetic */ boolean $instantClose;
                {
                    this.this$0 = $receiver;
                    this.$ds = $ds;
                    this.$instantClose = $instantClose;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DatabaseScriptDialog.access$performInDatabaseAndClose(this.this$0, (LocalDataSource)this.$ds, this.$instantClose, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return instantClose;
        }
        if (ds instanceof SqlDataSource) {
            boolean $i$f$service = false;
            Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((DbScopeProvider)object).launchWithModality(CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ds, instantClose, null){
                int label;
                final /* synthetic */ DatabaseScriptDialog this$0;
                final /* synthetic */ RawDataSource $ds;
                final /* synthetic */ boolean $instantClose;
                {
                    this.this$0 = $receiver;
                    this.$ds = $ds;
                    this.$instantClose = $instantClose;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.this$0.updateSqlDataSource((SqlDataSource)this.$ds, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!this.$instantClose) {
                                this.this$0.close(0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return instantClose;
        }
        return true;
    }

    private final Object performInDatabaseAndClose(LocalDataSource lds, boolean instantClose, Continuation<? super Unit> $completion) {
        ProgressWindow progressWindow;
        String string = this.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
        if (instantClose) {
            ProgressIndicatorEx progressIndicatorEx = AsyncUtil.createBackgroundIndicator(this.myProject, frame.getName(), true);
            Intrinsics.checkNotNull((Object)progressIndicatorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.util.ProgressWindow");
            progressWindow = (ProgressWindow)progressIndicatorEx;
        } else {
            progressWindow = new ProgressWindow(true, this.myProject);
        }
        ProgressWindow window = progressWindow;
        AsyncTask.Companion.withIndicator(frame, (ProgressIndicator)window);
        window.setTitle(frame.getName());
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)frame.getElement()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lds, instantClose, null){
            int label;
            final /* synthetic */ DatabaseScriptDialog this$0;
            final /* synthetic */ LocalDataSource $lds;
            final /* synthetic */ boolean $instantClose;
            {
                this.this$0 = $receiver;
                this.$lds = $lds;
                this.$instantClose = $instantClose;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.this$0.performInDatabase(this.$lds, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!this.$instantClose) {
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ DatabaseScriptDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.this$0.close(0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected final Object performInDatabase(@NotNull LocalDataSource dataSource, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.runScript(dataSource, false, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected final Object updateSqlDataSource(@NotNull SqlDataSource ds, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ds, null){
            Object L$0;
            int label;
            final /* synthetic */ DatabaseScriptDialog this$0;
            final /* synthetic */ SqlDataSource $ds;
            {
                this.this$0 = $receiver;
                this.$ds = $ds;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.this$0.applyAndGetTask((Continuation<? super ScriptingTask>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        task = (ScriptingTask)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)task);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends VirtualFile>>, Object>(task, this.this$0, this.$ds, null){
                            int label;
                            final /* synthetic */ ScriptingTask $task;
                            final /* synthetic */ DatabaseScriptDialog this$0;
                            final /* synthetic */ SqlDataSource $ds;
                            {
                                this.$task = $task;
                                this.this$0 = $receiver;
                                this.$ds = $ds;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        ScriptingSingleModelTaskBuilder builder = DatabaseScriptDialog.Companion.prepareCreationTask(this.$task);
                                        return DumpToDdlDataSourceActionKt.expandAndDump(this.this$0.myProject, this.$ds, builder.getModel(), null, (Iterable<? extends BasicElement>)builder.getElements(), false);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Set<? extends VirtualFile>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        task = (ScriptingTask)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        files = (Set)v1;
                        DumpToDdlDataSourceActionKt.selectFile(this.this$0.myProject, files);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object runScript(@NotNull LocalDataSource localDataSource, boolean nonModalSync, @NotNull Continuation<? super Unit> $completion) {
        String statement2 = this.getStatement();
        if (((CharSequence)statement2).length() == 0) {
            return Unit.INSTANCE;
        }
        DatabaseRefactoringHandler handler2 = this.createRefactoringHandler(localDataSource).setStatement(statement2);
        this.fillContext(handler2);
        Object object = handler2.runStatements(nonModalSync, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected final DatabaseRefactoringHandler createRefactoringHandler(@NotNull LocalDataSource localDataSource) {
        Intrinsics.checkNotNullParameter((Object)localDataSource, (String)"localDataSource");
        return new DatabaseRefactoringHandler(this.myProject, localDataSource, this.mySearchPath);
    }

    @Nullable
    public final SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
    }

    protected final void updateText(@NotNull ScriptingResult script2) {
        Intrinsics.checkNotNullParameter((Object)script2, (String)"script");
        this.updateText(script2.getScript());
    }

    protected final void updateText(@NotNull CompositeText script2) {
        Intrinsics.checkNotNullParameter((Object)script2, (String)"script");
        this.myPreviewPanel.setQuery(script2);
    }

    public final void initAndShow() {
        this.init();
        this.show();
    }

    public final boolean initAndGet() {
        this.init();
        return this.showAndGet();
    }

    private static final void _init_$lambda$0(DatabaseScriptDialog this$0) {
        this$0.close(1);
    }

    private static final LoadingDecorator _init_$lambda$1(DatabaseScriptDialog this$0, JPanel panel2) {
        JComponent jComponent = panel2;
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        return new LoadingDecorator(jComponent, disposable, 100, true, null, 16, null);
    }

    private static final Unit _init_$lambda$2(DatabaseScriptDialog this$0) {
        this$0.applyOptions();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$performInDatabaseAndClose(DatabaseScriptDialog $this, LocalDataSource lds, boolean instantClose, Continuation $completion) {
        return $this.performInDatabaseAndClose(lds, instantClose, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ$\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/ui/DatabaseScriptDialog$Companion;", "", "<init>", "()V", "showSettingsPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "callback", "Ljava/util/function/Consumer;", "Lcom/intellij/database/script/generator/ScriptingOptions;", "createSettingsPopupAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "Ljava/util/function/Supplier;", "prepareCreationTask", "Lcom/intellij/database/script/generator/ScriptingSingleModelTaskBuilder;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBPopup showSettingsPopup(@NotNull ScriptingTask task, @NotNull Consumer<ScriptingOptions> callback) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            Ref ref2 = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
            Ref panel2 = ref2;
            panel2.set((Object)new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> Companion.showSettingsPopup$lambda$0(callback, panel2))));
            ((ScriptOptionsPanel)panel2.get()).adjustOptionsUI(task, task.getOptions());
            JComponent component = ((ScriptOptionsPanel)panel2.get()).getComponent();
            UIUtil.addInsets((JComponent)component, (Insets)UIUtil.PANEL_REGULAR_INSETS);
            JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, component).setRequestFocus(true).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
            return jBPopup;
        }

        @NotNull
        public final AnAction createSettingsPopupAction(@NotNull Supplier<? extends ScriptingTask> task, @NotNull Consumer<ScriptingOptions> callback) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            Supplier<String> supplier = DatabaseBundle.messagePointer("action.DatabaseScriptDialog.settings.text", new Object[0]);
            Supplier supplier2 = Presentation.NULL_STRING;
            Icon icon = AllIcons.General.GearPlain;
            return (AnAction)new ActionGroup(task, callback, supplier, supplier2, icon){
                final /* synthetic */ Supplier<? extends ScriptingTask> $task;
                final /* synthetic */ Consumer<ScriptingOptions> $callback;
                {
                    this.$task = $task;
                    this.$callback = $callback;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    this.setPopup(true);
                    this.getTemplatePresentation().setPerformGroup(true);
                    this.getTemplatePresentation().setDisableGroupIfEmpty(false);
                }

                public boolean isDumbAware() {
                    return true;
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ScriptingTask scriptingTask = this.$task.get();
                    Intrinsics.checkNotNullExpressionValue((Object)scriptingTask, (String)"get(...)");
                    JBPopup popup2 = DatabaseScriptDialog.Companion.showSettingsPopup(scriptingTask, this.$callback);
                    DbUIUtil.showPopup(popup2, null, e);
                }

                public AnAction[] getChildren(AnActionEvent e) {
                    Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return ActionGroup.EMPTY_ARRAY;
                }
            };
        }

        @NotNull
        public final ScriptingSingleModelTaskBuilder prepareCreationTask(@NotNull ScriptingTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            ScriptingSingleModelTaskBuilder builder = null;
            if (task instanceof ScriptingSingleModelTask) {
                builder = new ScriptingSingleModelTaskBuilder(((ScriptingSingleModelTask)task).getModel(), ScriptCategory.CREATE_COMPLETE);
                builder.getElements().clear();
                builder.getElements().addAll(((ScriptingSingleModelTask)task).getElements());
            } else {
                ScriptingAlterTask t = (ScriptingAlterTask)task;
                builder = new ScriptingSingleModelTaskBuilder(t.getTargetModel(), ScriptCategory.CREATE_COMPLETE);
                Collection collection = JBIterable.from((Iterable)t.getCorrespondence()).filterMap(arg_0 -> Companion.prepareCreationTask$lambda$1((Function1)prepareCreationTask.1.INSTANCE, arg_0)).addAllTo(builder.getElements());
                Intrinsics.checkNotNull((Object)collection);
            }
            return builder;
        }

        private static final Unit showSettingsPopup$lambda$0(Consumer $callback, Ref $panel) {
            $callback.accept(((ScriptOptionsPanel)$panel.get()).gatherOptions());
            return Unit.INSTANCE;
        }

        private static final BasicElement prepareCreationTask$lambda$1(Function1 $tmp0, Object p0) {
            return (BasicElement)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

