/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingConfigurable;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DataSourceSidePanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseConfigSideTab {
    public static final JBColor DIM_GREEN = new JBColor(JBColor.GREEN.darker().darker(), (Color)JBColor.GREEN);
    static final DataKey<DatabaseConfigSideTab> SIDE_PANEL = DataKey.create((String)"SIDE_PANEL");
    protected final Map<Object, SidePanelItem<?, ?>> mySidePanelItems;
    protected final DataSourceSidePanel mySidePanel;
    @NlsContexts.TabTitle
    private final String myName;
    protected final DatabaseConfigEditorImpl myEditor;
    private final JComponent myComponent;
    protected final List<Object> myRemovedObjects;

    public DatabaseConfigSideTab(@NlsContexts.TabTitle @NotNull String name2, @NotNull DatabaseConfigEditorImpl editor2) {
        if (name2 == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(1);
        }
        this.mySidePanelItems = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        this.myRemovedObjects = new ArrayList<Object>();
        this.myName = name2;
        this.myEditor = editor2;
        this.mySidePanel = this.createSidePanel();
        DefaultActionGroup left = new DefaultActionGroup();
        DefaultActionGroup right = new DefaultActionGroup();
        DefaultActionGroup context = new DefaultActionGroup();
        this.configureActionGroups(left, right, context, this.mySidePanel.getList());
        this.myComponent = UiDataProvider.wrapComponent((JComponent)DatabaseConfigSideTab.configureSidePanel(this.mySidePanel, left, right, context), sink -> sink.set(SIDE_PANEL, (Object)this));
    }

    abstract void configureActionGroups(DefaultActionGroup var1, DefaultActionGroup var2, DefaultActionGroup var3, JList<?> var4);

    public abstract void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings var1, boolean var2);

    public abstract boolean isMine(Object var1);

    @NotNull
    private static JComponent configureSidePanel(DataSourceSidePanel sidePanel, DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup contextMenu) {
        JList<Place> target2 = sidePanel.getList();
        JPanel toolbarsPanel = new JPanel(new BorderLayout());
        toolbarsPanel.add((Component)DatabaseConfigSideTab.createToolbarComponent(target2, (ActionGroup)left), "Center");
        toolbarsPanel.add((Component)DatabaseConfigSideTab.createToolbarComponent(target2, (ActionGroup)right), "East");
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)toolbarsPanel, "North");
        result2.add((Component)sidePanel.getComponent(), "Center");
        PopupHandler.installPopupMenu(target2, (ActionGroup)contextMenu, (String)"DatabaseConfigSideTabPopup");
        JPanel jPanel = result2;
        if (jPanel == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createToolbarComponent(@NotNull JComponent target2, @NotNull ActionGroup actions) {
        if (target2 == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(3);
        }
        if (actions == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(4);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", actions, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent(target2);
        JComponent component = toolbar.getComponent();
        component.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JComponent jComponent = component;
        if (jComponent == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    void remove(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(6);
        }
        this.myRemovedObjects.add(item.getObject());
        this.ensureNewObjectDropped(item.getObject());
    }

    void undelete(@NotNull Object object) {
        if (object == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(7);
        }
        this.myRemovedObjects.remove(object);
    }

    boolean isRemoved(@NotNull Object object) {
        if (object == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(8);
        }
        return this.myRemovedObjects.contains(object);
    }

    @NotNull
    DataSourceSidePanel createSidePanel() {
        DataSourceSidePanel panel2 = new DataSourceSidePanel(new MyComponentConfigurator(), (Function<Place, String>)((Function)place -> {
            SidePanelItem<?, ?> item = SidePanelItem.getItem(place);
            return item == null ? null : item.getName();
        }));
        panel2.getList().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object o = ((JList)e.getSource()).getSelectedValue();
            Object object = SidePanelItem.getObject(SidePanelItem.getItem((Place)ObjectUtils.tryCast(o, Place.class)));
            this.myEditor.navigateTo(object, false);
        });
        DataSourceSidePanel dataSourceSidePanel = panel2;
        if (dataSourceSidePanel == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(9);
        }
        return dataSourceSidePanel;
    }

    abstract boolean canRemove(@NotNull SidePanelItem<?, ?> var1);

    public void onApply() throws ConfigurationException {
        DatabaseConfigEditor.Listener publisher = (DatabaseConfigEditor.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseConfigEditor.TOPIC);
        for (SidePanelItem item : ContainerUtil.newArrayList(this.getSidePanelItems())) {
            boolean created = this.isObjectCreated(item);
            if (!item.isModified() && !created) continue;
            item.apply();
            if (created) {
                this.ensureNewObjectDropped(item.getObject());
            }
            publisher.applied(item.getObject(), created);
        }
        Iterator<Object> it = this.myRemovedObjects.iterator();
        while (it.hasNext()) {
            this.removeObject(it.next());
            it.remove();
        }
    }

    protected abstract void ensureNewObjectDropped(Object var1);

    protected abstract void removeObject(Object var1);

    public boolean isAnyEditorModified() {
        if (!this.myRemovedObjects.isEmpty()) {
            return true;
        }
        return !ContainerUtil.process(this.getSidePanelItems(), item -> !this.isObjectModified((SidePanelItem<?, ?>)item));
    }

    public boolean isObjectModified(@Nullable SidePanelItem<?, ?> item) {
        return this.isObjectCreated(item) || item != null && item.isModified();
    }

    public boolean isObjectCreated(@Nullable SidePanelItem<?, ?> item) {
        if (item == null) {
            return false;
        }
        final Ref result2 = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result2.set((Object)DatabaseConfigSideTab.this.myEditor.getSettings().newDataSources.contains(dataSourceItem.getObject()));
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                result2.set((Object)DatabaseConfigSideTab.this.myEditor.getSettings().newDrivers.contains(driverItem.getObject()));
                return true;
            }

            @Override
            boolean visit(SidePanelItem.MappingItem mappingItem) {
                result2.set((Object)DatabaseConfigSideTab.this.myEditor.getSettings().newMappings.contains(mappingItem.getObject()));
                return true;
            }
        });
        return (Boolean)result2.get();
    }

    @NotNull
    public SidePanelItem<?, ?> addToSidePanel(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(10);
        }
        Place place = item.createPlace();
        this.mySidePanel.addPlace(place);
        SidePanelItem<?, ?> sidePanelItem = item;
        if (sidePanelItem == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(11);
        }
        return sidePanelItem;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JList<Place> getList() {
        return this.mySidePanel.getList();
    }

    public void resetSelection() {
        this.mySidePanel.resetSelection();
    }

    public void select(@Nullable Place place) {
        this.mySidePanel.select(place);
    }

    public void revalidate() {
        this.mySidePanel.getList().revalidate();
        this.mySidePanel.getList().repaint();
    }

    @NlsContexts.TabTitle
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public SidePanelItem<?, ?> getSidePanelItem(@Nullable Object key2) {
        return this.mySidePanelItems.get(key2);
    }

    @Nullable
    public Place getPlace(@Nullable Object object) {
        SidePanelItem<?, ?> item = this.getSidePanelItem(object);
        return item == null ? null : item.getPlace();
    }

    @Nullable
    public SidePanelItem<?, ?> getItem(@Nullable Place place) {
        SidePanelItem<?, ?> item = SidePanelItem.getItem(place);
        if (item != null) {
            item = this.getSidePanelItem(item.getObject());
        }
        return item;
    }

    protected <I extends SidePanelItem<?, ?>> I createItem(@NotNull I item) {
        if (item == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(13);
        }
        this.mySidePanelItems.put(item.getObject(), item);
        this.myEditor.ensureErrorProviderExistence(item);
        return item;
    }

    @NotNull
    public Iterable<SidePanelItem<?, ?>> getSidePanelItems() {
        Collection<SidePanelItem<?, ?>> collection = this.mySidePanelItems.values();
        if (collection == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public void removeSidePanelItem(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(15);
        }
        SidePanelItem<?, ?> old2 = this.mySidePanelItems.remove(item.getObject());
        item.removeConfigurable();
        this.myEditor.myErrorsCollector.remove(item);
        assert (old2 == item);
    }

    public void disposeUi() {
        for (SidePanelItem<?, ?> item : new ArrayList(this.mySidePanelItems.values())) {
            this.removeSidePanelItem(item);
        }
    }

    @NotNull
    JBIterable<SidePanelItem<?, ?>> getSelectedItems() {
        JBIterable jBIterable = JBIterable.from(this.mySidePanel.getList().getSelectedValuesList()).filterMap(place -> SidePanelItem.getItem(place));
        if (jBIterable == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    void restoreSelection(@NotNull Set<SidePanelItem<?, ?>> sel) {
        if (sel == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(17);
        }
        IntArrayList newSelection = new IntArrayList(sel.size());
        int count = this.mySidePanel.getList().getModel().getSize();
        for (int i2 = 0; i2 < count; ++i2) {
            SidePanelItem<?, ?> item = this.getItem(this.mySidePanel.getList().getModel().getElementAt(i2));
            if (!sel.contains(item)) continue;
            newSelection.add(i2);
        }
        this.mySidePanel.getList().setSelectedIndices(newSelection.toIntArray());
    }

    public void removeSelection(@NotNull List<SidePanelItem<?, ?>> items) {
        if (items == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(18);
        }
        JList<Place> list = this.getList();
        int index = list.getSelectionModel().getMinSelectionIndex();
        for (SidePanelItem<?, ?> item : items) {
            if (!this.canRemove(item)) continue;
            this.remove(item);
        }
        this.myEditor.refillSidePanel(this.myEditor.getSettings(), false);
        index = Math.max(0, Math.min(list.getModel().getSize() - 2, index));
        list.getSelectionModel().setSelectionInterval(index, index);
    }

    public abstract void copy(@NotNull SidePanelItem<?, ?> var1);

    public abstract boolean canCopy(@NotNull SidePanelItem<?, ?> var1);

    @NotNull
    protected <T, S extends SidePanelItem<? extends T, ?>> List<List<S>> sectionize(Collection<T> allItems, Function<? super T, ? extends S> factory, Function<? super S, Integer> sectionMapper) {
        ArrayList<List<S>> items = new ArrayList<List<S>>();
        for (T item : allItems) {
            SidePanelItem res2 = (SidePanelItem)factory.fun(item);
            int sec = (Integer)sectionMapper.fun((Object)res2);
            while (items.size() <= sec) {
                items.add(new ArrayList());
            }
            ((List)items.get(sec)).add(res2);
        }
        ArrayList<List<S>> arrayList = items;
        if (arrayList == null) {
            DatabaseConfigSideTab.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 11, 12, 14, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigSideTab";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigSideTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "configureSidePanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSidePanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addToSidePanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSidePanelItems";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sectionize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "undelete";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRemoved";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToSidePanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeSidePanelItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "restoreSelection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 11, 12, 14, 16, 19 -> new IllegalStateException(string);
        };
    }

    private class MyComponentConfigurator
    implements DataSourceSidePanel.ComponentConfigurator {
        private final Map<Icon, Icon> myCache = new HashMap<Icon, Icon>();

        private MyComponentConfigurator() {
        }

        @Nullable
        private Icon getGrayIcon(@Nullable Icon icon) {
            return icon == null ? null : this.myCache.computeIfAbsent(icon, IconUtil::desaturate);
        }

        @Override
        public void configure(final @NotNull SimpleColoredComponent component, @NotNull Place place, boolean isSelected) {
            int style;
            boolean hasHints;
            SidePanelItem<?, ?> item;
            if (component == null) {
                MyComponentConfigurator.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyComponentConfigurator.$$$reportNull$$$0(1);
            }
            if ((item = SidePanelItem.getItem(place)) == null) {
                return;
            }
            boolean created = DatabaseConfigSideTab.this.isObjectCreated(item);
            boolean modified = created || DatabaseConfigSideTab.this.isObjectModified(item);
            JBIterable problems = JBIterable.from(DatabaseConfigSideTab.this.myEditor.myErrorsCollector.getProblems(item));
            boolean darcula = StartupUiUtil.isUnderDarcula();
            Object fgColor = isSelected ? NamedColorUtil.getListSelectionForeground((boolean)true) : (created ? DIM_GREEN : (modified ? JBColor.BLUE : component.getForeground()));
            boolean hasErrors = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.ERROR).isEmpty();
            boolean hasWarnings = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.WARNING).isEmpty();
            boolean bl = hasHints = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.HINT).isEmpty();
            int n = hasErrors ? 8 : (hasWarnings ? 8 : (style = hasHints ? 32 : 0));
            JBColor color = hasErrors ? JBColor.RED : (hasWarnings ? DbUIUtil.WARNING : (darcula ? JBColor.LIGHT_GRAY.brighter() : JBColor.LIGHT_GRAY));
            SimpleTextAttributes textAttributes = new SimpleTextAttributes(style, (Color)fgColor, (Color)color);
            String name2 = item.getName();
            if (name2 != null) {
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name2, (SimpleColoredComponent)component, (SimpleTextAttributes)textAttributes, (Matcher)DatabaseConfigSideTab.this.mySidePanel.getSpeedSearchMatcher(), (Color)UIUtil.getTreeSelectionBackground((boolean)true), (boolean)isSelected);
            }
            component.setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)16)));
            item.accept(new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    component.setIcon(((DbDataSourceImpl)dataSourceItem.getObject()).getIcon(true));
                    @NlsSafe String comment = ((DbDataSourceImpl)dataSourceItem.getObject()).getComment();
                    if (StringUtil.isNotEmpty((String)comment)) {
                        component.setToolTipText(StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true));
                    }
                    return true;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DatabaseDriver)driverItem.getObject()).getIcon(0)));
                    return true;
                }

                @Override
                boolean visit(SidePanelItem.MappingItem mappingItem) {
                    DdlMapping mp = (DdlMapping)mappingItem.getObject();
                    DdlMappingConfigurable c2 = (DdlMappingConfigurable)mappingItem.getConfigurable();
                    Icon icon = c2 == null ? DdlMappingConfigurable.getIcon(mappingItem.myEditor, mp.getDataSourceId(), mp.getDdlDataSourceId()) : c2.getIcon();
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(icon));
                    return true;
                }
            });
        }

        @Override
        public void updateCount(@NotNull SidePanelCountLabel count, @NotNull Place place) {
            SidePanelItem.ErrorsItem item;
            if (count == null) {
                MyComponentConfigurator.$$$reportNull$$$0(2);
            }
            if (place == null) {
                MyComponentConfigurator.$$$reportNull$$$0(3);
            }
            count.setVisible((item = (SidePanelItem.ErrorsItem)ObjectUtils.tryCast(SidePanelItem.getItem(place), SidePanelItem.ErrorsItem.class)) != null && ((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount() > 0);
            if (item != null) {
                count.setText(String.valueOf(((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "count";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigSideTab$MyComponentConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.reset.changes.text", new Object[0]), DatabaseBundle.message("action.DatabaseConfigEditor.reset.modifications.to.item.description", new Object[0]), AllIcons.Actions.Rollback);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ResetAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetAction.$$$reportNull$$$0(1);
            }
            DatabaseConfigSideTab sidePanel = (DatabaseConfigSideTab)e.getData(SIDE_PANEL);
            boolean modified = false;
            if (sidePanel != null) {
                for (SidePanelItem item : sidePanel.getSelectedItems()) {
                    if (!item.isModified()) continue;
                    modified = true;
                    break;
                }
            }
            e.getPresentation().setEnabled(modified);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DatabaseConfigSideTab sidePanel;
            if (e == null) {
                ResetAction.$$$reportNull$$$0(2);
            }
            if ((sidePanel = (DatabaseConfigSideTab)e.getData(SIDE_PANEL)) == null) {
                return;
            }
            for (SidePanelItem item : sidePanel.getSelectedItems()) {
                if (!item.isModified()) continue;
                item.reset();
            }
            DatabaseConfigEditorImpl editor2 = sidePanel.myEditor;
            editor2.refillSidePanel(editor2.getSettings(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigSideTab$ResetAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigSideTab$ResetAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static class CopyAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        CopyAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.duplicate.text", new Object[0]), null, PlatformIcons.COPY_ICON);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DatabaseConfigSideTab sideTab;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            if ((sideTab = (DatabaseConfigSideTab)e.getData(SIDE_PANEL)) == null) {
                return;
            }
            SidePanelItem item = (SidePanelItem)sideTab.getSelectedItems().single();
            if (item == null) {
                return;
            }
            sideTab.copy(item);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            DatabaseConfigSideTab sideTab;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(3);
            }
            SidePanelItem item = (sideTab = (DatabaseConfigSideTab)e.getData(SIDE_PANEL)) == null ? null : (SidePanelItem)sideTab.getSelectedItems().single();
            return item != null && sideTab.canCopy(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigSideTab$CopyAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigSideTab$CopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static final class RemoveAction
    extends DumbAwareAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        RemoveAction() {
            super(DatabaseBundle.message("action.remove.text", new Object[0]), null, IconUtil.getRemoveIcon());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void run(AnActionButton button) {
            this.run(button.getDataContext());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(1);
            }
            this.run(e.getDataContext());
        }

        public void run(DataContext dataContext) {
            DatabaseConfigSideTab sidePanel = (DatabaseConfigSideTab)dataContext.getData(SIDE_PANEL);
            if (sidePanel == null) {
                return;
            }
            sidePanel.removeSelection(sidePanel.getSelectedItems().toList());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(2);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            DatabaseConfigSideTab sidePanel;
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(3);
            }
            if ((sidePanel = (DatabaseConfigSideTab)e.getData(SIDE_PANEL)) == null) {
                return false;
            }
            Set selection = sidePanel.getSelectedItems().toSet();
            for (SidePanelItem item : selection) {
                if (sidePanel.canRemove(item)) continue;
                return false;
            }
            return !selection.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigSideTab$RemoveAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigSideTab$RemoveAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

