/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.util.common.BooleanFalseVal;
import com.intellij.database.util.common.BooleanHolder;
import com.intellij.database.util.common.BooleanTrueVal;
import com.intellij.database.util.common.BooleanVal;
import com.intellij.database.util.common.BooleanVar;
import com.intellij.database.view.TreeFilterModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.FieldInplaceActionButtonLook;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u0000 S2\u00020\u0001:\u0004PQRSB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u00106\u001a\u001407R\u0010\u0012\f\u0012\n 0*\u0004\u0018\u00010\u00030\u0003082\b\u00109\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020;H\u0014J\n\u0010?\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010@\u001a\u00020;2\u0006\u0010A\u001a\u00020%H\u0002J\u0018\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020\t2\u0006\u0010A\u001a\u00020%H\u0002J\u0010\u0010D\u001a\u00020;2\u0006\u0010C\u001a\u00020\tH\u0002J\b\u0010E\u001a\u00020;H\u0002J\u0010\u0010F\u001a\u00020;2\u0006\u0010G\u001a\u00020%H\u0002J\u0010\u0010H\u001a\u00020;2\u0006\u0010G\u001a\u00020%H\u0002J\u001d\u0010I\u001a\u00020;2\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010KH\u0002\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020;H\u0002J\b\u0010N\u001a\u00020;H\u0002J\b\u0010O\u001a\u00020%H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR'\u0010\u001d\u001a\u000f\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u001f\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R\u0014\u0010,\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010'R\u0016\u0010.\u001a\n 0*\u0004\u0018\u00010/0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0018\u000104R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/database/view/TreeFilterSearch;", "Lcom/intellij/ui/TreeSpeedSearch;", "tree", "Ljavax/swing/JTree;", "filterModel", "Lcom/intellij/database/view/TreeFilterModel;", "presentableStringFunction", "Ljava/util/function/Function;", "Ljavax/swing/tree/TreePath;", "", "<init>", "(Ljavax/swing/JTree;Lcom/intellij/database/view/TreeFilterModel;Ljava/util/function/Function;)V", "getTree", "()Ljavax/swing/JTree;", "filterIsEnabledCheck", "Lcom/intellij/database/util/common/BooleanVal;", "getFilterIsEnabledCheck", "()Lcom/intellij/database/util/common/BooleanVal;", "setFilterIsEnabledCheck", "(Lcom/intellij/database/util/common/BooleanVal;)V", "filterIsStickyCheck", "getFilterIsStickyCheck", "setFilterIsStickyCheck", "stickyStateHolder", "Lcom/intellij/database/util/common/BooleanVar;", "getStickyStateHolder", "()Lcom/intellij/database/util/common/BooleanVar;", "setStickyStateHolder", "(Lcom/intellij/database/util/common/BooleanVar;)V", "nothingFoundTextProvider", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "getNothingFoundTextProvider", "()Ljava/util/function/Supplier;", "setNothingFoundTextProvider", "(Ljava/util/function/Supplier;)V", "enabled", "", "getEnabled", "()Z", "sticky", "getSticky", "startingFilterBySlash", "getStartingFilterBySlash", "startingFilterAuto", "getStartingFilterAuto", "templateAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "filtering", "startedBySlash", "popup", "Lcom/intellij/database/view/TreeFilterSearch$Popup;", "oldEmptyText", "createPopup", "Lcom/intellij/ui/SpeedSearchBase$SearchPopup;", "Lcom/intellij/ui/SpeedSearchBase;", "s", "processKeyEvent", "", "e", "Ljava/awt/event/KeyEvent;", "fireStateChanged", "getInput", "startFilteringIfPossible", "byKey", "startFiltering", "input", "continueFiltering", "pauseFiltering", "stopFilteringIfNeeded", "preserveSticky", "stopFiltering", "restoreSelections", "selections", "", "([Ljavax/swing/tree/TreePath;)V", "adjustEmptyText", "restoreEmptyText", "keepEvenWhenFocusLost", "FilterAction", "FilterActionButton", "Popup", "Companion", "intellij.database.impl"})
public final class TreeFilterSearch
extends TreeSpeedSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTree tree;
    @NotNull
    private final TreeFilterModel filterModel;
    @NotNull
    private BooleanVal filterIsEnabledCheck;
    @NotNull
    private BooleanVal filterIsStickyCheck;
    @NotNull
    private BooleanVar stickyStateHolder;
    @Nullable
    private Supplier<String> nothingFoundTextProvider;
    private final AnAction templateAction;
    private boolean filtering;
    private boolean startedBySlash;
    @Nullable
    private Popup popup;
    @Nullable
    private String oldEmptyText;
    @NotNull
    private static final FieldInplaceActionButtonLook FIELD_INPLACE_LOOK = new FieldInplaceActionButtonLook();
    @NotNull
    private static final BooleanHolder internalStickyStateHolder = new BooleanHolder(false, 1, null);
    @NotNull
    private static final Icon funnelIconLightNormal;
    @NotNull
    private static final Icon funnelIconLightHover;
    @NotNull
    private static final Icon funnelIconLightActive;
    @NotNull
    private static final Icon funnelIconDarkNormal;
    @NotNull
    private static final Icon funnelIconDarkHover;
    @NotNull
    private static final Icon funnelIconDarkActive;

    private TreeFilterSearch(JTree tree2, TreeFilterModel filterModel, Function<? super TreePath, String> presentableStringFunction) {
        super(tree2, false, null, presentableStringFunction);
        this.tree = tree2;
        this.filterModel = filterModel;
        this.filterIsEnabledCheck = BooleanTrueVal.INSTANCE;
        this.filterIsStickyCheck = BooleanFalseVal.INSTANCE;
        this.stickyStateHolder = internalStickyStateHolder;
        this.templateAction = ActionManager.getInstance().getAction("DatabaseView.Filter");
    }

    @NotNull
    public final JTree getTree() {
        return this.tree;
    }

    @NotNull
    public final BooleanVal getFilterIsEnabledCheck() {
        return this.filterIsEnabledCheck;
    }

    public final void setFilterIsEnabledCheck(@NotNull BooleanVal booleanVal) {
        Intrinsics.checkNotNullParameter((Object)booleanVal, (String)"<set-?>");
        this.filterIsEnabledCheck = booleanVal;
    }

    @NotNull
    public final BooleanVal getFilterIsStickyCheck() {
        return this.filterIsStickyCheck;
    }

    public final void setFilterIsStickyCheck(@NotNull BooleanVal booleanVal) {
        Intrinsics.checkNotNullParameter((Object)booleanVal, (String)"<set-?>");
        this.filterIsStickyCheck = booleanVal;
    }

    @NotNull
    public final BooleanVar getStickyStateHolder() {
        return this.stickyStateHolder;
    }

    public final void setStickyStateHolder(@NotNull BooleanVar booleanVar) {
        Intrinsics.checkNotNullParameter((Object)booleanVar, (String)"<set-?>");
        this.stickyStateHolder = booleanVar;
    }

    @Nullable
    public final Supplier<String> getNothingFoundTextProvider() {
        return this.nothingFoundTextProvider;
    }

    public final void setNothingFoundTextProvider(@Nullable Supplier<String> supplier) {
        this.nothingFoundTextProvider = supplier;
    }

    private final boolean getEnabled() {
        return this.filterIsEnabledCheck.getValue();
    }

    private final boolean getSticky() {
        return this.filterIsStickyCheck.getValue();
    }

    private final boolean getStartingFilterBySlash() {
        return this.getEnabled();
    }

    private final boolean getStartingFilterAuto() {
        return this.getEnabled() && this.getSticky() && this.stickyStateHolder.getValue();
    }

    @NotNull
    protected SpeedSearchBase.SearchPopup createPopup(@Nullable String s) {
        Popup popup2;
        this.popup = popup2 = new Popup(s);
        return popup2;
    }

    protected void processKeyEvent(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e.getKeyCode() != 47 && e.getKeyChar() != '/' || e.isShiftDown())) {
            if (this.getStartingFilterBySlash() && !this.filtering) {
                this.startFilteringIfPossible(true);
                e.consume();
            } else if (this.startedBySlash) {
                e.consume();
            } else {
                super.processKeyEvent(e);
            }
        } else if (this.filtering && e.getKeyCode() == 27) {
            if (this.startedBySlash) {
                this.stopFiltering(false);
                e.consume();
            } else {
                this.stopFiltering(this.getSticky());
                super.processKeyEvent(e);
            }
        } else {
            if (!this.filtering && this.getStartingFilterAuto()) {
                this.startFilteringIfPossible(false);
            }
            super.processKeyEvent(e);
        }
    }

    protected void fireStateChanged() {
        if (!this.filtering) {
            if (this.getStartingFilterAuto()) {
                String string = this.getInput();
                if (string == null) {
                    return;
                }
                String input = string;
                this.startFiltering(input, false);
            }
        } else {
            String input = this.getInput();
            if (input != null) {
                this.continueFiltering(input);
            } else if (this.startedBySlash) {
                this.stopFiltering(false);
            } else {
                this.pauseFiltering();
            }
        }
        super.fireStateChanged();
    }

    private final String getInput() {
        return StringKt.nullize((String)this.getEnteredPrefix(), (boolean)true);
    }

    private final void startFilteringIfPossible(boolean byKey) {
        if (!this.getEnabled()) {
            return;
        }
        if (this.filtering) {
            return;
        }
        String string = this.getInput();
        if (string == null) {
            return;
        }
        String input = string;
        this.startFiltering(input, byKey);
        if (this.getSticky()) {
            this.stickyStateHolder.setValue(true);
        }
    }

    private final void startFiltering(String input, boolean byKey) {
        TreePath[] selections = this.tree.getSelectionPaths();
        this.filtering = true;
        this.startedBySlash = byKey;
        Popup popup2 = this.popup;
        if (popup2 != null) {
            popup2.updateFilterButton();
        }
        this.adjustEmptyText();
        this.filterModel.filter(((Object)StringsKt.trim((CharSequence)input)).toString());
        this.stickyStateHolder.setValue(this.getSticky());
        this.restoreSelections(selections);
    }

    private final void continueFiltering(String input) {
        this.filterModel.filter(((Object)StringsKt.trim((CharSequence)input)).toString());
    }

    private final void pauseFiltering() {
        this.filterModel.reset();
    }

    private final void stopFilteringIfNeeded(boolean preserveSticky) {
        if (!this.filtering) {
            return;
        }
        this.stopFiltering(preserveSticky);
    }

    private final void stopFiltering(boolean preserveSticky) {
        TreePath[] selections = this.tree.getSelectionPaths();
        this.filterModel.reset();
        this.startedBySlash = false;
        this.filtering = false;
        Popup popup2 = this.popup;
        if (popup2 != null) {
            popup2.updateFilterButton();
        }
        if (!preserveSticky) {
            this.stickyStateHolder.setValue(false);
        }
        this.restoreSelections(selections);
        this.restoreEmptyText();
    }

    private final void restoreSelections(TreePath[] selections) {
        if (selections != null && !(selections.length == 0)) {
            TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"getSelectionModel(...)");
            TreeSelectionModel sm = treeSelectionModel;
            sm.setSelectionPaths(selections);
        } else {
            this.tree.clearSelection();
        }
    }

    private final void adjustEmptyText() {
        if (this.tree instanceof ComponentWithEmptyText) {
            this.oldEmptyText = ((ComponentWithEmptyText)this.tree).getEmptyText().getText();
            StatusText statusText = ((ComponentWithEmptyText)this.tree).getEmptyText();
            Supplier<String> supplier = this.nothingFoundTextProvider;
            if (supplier == null || (supplier = supplier.get()) == null) {
                supplier = "nothing found";
            }
            statusText.setText((String)((Object)supplier));
        }
    }

    private final void restoreEmptyText() {
        if (this.tree instanceof ComponentWithEmptyText) {
            StatusText statusText = ((ComponentWithEmptyText)this.tree).getEmptyText();
            String string = this.oldEmptyText;
            if (string == null) {
                string = "";
            }
            statusText.setText(string);
        }
    }

    protected boolean keepEvenWhenFocusLost() {
        return this.filtering;
    }

    public /* synthetic */ TreeFilterSearch(JTree tree2, TreeFilterModel filterModel, Function presentableStringFunction, DefaultConstructorMarker $constructor_marker) {
        this(tree2, filterModel, presentableStringFunction);
    }

    static {
        Icon icon = DatabaseIcons.FunnelGray;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FunnelGray");
        funnelIconLightNormal = icon;
        Icon icon2 = DatabaseIcons.FunnelHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FunnelHover");
        funnelIconLightHover = icon2;
        Icon icon3 = DatabaseIcons.FunnelSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FunnelSelected");
        funnelIconLightActive = icon3;
        Icon icon4 = DatabaseIcons.FunnelGray;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FunnelGray");
        funnelIconDarkNormal = icon4;
        Icon icon5 = DatabaseIcons.FunnelHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"FunnelHover");
        funnelIconDarkHover = icon5;
        Icon icon6 = DatabaseIcons.FunnelSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"FunnelSelected");
        funnelIconDarkActive = icon6;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$Companion;", "", "<init>", "()V", "FIELD_INPLACE_LOOK", "Lcom/intellij/openapi/actionSystem/impl/FieldInplaceActionButtonLook;", "internalStickyStateHolder", "Lcom/intellij/database/util/common/BooleanHolder;", "funnelIconLightNormal", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "funnelIconLightHover", "funnelIconLightActive", "funnelIconDarkNormal", "funnelIconDarkHover", "funnelIconDarkActive", "isLight", "", "()Z", "installOn", "Lcom/intellij/database/view/TreeFilterSearch;", "tree", "Ljavax/swing/JTree;", "filterModel", "Lcom/intellij/database/view/TreeFilterModel;", "presentableStringFunction", "Ljava/util/function/Function;", "Ljavax/swing/tree/TreePath;", "", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLight() {
            return JBColor.isBright();
        }

        @NotNull
        public final TreeFilterSearch installOn(@NotNull JTree tree2, @NotNull TreeFilterModel filterModel, @NotNull Function<? super TreePath, String> presentableStringFunction) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)filterModel, (String)"filterModel");
            Intrinsics.checkNotNullParameter(presentableStringFunction, (String)"presentableStringFunction");
            TreeFilterSearch search = new TreeFilterSearch(tree2, filterModel, presentableStringFunction, null);
            search.setupListeners();
            return search;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "<init>", "(Lcom/intellij/database/view/TreeFilterSearch;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.database.impl"})
    private final class FilterAction
    extends DumbAwareToggleAction
    implements TooltipDescriptionProvider {
        public FilterAction() {
            this.copyFrom(TreeFilterSearch.this.templateAction);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return TreeFilterSearch.this.filtering;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (state) {
                TreeFilterSearch.this.startFilteringIfPossible(false);
            } else {
                boolean withCtrl = (e.getModifiers() & 2) != 0;
                TreeFilterSearch.this.stopFilteringIfNeeded(withCtrl && !TreeFilterSearch.this.startedBySlash);
                if (withCtrl) {
                    TreeFilterSearch.this.hidePopup();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "<init>", "(Lcom/intellij/database/view/TreeFilterSearch$FilterAction;)V", "getIcon", "Ljavax/swing/Icon;", "getPopState", "", "Companion", "intellij.database.impl"})
    private static final class FilterActionButton
    extends ActionButton {
        @NotNull
        private static final Companion Companion = new Companion(null);

        public FilterActionButton(@NotNull FilterAction action) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            super((AnAction)action, Companion.obtainPresentation(action), "TreeFilter", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook((ActionButtonLook)FIELD_INPLACE_LOOK);
            this.updateIcon();
        }

        @NotNull
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            Icon icon = super.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @JvmStatic
        @NotNull
        public static final Presentation obtainPresentation(@NotNull FilterAction action) {
            return Companion.obtainPresentation(action);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton$Companion;", "", "<init>", "()V", "obtainPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "action", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "intellij.database.impl"})
        private static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Presentation obtainPresentation(@NotNull FilterAction action) {
                Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
                Presentation presentation = action.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
                Presentation tp = presentation;
                Presentation presentation2 = tp.clone();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"clone(...)");
                Presentation p2 = presentation2;
                p2.setText(DatabaseBundle.message("tree.filter.button.text", new Object[0]));
                p2.setDescription(DatabaseBundle.message("tree.filter.button.tooltip", new Object[0]));
                if (TreeFilterSearch.Companion.isLight()) {
                    p2.setIcon(funnelIconLightNormal);
                    p2.setHoveredIcon(funnelIconLightHover);
                    p2.setSelectedIcon(funnelIconLightActive);
                } else {
                    p2.setIcon(funnelIconDarkNormal);
                    p2.setHoveredIcon(funnelIconDarkHover);
                    p2.setSelectedIcon(funnelIconDarkActive);
                }
                return p2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00140\u0001R\u0010\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u0002B\u0013\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0012\u0010\t\u001a\u00060\nR\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/TreeFilterSearch$Popup;", "Lcom/intellij/ui/SpeedSearchBase$SearchPopup;", "Lcom/intellij/ui/SpeedSearchBase;", "Ljavax/swing/JTree;", "kotlin.jvm.PlatformType", "initialString", "", "<init>", "(Lcom/intellij/database/view/TreeFilterSearch;Ljava/lang/String;)V", "filterAction", "Lcom/intellij/database/view/TreeFilterSearch$FilterAction;", "Lcom/intellij/database/view/TreeFilterSearch;", "funnelButton", "Lcom/intellij/database/view/TreeFilterSearch$FilterActionButton;", "updateFilterButton", "", "intellij.database.impl"})
    private final class Popup
    extends SpeedSearchBase.SearchPopup {
        @NotNull
        private final FilterAction filterAction;
        @NotNull
        private final FilterActionButton funnelButton;

        public Popup(String initialString) {
            super((SpeedSearchBase)TreeFilterSearch.this, initialString);
            this.filterAction = new FilterAction();
            this.funnelButton = new FilterActionButton(this.filterAction);
            this.mySearchField.setColumns(15);
            this.mySearchField.setMinimumSize((Dimension)new JBDimension(100, 26));
            this.setMinimumSize((Dimension)new JBDimension(126, 26));
            this.add((Component)((Object)this.funnelButton), "East");
            if (TreeFilterSearch.this.getStartingFilterBySlash()) {
                for (Shortcut shortcut : this.filterAction.getShortcutSet().getShortcuts()) {
                    if (!(shortcut instanceof KeyboardShortcut) || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
                    ((JTree)TreeFilterSearch.this.myComponent).registerKeyboardAction(arg_0 -> Popup._init_$lambda$0(this, arg_0), ((KeyboardShortcut)shortcut).getFirstKeyStroke(), 1);
                }
            }
        }

        public final void updateFilterButton() {
            this.funnelButton.update();
        }

        private static final void _init_$lambda$0(Popup this$0, ActionEvent it) {
            this$0.funnelButton.click();
        }
    }
}

