/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a#\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/view/RenameHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/basic/BasicModModel;)V", "scriptingService", "Lcom/intellij/database/script/generator/ScriptGenerator;", "revDeps", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "rename", "", "e", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "newName", "", "fixReferences", "old", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nRenameHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameHelper.kt\ncom/intellij/database/view/RenameHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1869#2,2:45\n1869#2,2:47\n1#3:49\n*S KotlinDebug\n*F\n+ 1 RenameHelper.kt\ncom/intellij/database/view/RenameHelper\n*L\n15#1:45,2\n42#1:47,2\n*E\n"})
public final class RenameHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final BasicModModel model;
    @NotNull
    private final ScriptGenerator scriptingService;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> revDeps;

    public RenameHelper(@NotNull Project project, @NotNull BasicModModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.project = project;
        this.model = model;
        this.scriptingService = ScriptGenerators.INSTANCE.byModel(this.model);
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        this.revDeps = multiMap;
        Iterator iterator = this.model.basicTraverser().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterable<? extends BasicElement> $this$forEach$iv;
            BasicElement e = (BasicElement)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e.getPredecessors(), (String)"getPredecessors(...)");
            boolean $i$f$forEach = false;
            Iterator<? extends BasicElement> iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                BasicElement element$iv;
                BasicElement it = element$iv = iterator3.next();
                boolean bl = false;
                if (it == null) continue;
                this.revDeps.putValue((Object)it, (Object)e);
            }
        }
    }

    public final void rename(@NotNull BasicModNamedElement e, @NotNull String newName) {
        CompositeText src;
        BasicModSourceAware sa;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (Intrinsics.areEqual((Object)e.getName(), (Object)newName)) {
            return;
        }
        BasicModSourceAware basicModSourceAware = sa = e instanceof BasicModSourceAware ? (BasicModSourceAware)e : null;
        CompositeText compositeText = src = basicModSourceAware != null ? basicModSourceAware.getSourceTextOrPlaceholder() : null;
        if (src != null) {
            this.model.writeSources(() -> RenameHelper.rename$lambda$4(sa, this, e, newName, src));
        } else {
            this.fixReferences(e, newName);
            e.setName(newName);
        }
    }

    private final void fixReferences(BasicElement e, String old2) {
        Collection collection = this.revDeps.get((Object)e);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            BasicModElement basicModElement = it instanceof BasicModElement ? (BasicModElement)it : null;
            if (basicModElement == null) continue;
            basicModElement.fixReference(e, old2);
        }
    }

    private static final void rename$lambda$4(BasicModSourceAware $sa, RenameHelper this$0, BasicModNamedElement $e, String $newName, CompositeText $src) {
        block2: {
            $sa.setSourceText(null);
            this$0.fixReferences($e, $newName);
            BasicModNamedElement basicModNamedElement = $e;
            Intrinsics.checkNotNull((Object)basicModNamedElement, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModNamedElement");
            basicModNamedElement.setName($newName);
            $sa.setSourceText($src);
            CompositeText compositeText = this$0.scriptingService.reviseSource(this$0.project, $sa);
            if (compositeText != null) {
                CompositeText it = compositeText;
                boolean bl = false;
                $sa.setSourceText(it);
            }
            ModFamily modFamily = (ModFamily)((BasicModSourceAware)$e).familyOf(ObjectKind.BODY);
            BasicModElement basicModElement = modFamily != null ? (BasicModElement)CollectionsKt.firstOrNull((Iterable)modFamily) : null;
            BasicModSourceAware basicModSourceAware = basicModElement instanceof BasicModSourceAware ? (BasicModSourceAware)basicModElement : null;
            if (basicModSourceAware == null) break block2;
            BasicModSourceAware body2 = basicModSourceAware;
            boolean bl = false;
            CompositeText compositeText2 = this$0.scriptingService.reviseSource(this$0.project, body2);
            if (compositeText2 != null) {
                CompositeText it = compositeText2;
                boolean bl2 = false;
                body2.setSourceText(it);
            }
        }
    }
}

