/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/DatabaseRefactoringHandler;", "Lcom/intellij/database/view/AbstractDatabaseModifier;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "myRefactoringExecutor", "Lcom/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor;", "setStatement", "statement", "", "getStatement", "getExecutor", "Lcom/intellij/database/view/AbstractDatabaseModifier$QueryExecutor;", "RefactoringExecutor", "Companion", "intellij.database.impl"})
public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DatabaseDepartment databaseDepartment = DGDepartment.REFACTORING;
        String string = DatabaseBundle.message("progress.title.updating.database", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, dataSource, searchPath, databaseDepartment, string);
        this.myRefactoringExecutor = new RefactoringExecutor(project, dataSource);
    }

    @NotNull
    public final DatabaseRefactoringHandler setStatement(@NotNull String statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.myRefactoringExecutor.setStatement(statement2);
        return this;
    }

    @NotNull
    public final String getStatement() {
        return this.myRefactoringExecutor.getStatement();
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        return this.myRefactoringExecutor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/DatabaseRefactoringHandler$Companion;", "", "<init>", "()V", "executeQueries", "", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "path", "Lcom/intellij/database/util/SearchPath;", "queries", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createErrorChecker", "Lkotlin/Function1;", "", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int executeQueries(Project project, DatabaseConnection connection2, SearchPath path, List<String> queries, ProgressIndicator indicator) {
            int totalCount = queries.size();
            int count = 0;
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            Function1<String, Unit> errorChecker = this.createErrorChecker(project, connection2, path);
            AutoCloseable autoCloseable = SmartStatements.Companion.poweredBy(connection2).simple().reuse();
            Throwable throwable = null;
            try {
                ReusableSmartStatement statement2 = (ReusableSmartStatement)autoCloseable;
                boolean bl = false;
                Iterator<String> iterator = queries.iterator();
                while (iterator.hasNext()) {
                    String query;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    if (StringsKt.isBlank((CharSequence)query)) {
                        ++count;
                        continue;
                    }
                    indicator.checkCanceled();
                    try {
                        statement2.barren().execute(query, StandardExecutionMode.UPDATE);
                        indicator.setFraction((double)(++count) / (double)totalCount);
                        errorChecker.invoke((Object)query);
                    }
                    catch (Exception e) {
                        int n = count;
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        return n;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            indicator.setIndeterminate(true);
            return count;
        }

        private final Function1<String, Unit> createErrorChecker(Project project, DatabaseConnection connection2, SearchPath path) {
            JdbcConsole.RawErrorsObtainer errorsObtainer;
            DataAuditor dataAuditor = JdbcConsole.createAdvancedErrorsObtainer(project, connection2.getConnectionPoint().getDataSource());
            JdbcConsole.RawErrorsObtainer rawErrorsObtainer = errorsObtainer = dataAuditor instanceof JdbcConsole.RawErrorsObtainer ? (JdbcConsole.RawErrorsObtainer)dataAuditor : null;
            if (errorsObtainer == null) {
                return Companion::createErrorChecker$lambda$1;
            }
            AdvancedAuditService advancedAuditService = connection2.getAuditService();
            Intrinsics.checkNotNullExpressionValue((Object)advancedAuditService, (String)"getAuditService(...)");
            AdvancedAuditService service = advancedAuditService;
            return arg_0 -> Companion.createErrorChecker$lambda$3(errorsObtainer, connection2, path, service, arg_0);
        }

        private static final Unit createErrorChecker$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final void createErrorChecker$lambda$3$lambda$2(AdvancedAuditService $service, Throwable th) {
            Intrinsics.checkNotNull((Object)th);
            $service.warning(th);
        }

        private static final Unit createErrorChecker$lambda$3(JdbcConsole.RawErrorsObtainer $errorsObtainer, DatabaseConnection $connection, SearchPath $path, AdvancedAuditService $service, String q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            $errorsObtainer.obtainErrors(q, $connection, $path, arg_0 -> Companion.createErrorChecker$lambda$3$lambda$2($service, arg_0));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor;", "Lcom/intellij/database/view/AbstractDatabaseModifier$QueryExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "myStatement", "", "myProject", "myDataSource", "setStatement", "", "statement", "getStatement", "execute", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "facade", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;Lcom/intellij/database/util/ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "path", "Lcom/intellij/database/util/SearchPath;", "intellij.database.impl"})
    private static final class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        @NotNull
        private final Project myProject;
        @NotNull
        private final LocalDataSource myDataSource;

        public RefactoringExecutor(@NotNull Project project, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            this.myStatement = "";
            this.myProject = project;
            this.myDataSource = dataSource;
        }

        public final void setStatement(@NotNull String statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            this.myStatement = statement2;
        }

        @NotNull
        public final String getStatement() {
            return this.myStatement;
        }

        @Override
        @Nullable
        public Object execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade, @NotNull ErrorHandler errorHandler, @NotNull Continuation<? super Boolean> $completion) {
            String string = DatabaseBundle.message("progress.title.execute", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)AsyncTask.Companion.frame(string).getElement()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(facade, indicator, this, null){
                int label;
                final /* synthetic */ DatabaseSessionManager.Facade $facade;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ RefactoringExecutor this$0;
                {
                    this.$facade = $facade;
                    this.$indicator = $indicator;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$facade.run(arg_0 -> execute.2.invokeSuspend$lambda$1(this.$indicator, this.this$0, this.$facade, arg_0), (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final boolean invokeSuspend$lambda$1$lambda$0(ProgressIndicator $indicator, RefactoringExecutor this$0, InterruptibleDatabaseConnection $connection, DatabaseSessionManager.Facade $facade) {
                    $indicator.setText(DatabaseBundle.message("progress.text.updating.database", new Object[0]));
                    return this$0.execute($indicator, $connection, $facade.getPath());
                }

                private static final boolean invokeSuspend$lambda$1(ProgressIndicator $indicator, RefactoringExecutor this$0, DatabaseSessionManager.Facade $facade, InterruptibleDatabaseConnection connection2) {
                    return (Boolean)InterruptibleDatabaseConnectionKt.withCancelling(connection2, $indicator, () -> execute.2.invokeSuspend$lambda$1$lambda$0($indicator, this$0, connection2, $facade));
                }
            }), $completion);
        }

        public final boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection2, @Nullable SearchPath path) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            List<String> list = DbSqlUtilCore.getQueries(this.myStatement, this.myProject, DbSqlUtilCore.getLanguage(this.myDataSource));
            Intrinsics.checkNotNullExpressionValue(list, (String)"getQueries(...)");
            List<String> queries = list;
            return queries.size() == Companion.executeQueries(this.myProject, connection2, path, queries, indicator);
        }
    }
}

