/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/view/DataSourcePromoNotificationListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "Companion", "intellij.database.impl"})
public final class DataSourcePromoNotificationListener
implements DataSourceManager.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public DataSourcePromoNotificationListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
        Companion.showPromoNotificationIfNeeded(this.project);
    }

    @JvmStatic
    public static final void showPromoNotificationIfNeeded(@NotNull Project project) {
        Companion.showPromoNotificationIfNeeded(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DataSourcePromoNotificationListener$Companion;", "", "<init>", "()V", "showPromoNotificationIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "canShowNotification", "", "isEnoughDataSources", "isNotificationNotExpired", "setShown", "isShown", "createNotification", "Lcom/intellij/notification/Notification;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void showPromoNotificationIfNeeded(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.canShowNotification(project)) {
                return;
            }
            this.createNotification().notify(project);
            this.setShown(project);
        }

        private final boolean canShowNotification(Project project) {
            return this.isEnoughDataSources(project) && PlatformUtils.isPyCharm() && !this.isShown(project) && this.isNotificationNotExpired();
        }

        private final boolean isEnoughDataSources(Project project) {
            List list = LocalDataSourceManager.getInstance(project).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            List dataSources = list;
            return dataSources.size() >= 5;
        }

        private final boolean isNotificationNotExpired() {
            return LocalDate.now().compareTo(LocalDate.of(2025, 9, 30)) < 0;
        }

        private final void setShown(Project project) {
            PropertiesComponent.getInstance((Project)project).setValue("data.grip.promo.notification.shown", "true");
        }

        private final boolean isShown(Project project) {
            String string = PropertiesComponent.getInstance((Project)project).getValue("data.grip.promo.notification.shown");
            return string != null ? Intrinsics.areEqual((Object)StringsKt.toBooleanStrictOrNull((String)string), (Object)true) : false;
        }

        private final Notification createNotification() {
            Notification notification;
            Notification $this$createNotification_u24lambda_u240 = notification = new Notification(DatabaseBundle.message("data.grip.promo.notification.groupName", new Object[0]), DatabaseBundle.message("data.grip.promo.notification.title", new Object[0]), DatabaseBundle.message("data.grip.promo.notification.message", new Object[0]), NotificationType.INFORMATION);
            boolean bl = false;
            $this$createNotification_u24lambda_u240.addAction((AnAction)new BrowseNotificationAction(DatabaseBundle.message("data.grip.promo.notification.action", new Object[0]), DatabaseBundle.message("data.grip.promo.notification.action.url", new Object[0])));
            return notification;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

