/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.Serializable;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/AutoRefreshExpansionListener;", "Ljavax/swing/event/TreeExpansionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "treeExpanded", "", "event", "Ljavax/swing/event/TreeExpansionEvent;", "treeCollapsed", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nAutoRefreshExpansionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoRefreshExpansionListener.kt\ncom/intellij/database/view/AutoRefreshExpansionListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,37:1\n40#2,3:38\n*S KotlinDebug\n*F\n+ 1 AutoRefreshExpansionListener.kt\ncom/intellij/database/view/AutoRefreshExpansionListener\n*L\n24#1:38,3\n*E\n"})
public final class AutoRefreshExpansionListener
implements TreeExpansionListener {
    @NotNull
    private final Project project;

    public AutoRefreshExpansionListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void treeExpanded(@Nullable TreeExpansionEvent event) {
        Serializable serializable = event;
        if (serializable == null || (serializable = serializable.getPath()) == null) {
            return;
        }
        Serializable path = serializable;
        Object object = (DataSourceNode)TreeUtil.getLastUserObject(DataSourceNode.class, (TreePath)path);
        if (object == null || (object = ((DataSourceNode)object).getLocalDataSource()) == null) {
            return;
        }
        Object dataSource = object;
        DasModel dasModel = ((LocalDataSource)dataSource).getModel();
        BasicModel model = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        CasingProvider casingProvider = model;
        boolean introspected = (casingProvider != null && (casingProvider = casingProvider.getRoot()) != null && (casingProvider = casingProvider.getCurrentDatabase()) != null && (casingProvider = ModelFun.getCurrentSchema((BasicDatabase)casingProvider)) != null ? casingProvider.getLastIntrospectionLocalTimestamp() : null) != null;
        boolean $i$f$service = false;
        Class<DataSourceSyncManager> serviceClass$iv = DataSourceSyncManager.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        boolean isAlreadyActive = ((DataSourceSyncManager)object2).isActive((DasDataSource)dataSource);
        if (((LocalDataSource)dataSource).isAutoSynchronize() && !isAlreadyActive && !introspected && !DbImplUtil.isConnected(this.project, (LocalDataSource)dataSource)) {
            String string = ((AbstractDataSource)dataSource).getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask(string);
            RunIntrospection.runAsyncIntrospection(this.project, (LocalDataSource)dataSource, task);
        }
    }

    @Override
    public void treeCollapsed(@Nullable TreeExpansionEvent event) {
    }
}

